/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.boot.CoreExtensionFeature;
import net.nemerosa.ontrack.boot.ProjectSearchItem;
import net.nemerosa.ontrack.boot.ProjectSearchProvider;
import net.nemerosa.ontrack.job.Schedule;
import net.nemerosa.ontrack.model.events.Event;
import net.nemerosa.ontrack.model.events.EventFactory;
import net.nemerosa.ontrack.model.events.EventListener;
import net.nemerosa.ontrack.model.events.EventType;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.SearchIndexMapping;
import net.nemerosa.ontrack.model.structure.SearchIndexMappingExtensionsKt;
import net.nemerosa.ontrack.model.structure.SearchIndexService;
import net.nemerosa.ontrack.model.structure.SearchIndexServiceKt;
import net.nemerosa.ontrack.model.structure.SearchIndexer;
import net.nemerosa.ontrack.model.structure.SearchItem;
import net.nemerosa.ontrack.model.structure.SearchResult;
import net.nemerosa.ontrack.model.structure.SearchResultType;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.ui.controller.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001a0\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\"\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\f\u0010'\u001a\u00020\u0002*\u00020(H\u0012R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lnet/nemerosa/ontrack/boot/ProjectSearchProvider;", "Lnet/nemerosa/ontrack/model/structure/SearchIndexer;", "Lnet/nemerosa/ontrack/boot/ProjectSearchItem;", "Lnet/nemerosa/ontrack/model/events/EventListener;", "uriBuilder", "Lnet/nemerosa/ontrack/ui/controller/URIBuilder;", "structureService", "Lnet/nemerosa/ontrack/model/structure/StructureService;", "searchIndexService", "Lnet/nemerosa/ontrack/model/structure/SearchIndexService;", "(Lnet/nemerosa/ontrack/ui/controller/URIBuilder;Lnet/nemerosa/ontrack/model/structure/StructureService;Lnet/nemerosa/ontrack/model/structure/SearchIndexService;)V", "indexMapping", "Lnet/nemerosa/ontrack/model/structure/SearchIndexMapping;", "getIndexMapping", "()Lnet/nemerosa/ontrack/model/structure/SearchIndexMapping;", "indexName", "", "getIndexName", "()Ljava/lang/String;", "indexerName", "getIndexerName", "searchResultType", "Lnet/nemerosa/ontrack/model/structure/SearchResultType;", "getSearchResultType", "()Lnet/nemerosa/ontrack/model/structure/SearchResultType;", "indexAll", "", "processor", "Lkotlin/Function1;", "onEvent", "event", "Lnet/nemerosa/ontrack/model/events/Event;", "toSearchResult", "Lnet/nemerosa/ontrack/model/structure/SearchResult;", "id", "score", "", "source", "Lcom/fasterxml/jackson/databind/JsonNode;", "asSearchItem", "Lnet/nemerosa/ontrack/model/structure/Project;", "ontrack-ui"})
public class ProjectSearchProvider
implements SearchIndexer<ProjectSearchItem>,
EventListener {
    @NotNull
    private final SearchResultType searchResultType;
    @NotNull
    private final String indexerName;
    @NotNull
    private final String indexName;
    @NotNull
    private final SearchIndexMapping indexMapping;
    private final URIBuilder uriBuilder;
    private final StructureService structureService;
    private final SearchIndexService searchIndexService;

    @NotNull
    public SearchResultType getSearchResultType() {
        return this.searchResultType;
    }

    @NotNull
    public String getIndexerName() {
        return this.indexerName;
    }

    @NotNull
    public String getIndexName() {
        return this.indexName;
    }

    @NotNull
    public SearchIndexMapping getIndexMapping() {
        return this.indexMapping;
    }

    public void indexAll(@NotNull Function1<? super ProjectSearchItem, Unit> processor) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Iterable $this$forEach$iv = this.structureService.getProjectList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project project = (Project)element$iv;
            boolean bl = false;
            processor.invoke((Object)this.asSearchItem(project));
        }
    }

    @Nullable
    public SearchResult toSearchResult(@NotNull String id, double score, @NotNull JsonNode source) {
        SearchResult searchResult;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String string = id;
        boolean bl = false;
        Project project = this.structureService.findProjectByID(ID.Companion.of(Integer.parseInt(string)));
        if (project != null) {
            string = project;
            bl = false;
            boolean bl2 = false;
            String $this$run = string;
            boolean bl3 = false;
            String string2 = $this$run.getEntityDisplayName();
            String string3 = $this$run.getDescription();
            if (string3 == null) {
                string3 = "";
            }
            URI uRI = this.uriBuilder.getEntityURI((ProjectEntity)$this$run);
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"uriBuilder.getEntityURI(this)");
            URI uRI2 = this.uriBuilder.getEntityPage((ProjectEntity)$this$run);
            Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"uriBuilder.getEntityPage(this)");
            searchResult = new SearchResult(string2, string3, uRI, uRI2, score, this.getSearchResultType(), null, 64, null);
        } else {
            searchResult = null;
        }
        return searchResult;
    }

    public void onEvent(@NotNull Event event) {
        block1: {
            EventType eventType;
            block2: {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    eventType = event.getEventType();
                    if (!Intrinsics.areEqual((Object)eventType, (Object)EventFactory.NEW_PROJECT)) break block0;
                    Project project = (Project)event.getEntity(ProjectEntityType.PROJECT);
                    SearchIndexer searchIndexer = (SearchIndexer)this;
                    Project project2 = project;
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                    this.searchIndexService.createSearchIndex(searchIndexer, (SearchItem)this.asSearchItem(project2));
                    break block1;
                }
                if (!Intrinsics.areEqual((Object)eventType, (Object)EventFactory.UPDATE_PROJECT)) break block2;
                Project project = (Project)event.getEntity(ProjectEntityType.PROJECT);
                SearchIndexer searchIndexer = (SearchIndexer)this;
                Project project3 = project;
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
                this.searchIndexService.updateSearchIndex(searchIndexer, (SearchItem)this.asSearchItem(project3));
                break block1;
            }
            if (!Intrinsics.areEqual((Object)eventType, (Object)EventFactory.DELETE_PROJECT)) break block1;
            int projectId = event.getIntValue("project_id");
            SearchIndexServiceKt.deleteSearchIndex((SearchIndexService)this.searchIndexService, (SearchIndexer)((SearchIndexer)this), (Object)projectId);
        }
    }

    private ProjectSearchItem asSearchItem(Project $this$asSearchItem) {
        return new ProjectSearchItem($this$asSearchItem);
    }

    public ProjectSearchProvider(@NotNull URIBuilder uriBuilder, @NotNull StructureService structureService, @NotNull SearchIndexService searchIndexService) {
        Intrinsics.checkNotNullParameter((Object)uriBuilder, (String)"uriBuilder");
        Intrinsics.checkNotNullParameter((Object)structureService, (String)"structureService");
        Intrinsics.checkNotNullParameter((Object)searchIndexService, (String)"searchIndexService");
        this.uriBuilder = uriBuilder;
        this.structureService = structureService;
        this.searchIndexService = searchIndexService;
        this.searchResultType = new SearchResultType(CoreExtensionFeature.Companion.getINSTANCE().getFeatureDescription(), "project", "Project", "Project name in Ontrack");
        this.indexerName = "Projects";
        this.indexName = "projects";
        this.indexMapping = SearchIndexMappingExtensionsKt.indexMappings((Function1)((Function1)indexMapping.1.INSTANCE));
    }

    @Nullable
    public Integer getIndexBatch() {
        return SearchIndexer.DefaultImpls.getIndexBatch((SearchIndexer)this);
    }

    @NotNull
    public String getIndexerId() {
        return SearchIndexer.DefaultImpls.getIndexerId((SearchIndexer)this);
    }

    @NotNull
    public Schedule getIndexerSchedule() {
        return SearchIndexer.DefaultImpls.getIndexerSchedule((SearchIndexer)this);
    }

    public boolean isIndexationDisabled() {
        return SearchIndexer.DefaultImpls.isIndexationDisabled((SearchIndexer)this);
    }
}

