/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.support;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.nemerosa.ontrack.common.Time;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lnet/nemerosa/ontrack/boot/support/LocalDateTimeConverter;", "Lorg/springframework/core/convert/converter/Converter;", "", "Ljava/time/LocalDateTime;", "()V", "convert", "source", "ontrack-ui"})
public class LocalDateTimeConverter
implements Converter<String, LocalDateTime> {
    @Nullable
    public LocalDateTime convert(@NotNull String source) {
        LocalDateTime localDateTime;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (StringsKt.isBlank((CharSequence)source)) {
            localDateTime = null;
        } else {
            ZonedDateTime zonedDateTime;
            ZonedDateTime zonedDateTime2 = zonedDateTime = ZonedDateTime.parse(source);
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"zonedDateTime");
            localDateTime = Time.INSTANCE.toLocalDateTime(zonedDateTime2);
        }
        return localDateTime;
    }
}

