/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.support;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.nemerosa.ontrack.boot.support.LoginSuccessHandler;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.Base64Utils;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnet/nemerosa/ontrack/boot/support/LoginSuccessHandler;", "Lorg/springframework/security/web/authentication/SimpleUrlAuthenticationSuccessHandler;", "()V", "requestCache", "Lorg/springframework/security/web/savedrequest/RequestCache;", "determineTargetUrl", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "response", "Ljavax/servlet/http/HttpServletResponse;", "Companion", "ontrack-ui"})
public final class LoginSuccessHandler
extends SimpleUrlAuthenticationSuccessHandler {
    private final RequestCache requestCache = (RequestCache)new HttpSessionRequestCache();
    @NotNull
    public static final String COOKIE_HASH_PART = "hashPart";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected String determineTargetUrl(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        Object object = savedRequest;
        if (object == null || (object = object.getRedirectUrl()) == null) {
            object = super.determineTargetUrl(request, response);
        }
        Object targetUrl = object;
        Cookie[] cookieArray = request.getCookies();
        int n = cookieArray.length;
        for (int i = 0; i < n; ++i) {
            Cookie cookie;
            Cookie cookie2 = cookie = cookieArray[i];
            Intrinsics.checkNotNullExpressionValue((Object)cookie2, (String)"cookie");
            if (!Intrinsics.areEqual((Object)cookie2.getName(), (Object)COOKIE_HASH_PART)) continue;
            String value = cookie.getValue();
            CharSequence charSequence = value;
            boolean bl = false;
            boolean bl2 = false;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                byte[] byArray = Base64Utils.decodeFromString((String)value);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Base64Utils.decodeFromString(value)");
                byte[] byArray2 = byArray;
                bl2 = false;
                String actualValue = new String(byArray2, Charsets.UTF_8);
                targetUrl = (String)targetUrl + actualValue;
            }
            cookie.setMaxAge(0);
            response.addCookie(cookie);
            break;
        }
        this.logger.debug((Object)("Login target URL = " + (String)targetUrl));
        Object object2 = targetUrl;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"targetUrl");
        return object2;
    }
}

