/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.support;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.nemerosa.ontrack.model.security.TokenAuthenticationToken;
import net.nemerosa.ontrack.model.structure.TokensService;
import org.apache.commons.logging.Log;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.NullRememberMeServices;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.web.filter.OncePerRequestFilter;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J \u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnet/nemerosa/ontrack/boot/support/TokenHeaderAuthenticationFilter;", "Lorg/springframework/web/filter/OncePerRequestFilter;", "authenticationManager", "Lorg/springframework/security/authentication/AuthenticationManager;", "tokensService", "Lnet/nemerosa/ontrack/model/structure/TokensService;", "headerName", "", "authenticationEntryPoint", "Lorg/springframework/security/web/AuthenticationEntryPoint;", "rememberMeServices", "Lorg/springframework/security/web/authentication/RememberMeServices;", "isIgnoreFailure", "", "(Lorg/springframework/security/authentication/AuthenticationManager;Lnet/nemerosa/ontrack/model/structure/TokensService;Ljava/lang/String;Lorg/springframework/security/web/AuthenticationEntryPoint;Lorg/springframework/security/web/authentication/RememberMeServices;Z)V", "afterPropertiesSet", "", "authenticationIsRequired", "token", "doFilterInternal", "request", "Ljavax/servlet/http/HttpServletRequest;", "response", "Ljavax/servlet/http/HttpServletResponse;", "chain", "Ljavax/servlet/FilterChain;", "ontrack-ui"})
public final class TokenHeaderAuthenticationFilter
extends OncePerRequestFilter {
    private final AuthenticationManager authenticationManager;
    private final TokensService tokensService;
    private final String headerName;
    private final AuthenticationEntryPoint authenticationEntryPoint;
    private final RememberMeServices rememberMeServices;
    private final boolean isIgnoreFailure;

    public void afterPropertiesSet() {
        if (!this.isIgnoreFailure) {
            AuthenticationEntryPoint authenticationEntryPoint = this.authenticationEntryPoint;
            boolean bl = false;
            boolean bl2 = false;
            if (authenticationEntryPoint == null) {
                boolean bl3 = false;
                String string = "An AuthenticationEntryPoint is required";
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
    }

    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain chain) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Log log = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)log, (String)"logger");
        boolean debug = log.isDebugEnabled();
        try {
            String token = request.getHeader(this.headerName);
            CharSequence charSequence = token;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (this.authenticationIsRequired(token)) {
                TokenAuthenticationToken authRequest = new TokenAuthenticationToken(token);
                Authentication authResult = this.authenticationManager.authenticate((Authentication)authRequest);
                if (debug) {
                    this.logger.debug((Object)("Authentication success: " + authResult));
                }
                SecurityContext securityContext = SecurityContextHolder.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)securityContext, (String)"SecurityContextHolder.getContext()");
                securityContext.setAuthentication(authResult);
                this.rememberMeServices.loginSuccess(request, response, authResult);
            }
        }
        catch (AuthenticationException failed) {
            SecurityContextHolder.clearContext();
            if (debug) {
                this.logger.debug((Object)"Authentication request for failed!", (Throwable)failed);
            }
            this.rememberMeServices.loginFail(request, response);
            if (this.isIgnoreFailure) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                AuthenticationEntryPoint authenticationEntryPoint = this.authenticationEntryPoint;
                if (authenticationEntryPoint != null) {
                    AuthenticationEntryPoint authenticationEntryPoint2 = authenticationEntryPoint;
                    boolean bl = false;
                    boolean bl3 = false;
                    AuthenticationEntryPoint $this$apply = authenticationEntryPoint2;
                    boolean bl4 = false;
                    $this$apply.commence(request, response, failed);
                }
            }
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private final boolean authenticationIsRequired(String token) {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)securityContext, (String)"SecurityContextHolder.getContext()");
        Authentication existingAuth = securityContext.getAuthentication();
        if (existingAuth == null || !existingAuth.isAuthenticated()) {
            return true;
        }
        return existingAuth instanceof TokenAuthenticationToken && (!((TokenAuthenticationToken)existingAuth).matches(token) || !this.tokensService.isValid(token));
    }

    public TokenHeaderAuthenticationFilter(@NotNull AuthenticationManager authenticationManager, @NotNull TokensService tokensService, @NotNull String headerName, @Nullable AuthenticationEntryPoint authenticationEntryPoint, @NotNull RememberMeServices rememberMeServices, boolean isIgnoreFailure) {
        Intrinsics.checkNotNullParameter((Object)authenticationManager, (String)"authenticationManager");
        Intrinsics.checkNotNullParameter((Object)tokensService, (String)"tokensService");
        Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
        Intrinsics.checkNotNullParameter((Object)rememberMeServices, (String)"rememberMeServices");
        this.authenticationManager = authenticationManager;
        this.tokensService = tokensService;
        this.headerName = headerName;
        this.authenticationEntryPoint = authenticationEntryPoint;
        this.rememberMeServices = rememberMeServices;
        this.isIgnoreFailure = isIgnoreFailure;
    }

    public /* synthetic */ TokenHeaderAuthenticationFilter(AuthenticationManager authenticationManager, TokensService tokensService, String string, AuthenticationEntryPoint authenticationEntryPoint, RememberMeServices rememberMeServices, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = "X-Ontrack-Token";
        }
        if ((n & 8) != 0) {
            authenticationEntryPoint = null;
        }
        if ((n & 0x10) != 0) {
            rememberMeServices = (RememberMeServices)new NullRememberMeServices();
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        this(authenticationManager, tokensService, string, authenticationEntryPoint, rememberMeServices, bl);
    }
}

