/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.security.AccountGroupMapping;
import net.nemerosa.ontrack.model.security.AccountGroupMappingInput;
import net.nemerosa.ontrack.model.security.AccountGroupMappingService;
import net.nemerosa.ontrack.model.security.AuthenticationSource;
import net.nemerosa.ontrack.model.security.AuthenticationSourceRepository;
import net.nemerosa.ontrack.model.security.ProvidedGroupsService;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/group-mappings"})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ,\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0017J,\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\n2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r2\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017J(\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00160\n2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\rH\u0017J2\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00160\n2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r2\b\b\u0001\u0010\u0018\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lnet/nemerosa/ontrack/boot/ui/AccountGroupMappingController;", "Lnet/nemerosa/ontrack/ui/controller/AbstractResourceController;", "accountGroupMappingService", "Lnet/nemerosa/ontrack/model/security/AccountGroupMappingService;", "providedGroupsService", "Lnet/nemerosa/ontrack/model/security/ProvidedGroupsService;", "authenticationSourceRepository", "Lnet/nemerosa/ontrack/model/security/AuthenticationSourceRepository;", "(Lnet/nemerosa/ontrack/model/security/AccountGroupMappingService;Lnet/nemerosa/ontrack/model/security/ProvidedGroupsService;Lnet/nemerosa/ontrack/model/security/AuthenticationSourceRepository;)V", "createMapping", "Lorg/springframework/http/ResponseEntity;", "Lnet/nemerosa/ontrack/model/security/AccountGroupMapping;", "provider", "", "source", "input", "Lnet/nemerosa/ontrack/model/security/AccountGroupMappingInput;", "deleteMapping", "Lnet/nemerosa/ontrack/model/Ack;", "id", "Lnet/nemerosa/ontrack/model/structure/ID;", "getMappings", "", "getSuggestedMappings", "token", "ontrack-ui"})
public class AccountGroupMappingController
extends AbstractResourceController {
    private final AccountGroupMappingService accountGroupMappingService;
    private final ProvidedGroupsService providedGroupsService;
    private final AuthenticationSourceRepository authenticationSourceRepository;

    @GetMapping(value={"{provider}/{source}"})
    @NotNull
    public ResponseEntity<List<AccountGroupMapping>> getMappings(@PathVariable @NotNull String provider, @PathVariable @NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        AuthenticationSource authenticationSource = this.authenticationSourceRepository.getRequiredAuthenticationSource(provider, source);
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.accountGroupMappingService.getMappings(authenticationSource));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ResponseEntity.ok(accoun\u2026gs(authenticationSource))");
        return responseEntity;
    }

    @PostMapping(value={"{provider}/{source}"})
    @NotNull
    public ResponseEntity<AccountGroupMapping> createMapping(@PathVariable @NotNull String provider, @PathVariable @NotNull String source, @RequestBody @NotNull AccountGroupMappingInput input) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        AuthenticationSource authenticationSource = this.authenticationSourceRepository.getRequiredAuthenticationSource(provider, source);
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.accountGroupMappingService.newMapping(authenticationSource, input));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ResponseEntity.ok(accoun\u2026enticationSource, input))");
        return responseEntity;
    }

    @DeleteMapping(value={"{provider}/{source}/{id}"})
    @NotNull
    public ResponseEntity<Ack> deleteMapping(@PathVariable @NotNull String provider, @PathVariable @NotNull String source, @PathVariable @NotNull ID id) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        AuthenticationSource authenticationSource = this.authenticationSourceRepository.getRequiredAuthenticationSource(provider, source);
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.accountGroupMappingService.deleteMapping(authenticationSource, id));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ResponseEntity.ok(accoun\u2026uthenticationSource, id))");
        return responseEntity;
    }

    @GetMapping(value={"{provider}/{source}/search/{token:.*}"})
    @NotNull
    public ResponseEntity<List<String>> getSuggestedMappings(@PathVariable @NotNull String provider, @PathVariable @NotNull String source, @PathVariable @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        AuthenticationSource authenticationSource = this.authenticationSourceRepository.getRequiredAuthenticationSource(provider, source);
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.providedGroupsService.getSuggestedGroups(authenticationSource, token));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ResponseEntity.ok(\n     \u2026nSource, token)\n        )");
        return responseEntity;
    }

    public AccountGroupMappingController(@NotNull AccountGroupMappingService accountGroupMappingService, @NotNull ProvidedGroupsService providedGroupsService, @NotNull AuthenticationSourceRepository authenticationSourceRepository) {
        Intrinsics.checkNotNullParameter((Object)accountGroupMappingService, (String)"accountGroupMappingService");
        Intrinsics.checkNotNullParameter((Object)providedGroupsService, (String)"providedGroupsService");
        Intrinsics.checkNotNullParameter((Object)authenticationSourceRepository, (String)"authenticationSourceRepository");
        this.accountGroupMappingService = accountGroupMappingService;
        this.providedGroupsService = providedGroupsService;
        this.authenticationSourceRepository = authenticationSourceRepository;
    }
}

