/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import net.nemerosa.ontrack.extension.api.BuildDiffExtension;
import net.nemerosa.ontrack.extension.api.ExtensionManager;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Int;
import net.nemerosa.ontrack.model.form.Selection;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.BuildLinkForm;
import net.nemerosa.ontrack.model.structure.BuildRequest;
import net.nemerosa.ontrack.model.structure.BuildSearchForm;
import net.nemerosa.ontrack.model.structure.BuildView;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.PropertyCreationRequest;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.structure.PropertyTypeDescriptor;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.model.structure.SignatureRequest;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.model.support.Action;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.Resource;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/rest/structure"})
public class BuildController
extends AbstractResourceController {
    private final StructureService structureService;
    private final PropertyService propertyService;
    private final SecurityService securityService;
    private final ExtensionManager extensionManager;

    @Autowired
    public BuildController(StructureService structureService, PropertyService propertyService, SecurityService securityService, ExtensionManager extensionManager) {
        this.structureService = structureService;
        this.propertyService = propertyService;
        this.securityService = securityService;
        this.extensionManager = extensionManager;
    }

    @RequestMapping(value={"project/{projectId}/builds"}, method={RequestMethod.GET})
    public Resource<Form> buildSearchForm(@PathVariable ID projectId) {
        return (Resource)Resource.of((Object)this.createBuildSearchForm(), (URI)this.uri((Object)((BuildController)MvcUriComponentsBuilder.on(this.getClass())).buildSearchForm(projectId))).with("_search", this.uri((Object)((BuildController)MvcUriComponentsBuilder.on(this.getClass())).buildSearch(projectId, null)));
    }

    private Form createBuildSearchForm() {
        List properties = this.propertyService.getPropertyTypes().stream().filter(type -> type.getSupportedEntityTypes().contains(ProjectEntityType.BUILD)).map(PropertyTypeDescriptor::of).collect(Collectors.toList());
        return Form.create().with((Field)((Int)((Int)Int.of((String)"maximumCount").label("Maximum number")).help("Maximum number of builds to return.")).min(1).value((Object)10)).with((Field)((Text)((Text)Text.of((String)"branchName").label("Branch name")).help("Regular expression for the branch name")).optional()).with((Field)((Text)((Text)Text.of((String)"buildName").label("Build name")).help("Regular expression for the build name")).optional()).with((Field)((Text)((Text)Text.of((String)"promotionName").label("Promotion name")).help("Collects only builds which are promoted to this promotion level.")).optional()).with((Field)((Text)((Text)Text.of((String)"validationStampName").label("Validation stamp name")).help("Collects only builds which have `passed` this validation stamp.")).optional()).with((Field)((Selection)Selection.of((String)"property").label("With property")).items(properties).itemId("typeName").optional()).with((Field)((Text)((Text)Text.of((String)"propertyValue").label("... with value")).length(40)).optional());
    }

    @RequestMapping(value={"project/{projectId}/builds/search"}, method={RequestMethod.GET})
    public Resources<BuildView> buildSearch(@PathVariable ID projectId, @Valid BuildSearchForm form) {
        return Resources.of((Collection)this.structureService.buildSearch(projectId, form).stream().map(build -> this.structureService.getBuildView(build, true)).collect(Collectors.toList()), (URI)this.uri((Object)((BuildController)MvcUriComponentsBuilder.on(this.getClass())).buildSearch(projectId, form))).forView(BuildView.class);
    }

    @RequestMapping(value={"project/{projectId}/builds/diff"}, method={RequestMethod.GET})
    public Resources<Action> buildDiffActions(@PathVariable ID projectId) {
        return Resources.of((Collection)this.extensionManager.getExtensions(BuildDiffExtension.class).stream().filter(extension -> extension.apply(this.structureService.getProject(projectId))).map(arg_0 -> ((BuildController)this).resolveExtensionAction(arg_0)).collect(Collectors.toList()), (URI)this.uri((Object)((BuildController)MvcUriComponentsBuilder.on(this.getClass())).buildDiffActions(projectId)));
    }

    @RequestMapping(value={"branches/{branchId}/builds/create"}, method={RequestMethod.GET})
    public Form newBuildForm(@PathVariable ID branchId) {
        this.structureService.getBranch(branchId);
        return Build.form();
    }

    @RequestMapping(value={"branches/{branchId}/builds/create"}, method={RequestMethod.POST})
    public Build newBuild(@PathVariable ID branchId, @RequestBody @Valid BuildRequest request) {
        Branch branch = this.structureService.getBranch(branchId);
        Signature signature = this.securityService.getCurrentSignature();
        Build build = Build.of((Branch)branch, (NameDescription)request.asNameDescription(), (Signature)signature);
        build = this.structureService.newBuild(build);
        for (PropertyCreationRequest propertyCreationRequest : request.getProperties()) {
            this.propertyService.editProperty((ProjectEntity)build, propertyCreationRequest.getPropertyTypeName(), propertyCreationRequest.getPropertyData());
        }
        return build;
    }

    @RequestMapping(value={"builds/{buildId}/update"}, method={RequestMethod.GET})
    public Form updateBuildForm(@PathVariable ID buildId) {
        return this.structureService.getBuild(buildId).asForm();
    }

    @RequestMapping(value={"builds/{buildId}/update"}, method={RequestMethod.PUT})
    public Build updateBuild(@PathVariable ID buildId, @RequestBody @Valid NameDescription nameDescription) {
        Build build = this.structureService.getBuild(buildId);
        build = build.update(nameDescription);
        this.structureService.saveBuild(build);
        return build;
    }

    @RequestMapping(value={"builds/{buildId}/signature"}, method={RequestMethod.GET})
    public Form updateBuildSignatureForm(@PathVariable ID buildId) {
        return SignatureRequest.of((Signature)this.structureService.getBuild(buildId).getSignature()).asForm();
    }

    @RequestMapping(value={"builds/{buildId}/signature"}, method={RequestMethod.PUT})
    public Build updateBuildSignature(@PathVariable ID buildId, @RequestBody SignatureRequest request) {
        Build build = this.structureService.getBuild(buildId);
        build = build.withSignature(request.getSignature(build.getSignature()));
        this.structureService.saveBuild(build);
        return build;
    }

    @RequestMapping(value={"builds/{buildId}"}, method={RequestMethod.DELETE})
    public Ack deleteBuild(@PathVariable ID buildId) {
        return this.structureService.deleteBuild(buildId);
    }

    @RequestMapping(value={"builds/{buildId}"}, method={RequestMethod.GET})
    public Build getBuild(@PathVariable ID buildId) {
        return this.structureService.getBuild(buildId);
    }

    @RequestMapping(value={"builds/{buildId}/previous"}, method={RequestMethod.GET})
    public ResponseEntity<Build> getPreviousBuild(@PathVariable ID buildId) {
        return this.structureService.getPreviousBuild(buildId).map(ResponseEntity::ok).orElse(ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).body(null));
    }

    @RequestMapping(value={"builds/{buildId}/next"}, method={RequestMethod.GET})
    public ResponseEntity<Build> getNextBuild(@PathVariable ID buildId) {
        return this.structureService.getNextBuild(buildId).map(ResponseEntity::ok).orElse(ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).body(null));
    }

    @RequestMapping(value={"builds/{buildId}/links/from"}, method={RequestMethod.GET})
    public Resources<Build> getBuildLinksFrom(@PathVariable ID buildId, @RequestParam(defaultValue="0") int offset, @RequestParam(defaultValue="10") int size) {
        return Resources.of((Collection)this.structureService.getBuildsUsedBy(this.structureService.getBuild(buildId), offset, size, build -> true).getPageItems(), (URI)this.uri((Object)((BuildController)MvcUriComponentsBuilder.on(this.getClass())).getBuildLinksFrom(buildId, offset, size))).forView(Build.class);
    }

    @RequestMapping(value={"builds/{buildId}/links/to"}, method={RequestMethod.GET})
    public Resources<Build> getBuildLinksTo(@PathVariable ID buildId, @RequestParam(defaultValue="0") int offset, @RequestParam(defaultValue="10") int size) {
        return Resources.of((Collection)this.structureService.getBuildsUsing(this.structureService.getBuild(buildId), offset, size, build -> true).getPageItems(), (URI)this.uri((Object)((BuildController)MvcUriComponentsBuilder.on(this.getClass())).getBuildLinksTo(buildId, offset, size))).forView(Build.class);
    }

    @RequestMapping(value={"builds/{buildId}/links/from"}, method={RequestMethod.PUT})
    public Build createBuildLinkFromForm(@PathVariable ID buildId, @RequestBody BuildLinkForm form) {
        Build build = this.structureService.getBuild(buildId);
        this.structureService.editBuildLinks(build, form);
        return build;
    }

    @RequestMapping(value={"builds/{buildId}/links/{targetBuildId}"}, method={RequestMethod.PUT})
    public Build addBuildLink(@PathVariable ID buildId, @PathVariable ID targetBuildId) {
        Build build = this.structureService.getBuild(buildId);
        Build targetBuild = this.structureService.getBuild(targetBuildId);
        this.structureService.addBuildLink(build, targetBuild);
        return build;
    }

    @RequestMapping(value={"builds/{buildId}/links/{targetBuildId}"}, method={RequestMethod.DELETE})
    public Build deleteBuildLink(@PathVariable ID buildId, @PathVariable ID targetBuildId) {
        Build build = this.structureService.getBuild(buildId);
        Build targetBuild = this.structureService.getBuild(targetBuildId);
        this.structureService.deleteBuildLink(build, targetBuild);
        return build;
    }
}

