/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.net.URI;
import net.nemerosa.ontrack.boot.ui.AbstractURIBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@Component
@Profile(value={"dev", "acceptance", "prod"})
@ConditionalOnProperty(prefix="ontrack.config", name={"uri"}, havingValue="absolute")
public class DefaultURIBuilder
extends AbstractURIBuilder {
    public URI build(Object methodInvocation) {
        UriComponentsBuilder builder = MvcUriComponentsBuilder.fromMethodCall((Object)methodInvocation);
        return builder.build().toUri();
    }

    public URI url(String relativeUri) {
        return URI.create(ServletUriComponentsBuilder.fromCurrentServletMapping().build().toUriString() + relativeUri);
    }

    public URI page(String path, Object ... arguments) {
        String pagePath = this.pagePath(path, arguments);
        return URI.create(ServletUriComponentsBuilder.fromCurrentServletMapping().build().toUriString() + pagePath);
    }
}

