/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import javax.validation.Valid;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.form.AbstractField;
import net.nemerosa.ontrack.model.form.AbstractText;
import net.nemerosa.ontrack.model.form.Color;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Memo;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.labels.Label;
import net.nemerosa.ontrack.model.labels.LabelForm;
import net.nemerosa.ontrack.model.labels.LabelManagementService;
import net.nemerosa.ontrack.model.labels.LabelNotEditableException;
import net.nemerosa.ontrack.model.labels.LabelTokenForm;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/labels"})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\t\u001a\u00020\nH\u0017J\u0012\u0010\u000b\u001a\u00020\n2\b\b\u0001\u0010\f\u001a\u00020\rH\u0017J\u0012\u0010\u000e\u001a\u00020\n2\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017J\u0012\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017J\u001c\u0010\u0013\u001a\u00020\u00102\b\b\u0001\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnet/nemerosa/ontrack/boot/ui/LabelController;", "Lnet/nemerosa/ontrack/ui/controller/AbstractResourceController;", "labelManagementService", "Lnet/nemerosa/ontrack/model/labels/LabelManagementService;", "(Lnet/nemerosa/ontrack/model/labels/LabelManagementService;)V", "deleteLabel", "Lnet/nemerosa/ontrack/model/Ack;", "labelId", "", "getCreationForm", "Lnet/nemerosa/ontrack/model/form/Form;", "getFormForToken", "input", "Lnet/nemerosa/ontrack/model/labels/LabelTokenForm;", "getUpdateLabelForm", "newLabel", "Lnet/nemerosa/ontrack/model/labels/Label;", "form", "Lnet/nemerosa/ontrack/model/labels/LabelForm;", "updateLabel", "ontrack-ui"})
public class LabelController
extends AbstractResourceController {
    private final LabelManagementService labelManagementService;

    @GetMapping(value={"create"})
    @NotNull
    public Form getCreationForm() {
        Form form = Form.Companion.create();
        AbstractField abstractField = ((Text)((Text)((Text)Text.of((String)"category").label("Category")).help("Category the label belongs to")).length(50)).optional();
        Intrinsics.checkNotNullExpressionValue((Object)abstractField, (String)"Text.of(\"category\")\n    \u2026              .optional()");
        Form form2 = form.with((Field)abstractField);
        AbstractText abstractText = ((Text)((Text)Text.of((String)"name").label("Name")).help("Name of the label")).length(200);
        Intrinsics.checkNotNullExpressionValue((Object)abstractText, (String)"Text.of(\"name\")\n        \u2026             .length(200)");
        Form form3 = form2.with((Field)abstractText);
        AbstractField abstractField2 = ((Memo)((Memo)((Memo)Memo.of((String)"description").label("Description")).help("Short description of the label")).length(500)).optional();
        Intrinsics.checkNotNullExpressionValue((Object)abstractField2, (String)"Memo.of(\"description\")\n \u2026              .optional()");
        Form form4 = form3.with((Field)abstractField2);
        AbstractField abstractField3 = ((Color)((Color)Color.of((String)"color").label("Color")).help("Color of the label")).value((Object)"#000000");
        Intrinsics.checkNotNullExpressionValue((Object)abstractField3, (String)"Color.of(\"color\")\n      \u2026        .value(\"#000000\")");
        return form4.with((Field)abstractField3);
    }

    @PostMapping(value={"create"})
    @NotNull
    public Label newLabel(@RequestBody @Valid @NotNull LabelForm form) {
        Intrinsics.checkNotNullParameter((Object)form, (String)"form");
        return this.labelManagementService.newLabel(form);
    }

    @GetMapping(value={"{labelId}/update"})
    @NotNull
    public Form getUpdateLabelForm(@PathVariable int labelId) {
        Label label = this.labelManagementService.getLabel(labelId);
        boolean bl = false;
        boolean bl2 = false;
        Label label2 = label;
        boolean bl3 = false;
        if (label2.getComputedBy() != null) {
            throw (Throwable)new LabelNotEditableException(label2);
        }
        return this.getCreationForm().fill("category", (Object)label2.getCategory()).fill("name", (Object)label2.getName()).fill("description", (Object)label2.getDescription()).fill("color", (Object)label2.getColor());
    }

    @PutMapping(value={"{labelId}/update"})
    @NotNull
    public Label updateLabel(@PathVariable int labelId, @RequestBody @Valid @NotNull LabelForm form) {
        Intrinsics.checkNotNullParameter((Object)form, (String)"form");
        return this.labelManagementService.updateLabel(labelId, form);
    }

    @DeleteMapping(value={"{labelId}/delete"})
    @NotNull
    public Ack deleteLabel(@PathVariable int labelId) {
        return this.labelManagementService.deleteLabel(labelId);
    }

    @PostMapping(value={"token"})
    @NotNull
    public Form getFormForToken(@RequestBody @NotNull LabelTokenForm input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        LabelForm label = input.parse();
        Form form = this.getCreationForm();
        return form.fill("category", (Object)label.getCategory()).fill("name", (Object)label.getName()).fill("description", (Object)label.getDescription()).fill("color", (Object)label.getColor());
    }

    public LabelController(@NotNull LabelManagementService labelManagementService) {
        Intrinsics.checkNotNullParameter((Object)labelManagementService, (String)"labelManagementService");
        this.labelManagementService = labelManagementService;
    }
}

