/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.net.URI;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.labels.Label;
import net.nemerosa.ontrack.model.labels.LabelManagementService;
import net.nemerosa.ontrack.model.labels.ProjectLabelForm;
import net.nemerosa.ontrack.model.labels.ProjectLabelManagementService;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/rest/labels/projects"})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\b\u0001\u0010\u000b\u001a\u00020\u000eH\u0017J\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\b\u0001\u0010\u000b\u001a\u00020\u000e2\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017J\u001c\u0010\u0015\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnet/nemerosa/ontrack/boot/ui/ProjectLabelController;", "Lnet/nemerosa/ontrack/ui/controller/AbstractResourceController;", "structureService", "Lnet/nemerosa/ontrack/model/structure/StructureService;", "labelManagementService", "Lnet/nemerosa/ontrack/model/labels/LabelManagementService;", "projectLabelManagementService", "Lnet/nemerosa/ontrack/model/labels/ProjectLabelManagementService;", "(Lnet/nemerosa/ontrack/model/structure/StructureService;Lnet/nemerosa/ontrack/model/labels/LabelManagementService;Lnet/nemerosa/ontrack/model/labels/ProjectLabelManagementService;)V", "associateProjectToLabel", "Lnet/nemerosa/ontrack/model/Ack;", "projectId", "Lnet/nemerosa/ontrack/model/structure/ID;", "labelId", "", "getLabelsForProject", "Lnet/nemerosa/ontrack/ui/resource/Resources;", "Lnet/nemerosa/ontrack/model/labels/Label;", "setLabelsForProject", "form", "Lnet/nemerosa/ontrack/model/labels/ProjectLabelForm;", "unassociateProjectToLabel", "ontrack-ui"})
public class ProjectLabelController
extends AbstractResourceController {
    private final StructureService structureService;
    private final LabelManagementService labelManagementService;
    private final ProjectLabelManagementService projectLabelManagementService;

    @GetMapping(value={"{projectId}"})
    @NotNull
    public Resources<Label> getLabelsForProject(@PathVariable int projectId) {
        Resources resources = Resources.of((Collection)this.projectLabelManagementService.getLabelsForProject(this.structureService.getProject(ID.Companion.of(projectId))), (URI)this.uri((Object)((ProjectLabelController)MvcUriComponentsBuilder.on(this.getClass())).getLabelsForProject(projectId)));
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.of(\n          \u2026ect(projectId))\n        )");
        return resources;
    }

    @PutMapping(value={"{projectId}"})
    @NotNull
    public Resources<Label> setLabelsForProject(@PathVariable int projectId, @RequestBody @NotNull ProjectLabelForm form) {
        Intrinsics.checkNotNullParameter((Object)form, (String)"form");
        this.projectLabelManagementService.associateProjectToLabels(this.structureService.getProject(ID.Companion.of(projectId)), form);
        return this.getLabelsForProject(projectId);
    }

    @PutMapping(value={"{projectId}/assign/{labelId}"})
    @NotNull
    public Ack associateProjectToLabel(@PathVariable @NotNull ID projectId, @PathVariable int labelId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Project project = this.structureService.getProject(projectId);
        Label label = this.labelManagementService.getLabel(labelId);
        this.projectLabelManagementService.associateProjectToLabel(project, label);
        Ack ack = Ack.OK;
        Intrinsics.checkNotNullExpressionValue((Object)ack, (String)"Ack.OK");
        return ack;
    }

    @PutMapping(value={"{projectId}/unassign/{labelId}"})
    @NotNull
    public Ack unassociateProjectToLabel(@PathVariable @NotNull ID projectId, @PathVariable int labelId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Project project = this.structureService.getProject(projectId);
        Label label = this.labelManagementService.getLabel(labelId);
        this.projectLabelManagementService.unassociateProjectToLabel(project, label);
        Ack ack = Ack.OK;
        Intrinsics.checkNotNullExpressionValue((Object)ack, (String)"Ack.OK");
        return ack;
    }

    public ProjectLabelController(@NotNull StructureService structureService, @NotNull LabelManagementService labelManagementService, @NotNull ProjectLabelManagementService projectLabelManagementService) {
        Intrinsics.checkNotNullParameter((Object)structureService, (String)"structureService");
        Intrinsics.checkNotNullParameter((Object)labelManagementService, (String)"labelManagementService");
        Intrinsics.checkNotNullParameter((Object)projectLabelManagementService, (String)"projectLabelManagementService");
        this.structureService = structureService;
        this.labelManagementService = labelManagementService;
        this.projectLabelManagementService = projectLabelManagementService;
    }
}

