/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.net.URI;
import net.nemerosa.ontrack.boot.ui.AbstractURIBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@Component
@Profile(value={"dev", "acceptance", "prod"})
@ConditionalOnProperty(prefix="ontrack.config", name={"uri"}, havingValue="relative", matchIfMissing=true)
public class RelativeURIBuilder
extends AbstractURIBuilder {
    public URI build(Object methodInvocation) {
        UriComponentsBuilder builder = MvcUriComponentsBuilder.fromMethodCall((UriComponentsBuilder)UriComponentsBuilder.newInstance(), (Object)methodInvocation);
        return builder.build().toUri();
    }

    public URI url(String relativeUri) {
        return URI.create(relativeUri);
    }

    public URI page(String path, Object ... arguments) {
        String pagePath = this.pagePath(path, arguments);
        return URI.create(pagePath);
    }
}

