/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.boot.ui.SettingsController$configuration$;
import net.nemerosa.ontrack.json.ObjectMapperFactory;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.form.DescribedForm;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.security.GlobalSettings;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.settings.SettingsManager;
import net.nemerosa.ontrack.model.settings.SettingsManagerNotFoundException;
import net.nemerosa.ontrack.model.settings.SettingsValidationException;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.Resource;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/rest/settings"})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0017J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\u0004\b\u0000\u0010\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017J\u001c\u0010\u0013\u001a\u00020\r\"\u0004\b\u0000\u0010\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0006H\u0012J\u0014\u0010\u0015\u001a\u00020\u00122\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0012J$\u0010\u0016\u001a\u00020\u0017\"\u0004\b\u0000\u0010\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u00122\n\b\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0017R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnet/nemerosa/ontrack/boot/ui/SettingsController;", "Lnet/nemerosa/ontrack/ui/controller/AbstractResourceController;", "securityService", "Lnet/nemerosa/ontrack/model/security/SecurityService;", "settingsManagers", "", "Lnet/nemerosa/ontrack/model/settings/SettingsManager;", "(Lnet/nemerosa/ontrack/model/security/SecurityService;Ljava/util/Collection;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "configuration", "Lnet/nemerosa/ontrack/ui/resource/Resources;", "Lnet/nemerosa/ontrack/model/form/DescribedForm;", "getSettings", "Lnet/nemerosa/ontrack/ui/resource/Resource;", "T", "type", "", "getSettingsForm", "settingsManager", "getSettingsManagerName", "updateSettings", "Lnet/nemerosa/ontrack/model/Ack;", "settingsNode", "Lcom/fasterxml/jackson/databind/JsonNode;", "ontrack-ui"})
public class SettingsController
extends AbstractResourceController {
    private final ObjectMapper objectMapper;
    private final SecurityService securityService;
    private final Collection<SettingsManager<?>> settingsManagers;

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={""})
    @NotNull
    public Resources<DescribedForm> configuration() {
        void $this$mapTo$iv$iv;
        this.securityService.checkGlobalFunction(GlobalSettings.class);
        Iterable $this$sortedBy$iv = this.settingsManagers;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new configuration$$inlined$sortedBy$1()));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SettingsManager settingsManager = (SettingsManager)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            DescribedForm describedForm = this.getSettingsForm((SettingsManager)it);
            collection.add(describedForm);
        }
        List forms = (List)destination$iv$iv;
        Resources resources = Resources.of((Collection)forms, (URI)this.uri((Object)((SettingsController)MvcUriComponentsBuilder.on(this.getClass())).configuration()));
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Resources.of(\n          \u2026onfiguration())\n        )");
        return resources;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/{type:.*}"})
    @NotNull
    public <T> Resource<T> getSettings(@PathVariable @NotNull String type) {
        void $this$mapTo$iv$iv;
        SettingsManager candidate;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.securityService.checkGlobalFunction(GlobalSettings.class);
        Iterable $this$filter$iv = this.settingsManagers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            candidate = (SettingsManager)element$iv$iv;
            boolean bl = false;
            if (!StringUtils.equals((CharSequence)type, (CharSequence)this.getSettingsManagerName(candidate))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            candidate = (SettingsManager)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = it.getSettings();
            collection.add(object);
        }
        Object settings = CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (settings == null) {
            throw (Throwable)new SettingsManagerNotFoundException(type);
        }
        Resource resource = Resource.of((Object)settings, (URI)this.uri((Object)((SettingsController)MvcUriComponentsBuilder.on(this.getClass())).getSettings(type)));
        Intrinsics.checkNotNullExpressionValue((Object)resource, (String)"Resource.of(\n           \u2026Any>(type))\n            )");
        return resource;
    }

    /*
     * WARNING - void declaration
     */
    @PutMapping(value={"/{type:.*}"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    @NotNull
    public <T> Ack updateSettings(@PathVariable @NotNull String type, @RequestBody @Nullable JsonNode settingsNode) {
        Object v0;
        block5: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.securityService.checkGlobalFunction(GlobalSettings.class);
            Iterable iterable = this.settingsManagers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SettingsManager candidate = (SettingsManager)element$iv;
                boolean bl = false;
                if (!StringUtils.equals((CharSequence)type, (CharSequence)this.getSettingsManagerName(candidate))) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        SettingsManager settingsManager = v0;
        if (settingsManager == null) {
            throw (Throwable)new SettingsManagerNotFoundException(type);
        }
        if (settingsManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.nemerosa.ontrack.model.settings.SettingsManager<T>");
        }
        SettingsManager settingsManager2 = settingsManager;
        Object settings = null;
        try {
            JsonNode jsonNode = settingsNode;
            Intrinsics.checkNotNull((Object)jsonNode);
            settings = this.objectMapper.treeToValue((TreeNode)jsonNode, settingsManager2.getSettingsClass());
        }
        catch (JsonProcessingException e) {
            throw (Throwable)new SettingsValidationException((Exception)((Object)e));
        }
        settingsManager2.saveSettings(settings);
        Ack ack = Ack.OK;
        Intrinsics.checkNotNullExpressionValue((Object)ack, (String)"Ack.OK");
        return ack;
    }

    private String getSettingsManagerName(SettingsManager<?> settingsManager) {
        String string = settingsManager.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"settingsManager.id");
        return string;
    }

    private <T> DescribedForm getSettingsForm(SettingsManager<T> settingsManager) {
        DescribedForm describedForm = DescribedForm.create((String)this.getSettingsManagerName(settingsManager), (Form)settingsManager.getSettingsForm()).title(settingsManager.getTitle()).uri(this.uri((Object)((SettingsController)MvcUriComponentsBuilder.on(this.getClass())).updateSettings(this.getSettingsManagerName(settingsManager), null)));
        Intrinsics.checkNotNullExpressionValue((Object)describedForm, (String)"DescribedForm.create(\n  \u2026settingsManager), null)))");
        return describedForm;
    }

    public SettingsController(@NotNull SecurityService securityService, @NotNull Collection<? extends SettingsManager<?>> settingsManagers) {
        Intrinsics.checkNotNullParameter((Object)securityService, (String)"securityService");
        Intrinsics.checkNotNullParameter(settingsManagers, (String)"settingsManagers");
        this.securityService = securityService;
        this.settingsManagers = settingsManagers;
        this.objectMapper = ObjectMapperFactory.create();
    }
}

