/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.boot.ui.TokensController;
import net.nemerosa.ontrack.model.structure.Token;
import net.nemerosa.ontrack.model.structure.TokensService;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/tokens"})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001:\u0003\u0015\u0016\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0017J\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0006H\u0017J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0017R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/nemerosa/ontrack/boot/ui/TokensController;", "", "tokensService", "Lnet/nemerosa/ontrack/model/structure/TokensService;", "(Lnet/nemerosa/ontrack/model/structure/TokensService;)V", "currentToken", "Lorg/springframework/http/ResponseEntity;", "Lnet/nemerosa/ontrack/boot/ui/TokensController$TokenResponse;", "getCurrentToken", "()Lorg/springframework/http/ResponseEntity;", "generateForAccount", "account", "", "request", "Lnet/nemerosa/ontrack/boot/ui/TokensController$TokenGenerationRequest;", "generateNewToken", "getTokenForAccount", "revokeAll", "Lnet/nemerosa/ontrack/boot/ui/TokensController$RevokeAllResponse;", "revokeForAccount", "revokeToken", "RevokeAllResponse", "TokenGenerationRequest", "TokenResponse", "ontrack-ui"})
public class TokensController {
    private final TokensService tokensService;

    @GetMapping(value={"current"})
    @NotNull
    public ResponseEntity<TokenResponse> getCurrentToken() {
        Token token = this.tokensService.getCurrentToken();
        boolean bl = false;
        boolean bl2 = false;
        Token it = token;
        boolean bl3 = false;
        ResponseEntity responseEntity = ResponseEntity.ok((Object)new TokenResponse(it));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"tokensService.currentTok\u2026y.ok(TokenResponse(it)) }");
        return responseEntity;
    }

    @PostMapping(value={"new"})
    @NotNull
    public ResponseEntity<TokenResponse> generateNewToken() {
        ResponseEntity responseEntity = ResponseEntity.ok((Object)new TokenResponse(this.tokensService.generateNewToken()));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ResponseEntity.ok(TokenR\u2026vice.generateNewToken()))");
        return responseEntity;
    }

    @PostMapping(value={"revoke"})
    @NotNull
    public ResponseEntity<TokenResponse> revokeToken() {
        this.tokensService.revokeToken();
        ResponseEntity responseEntity = ResponseEntity.ok((Object)new TokenResponse(null));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ResponseEntity.ok(TokenResponse(null))");
        return responseEntity;
    }

    @PostMapping(value={"revokeAll"})
    @NotNull
    public ResponseEntity<RevokeAllResponse> revokeAll() {
        int count = this.tokensService.revokeAll();
        ResponseEntity responseEntity = ResponseEntity.ok((Object)new RevokeAllResponse(count));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ResponseEntity.ok(RevokeAllResponse(count))");
        return responseEntity;
    }

    @PostMapping(value={"account/{account}/revoke"})
    @NotNull
    public ResponseEntity<TokenResponse> revokeForAccount(@PathVariable int account) {
        this.tokensService.revokeToken(account);
        ResponseEntity responseEntity = ResponseEntity.ok((Object)new TokenResponse(null));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ResponseEntity.ok(TokenResponse(null))");
        return responseEntity;
    }

    @PostMapping(value={"account/{account}/generate"})
    @NotNull
    public ResponseEntity<TokenResponse> generateForAccount(@PathVariable int account, @RequestBody @NotNull TokenGenerationRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Duration actualDuration = request.getDuration() <= 0 ? null : Duration.of(request.getDuration(), request.getUnit().toChronoUnit());
        Token token = this.tokensService.generateToken(account, actualDuration, actualDuration == null);
        ResponseEntity responseEntity = ResponseEntity.ok((Object)new TokenResponse(token));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ResponseEntity.ok(TokenResponse(token))");
        return responseEntity;
    }

    @GetMapping(value={"account/{account}"})
    @NotNull
    public ResponseEntity<TokenResponse> getTokenForAccount(@PathVariable int account) {
        Token token = this.tokensService.getToken(account);
        Token token2 = token != null ? token.obfuscate() : null;
        ResponseEntity responseEntity = ResponseEntity.ok((Object)new TokenResponse(token2));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ResponseEntity.ok(TokenResponse(token))");
        return responseEntity;
    }

    public TokensController(@NotNull TokensService tokensService) {
        Intrinsics.checkNotNullParameter((Object)tokensService, (String)"tokensService");
        this.tokensService = tokensService;
    }
}

