/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.boot.ui.ValidationRunStatusCommentRequest;
import net.nemerosa.ontrack.model.exceptions.ValidationRunStatusIDNotAvailableException;
import net.nemerosa.ontrack.model.form.AbstractField;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Memo;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.model.structure.ValidationRun;
import net.nemerosa.ontrack.model.structure.ValidationRunStatus;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/validationRunStatuses"})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017J\u001c\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/nemerosa/ontrack/boot/ui/ValidationRunStatusController;", "Lnet/nemerosa/ontrack/ui/controller/AbstractResourceController;", "structureService", "Lnet/nemerosa/ontrack/model/structure/StructureService;", "(Lnet/nemerosa/ontrack/model/structure/StructureService;)V", "getValidationRunStatusEditCommentForm", "Lnet/nemerosa/ontrack/model/form/Form;", "validationRunStatusId", "Lnet/nemerosa/ontrack/model/structure/ID;", "validationRunStatusEditComment", "Lnet/nemerosa/ontrack/model/structure/ValidationRun;", "request", "Lnet/nemerosa/ontrack/boot/ui/ValidationRunStatusCommentRequest;", "ontrack-ui"})
public class ValidationRunStatusController
extends AbstractResourceController {
    private final StructureService structureService;

    @GetMapping(value={"{validationRunStatusId}/comment"})
    @NotNull
    public Form getValidationRunStatusEditCommentForm(@PathVariable @NotNull ID validationRunStatusId) {
        Intrinsics.checkNotNullParameter((Object)validationRunStatusId, (String)"validationRunStatusId");
        ValidationRunStatus status = this.structureService.getValidationRunStatus(validationRunStatusId);
        Form form = Form.Companion.create();
        AbstractField abstractField = ((Memo)((Memo)Memo.of((String)"comment").label("Comment")).help("Comment for this validation run status")).value((Object)status.getDescription());
        Intrinsics.checkNotNullExpressionValue((Object)abstractField, (String)"Memo.of(\"comment\")\n     \u2026value(status.description)");
        return form.with((Field)abstractField);
    }

    @PutMapping(value={"{validationRunStatusId}/comment"})
    @NotNull
    public ValidationRun validationRunStatusEditComment(@PathVariable @NotNull ID validationRunStatusId, @RequestBody @NotNull ValidationRunStatusCommentRequest request) {
        Intrinsics.checkNotNullParameter((Object)validationRunStatusId, (String)"validationRunStatusId");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ValidationRun validationRun = StructureService.DefaultImpls.getParentValidationRun$default((StructureService)this.structureService, (ID)validationRunStatusId, (boolean)false, (int)2, null);
        if (validationRun == null) {
            throw (Throwable)new ValidationRunStatusIDNotAvailableException(validationRunStatusId);
        }
        ValidationRun run = validationRun;
        return this.structureService.saveValidationRunStatusComment(run, validationRunStatusId, request.getComment());
    }

    public ValidationRunStatusController(@NotNull StructureService structureService) {
        Intrinsics.checkNotNullParameter((Object)structureService, (String)"structureService");
        this.structureService = structureService;
    }
}

