/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.exceptions.ValidationStampFilterNotShareableException;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.MultiSelection;
import net.nemerosa.ontrack.model.form.MultiStrings;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.model.structure.ValidationStamp;
import net.nemerosa.ontrack.model.structure.ValidationStampFilter;
import net.nemerosa.ontrack.model.structure.ValidationStampFilterInput;
import net.nemerosa.ontrack.model.structure.ValidationStampFilterScope;
import net.nemerosa.ontrack.model.structure.ValidationStampFilterService;
import net.nemerosa.ontrack.model.support.SelectableString;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/rest/validation-stamp-filters"})
public class ValidationStampFilterController
extends AbstractResourceController {
    private final StructureService structureService;
    private final ValidationStampFilterService filterService;

    @Autowired
    public ValidationStampFilterController(StructureService structureService, ValidationStampFilterService filterService) {
        this.structureService = structureService;
        this.filterService = filterService;
    }

    @GetMapping(value={"/branch/{branchId}/all"})
    public Resources<ValidationStampFilter> getAllBranchValidationStampFilters(@PathVariable ID branchId) {
        return Resources.of((Collection)this.filterService.getBranchValidationStampFilters(this.structureService.getBranch(branchId), true), (URI)this.uri((Object)((ValidationStampFilterController)MvcUriComponentsBuilder.on(this.getClass())).getAllBranchValidationStampFilters(branchId)));
    }

    @GetMapping(value={"/branch/{branchId}/create"})
    public Form getBranchValidationStampFilterForm(@PathVariable ID branchId) {
        return Form.create().with((Field)((Text)Text.of((String)"name").label("Name")).length(40));
    }

    @PostMapping(value={"/branch/{branchId}/create"})
    public ValidationStampFilter createBranchValidationStampFilterForm(@PathVariable ID branchId, @RequestBody NameDescription input) {
        List vsNames = this.structureService.getValidationStampListForBranch(branchId).stream().map(ValidationStamp::getName).collect(Collectors.toList());
        return this.filterService.newValidationStampFilter(new ValidationStampFilter(ID.NONE, input.getName(), vsNames, null, this.structureService.getBranch(branchId)));
    }

    @GetMapping(value={"/{validationStampFilterId}/update"})
    public Form getValidationStampFilterUpdateForm(@PathVariable ID validationStampFilterId) {
        ValidationStampFilter filter = this.filterService.getValidationStampFilter(validationStampFilterId);
        Form form = Form.create().name().name(filter.getName());
        ValidationStampFilterScope scope = filter.getScope();
        form = scope == ValidationStampFilterScope.BRANCH ? form.with((Field)((MultiSelection)MultiSelection.of((String)"vsNames").label("Validation stamps")).items(this.structureService.getValidationStampListForBranch(filter.getBranch().getId()).stream().map(ValidationStamp::getName).map(name -> SelectableString.of((String)name, (Collection)filter.getVsNames())).collect(Collectors.toList()))) : (scope == ValidationStampFilterScope.PROJECT ? form.with((Field)((MultiSelection)MultiSelection.of((String)"vsNames").label("Validation stamps")).items(this.structureService.getBranchesForProject(filter.getProject().getId()).stream().flatMap(branch -> this.structureService.getValidationStampListForBranch(branch.getId()).stream()).map(ValidationStamp::getName).distinct().map(name -> SelectableString.of((String)name, (Collection)filter.getVsNames())).collect(Collectors.toList()))) : form.with((Field)((MultiStrings)MultiStrings.of((String)"vsNames").label("Validation stamps")).value((Object)filter.getVsNames())));
        return form;
    }

    @PutMapping(value={"/{validationStampFilterId}/update"})
    public ValidationStampFilter updateValidationStampFilter(@PathVariable ID validationStampFilterId, @RequestBody ValidationStampFilterInput input) {
        ValidationStampFilter filter = this.filterService.getValidationStampFilter(validationStampFilterId).withName(input.getName()).withVsNames(input.getVsNames());
        this.filterService.saveValidationStampFilter(filter);
        return filter;
    }

    @DeleteMapping(value={"/{validationStampFilterId}/delete"})
    public Ack deleteValidationStampFilter(@PathVariable ID validationStampFilterId) {
        return this.filterService.deleteValidationStampFilter(this.filterService.getValidationStampFilter(validationStampFilterId));
    }

    @PutMapping(value={"/{validationStampFilterId}/share/project"})
    public ValidationStampFilter shareValidationStampFilterAtProject(@PathVariable ID validationStampFilterId) {
        ValidationStampFilter filter = this.filterService.getValidationStampFilter(validationStampFilterId);
        if (filter.getBranch() == null) {
            throw new ValidationStampFilterNotShareableException(filter.getName(), "no branch is associated with the filter");
        }
        return this.filterService.shareValidationStampFilter(filter, filter.getBranch().getProject());
    }

    @PutMapping(value={"/{validationStampFilterId}/share/global"})
    public ValidationStampFilter shareValidationStampFilterAtGlobal(@PathVariable ID validationStampFilterId) {
        ValidationStampFilter filter = this.filterService.getValidationStampFilter(validationStampFilterId);
        return this.filterService.shareValidationStampFilter(filter);
    }
}

