/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.boot.BranchSearchItem;
import net.nemerosa.ontrack.boot.BranchSearchProvider;
import net.nemerosa.ontrack.boot.CoreExtensionFeature;
import net.nemerosa.ontrack.job.Schedule;
import net.nemerosa.ontrack.model.events.Event;
import net.nemerosa.ontrack.model.events.EventFactory;
import net.nemerosa.ontrack.model.events.EventListener;
import net.nemerosa.ontrack.model.events.EventType;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.SearchIndexMapping;
import net.nemerosa.ontrack.model.structure.SearchIndexMappingExtensionsKt;
import net.nemerosa.ontrack.model.structure.SearchIndexService;
import net.nemerosa.ontrack.model.structure.SearchIndexServiceKt;
import net.nemerosa.ontrack.model.structure.SearchIndexer;
import net.nemerosa.ontrack.model.structure.SearchItem;
import net.nemerosa.ontrack.model.structure.SearchResult;
import net.nemerosa.ontrack.model.structure.SearchResultType;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.ui.controller.EntityURIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001a0\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\"\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\f\u0010'\u001a\u00020\u0002*\u00020(H\u0012R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lnet/nemerosa/ontrack/boot/BranchSearchProvider;", "Lnet/nemerosa/ontrack/model/structure/SearchIndexer;", "Lnet/nemerosa/ontrack/boot/BranchSearchItem;", "Lnet/nemerosa/ontrack/model/events/EventListener;", "uriBuilder", "Lnet/nemerosa/ontrack/ui/controller/EntityURIBuilder;", "structureService", "Lnet/nemerosa/ontrack/model/structure/StructureService;", "searchIndexService", "Lnet/nemerosa/ontrack/model/structure/SearchIndexService;", "(Lnet/nemerosa/ontrack/ui/controller/EntityURIBuilder;Lnet/nemerosa/ontrack/model/structure/StructureService;Lnet/nemerosa/ontrack/model/structure/SearchIndexService;)V", "indexMapping", "Lnet/nemerosa/ontrack/model/structure/SearchIndexMapping;", "getIndexMapping", "()Lnet/nemerosa/ontrack/model/structure/SearchIndexMapping;", "indexName", "", "getIndexName", "()Ljava/lang/String;", "indexerName", "getIndexerName", "searchResultType", "Lnet/nemerosa/ontrack/model/structure/SearchResultType;", "getSearchResultType", "()Lnet/nemerosa/ontrack/model/structure/SearchResultType;", "indexAll", "", "processor", "Lkotlin/Function1;", "onEvent", "event", "Lnet/nemerosa/ontrack/model/events/Event;", "toSearchResult", "Lnet/nemerosa/ontrack/model/structure/SearchResult;", "id", "score", "", "source", "Lcom/fasterxml/jackson/databind/JsonNode;", "asSearchItem", "Lnet/nemerosa/ontrack/model/structure/Branch;", "ontrack-ui"})
public class BranchSearchProvider
implements SearchIndexer<BranchSearchItem>,
EventListener {
    @NotNull
    private final EntityURIBuilder uriBuilder;
    @NotNull
    private final StructureService structureService;
    @NotNull
    private final SearchIndexService searchIndexService;
    @NotNull
    private final SearchResultType searchResultType;
    @NotNull
    private final String indexerName;
    @NotNull
    private final String indexName;
    @NotNull
    private final SearchIndexMapping indexMapping;

    public BranchSearchProvider(@NotNull EntityURIBuilder uriBuilder, @NotNull StructureService structureService, @NotNull SearchIndexService searchIndexService) {
        Intrinsics.checkNotNullParameter((Object)uriBuilder, (String)"uriBuilder");
        Intrinsics.checkNotNullParameter((Object)structureService, (String)"structureService");
        Intrinsics.checkNotNullParameter((Object)searchIndexService, (String)"searchIndexService");
        this.uriBuilder = uriBuilder;
        this.structureService = structureService;
        this.searchIndexService = searchIndexService;
        this.searchResultType = new SearchResultType(CoreExtensionFeature.Companion.getINSTANCE().getFeatureDescription(), "branch", "Branch", "Branch name in Ontrack");
        this.indexerName = "Branches";
        this.indexName = "branches";
        this.indexMapping = SearchIndexMappingExtensionsKt.indexMappings((Function1)((Function1)indexMapping.1.INSTANCE));
    }

    @NotNull
    public SearchResultType getSearchResultType() {
        return this.searchResultType;
    }

    @NotNull
    public String getIndexerName() {
        return this.indexerName;
    }

    @NotNull
    public String getIndexName() {
        return this.indexName;
    }

    @NotNull
    public SearchIndexMapping getIndexMapping() {
        return this.indexMapping;
    }

    public void indexAll(@NotNull Function1<? super BranchSearchItem, Unit> processor) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Iterable $this$forEach$iv = this.structureService.getProjectList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project it = (Project)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = this.structureService.getBranchesForProject(it.getId());
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Branch branch = (Branch)element$iv2;
                boolean bl2 = false;
                processor.invoke((Object)this.asSearchItem(branch));
            }
        }
    }

    @Nullable
    public SearchResult toSearchResult(@NotNull String id, double score, @NotNull JsonNode source) {
        SearchResult searchResult;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Branch branch = this.structureService.findBranchByID(ID.Companion.of(Integer.parseInt(id)));
        if (branch != null) {
            Branch $this$toSearchResult_u24lambda_u2d2 = branch;
            boolean bl = false;
            String string = $this$toSearchResult_u24lambda_u2d2.getEntityDisplayName();
            String string2 = $this$toSearchResult_u24lambda_u2d2.getDescription();
            if (string2 == null) {
                string2 = "";
            }
            URI uRI = this.uriBuilder.getEntityURI((ProjectEntity)$this$toSearchResult_u24lambda_u2d2);
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"uriBuilder.getEntityURI(this)");
            URI uRI2 = this.uriBuilder.getEntityPage((ProjectEntity)$this$toSearchResult_u24lambda_u2d2);
            Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"uriBuilder.getEntityPage(this)");
            searchResult = new SearchResult(string, string2, uRI, uRI2, score, this.getSearchResultType(), null, 64, null);
        } else {
            searchResult = null;
        }
        return searchResult;
    }

    public void onEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        EventType eventType = event.getEventType();
        if (Intrinsics.areEqual((Object)eventType, (Object)EventFactory.NEW_BRANCH)) {
            Branch branch = (Branch)event.getEntity(ProjectEntityType.BRANCH);
            SearchIndexer searchIndexer = (SearchIndexer)this;
            Intrinsics.checkNotNullExpressionValue((Object)branch, (String)"branch");
            this.searchIndexService.createSearchIndex(searchIndexer, (SearchItem)this.asSearchItem(branch));
        } else if (Intrinsics.areEqual((Object)eventType, (Object)EventFactory.UPDATE_BRANCH)) {
            Branch branch = (Branch)event.getEntity(ProjectEntityType.BRANCH);
            SearchIndexer searchIndexer = (SearchIndexer)this;
            Intrinsics.checkNotNullExpressionValue((Object)branch, (String)"branch");
            this.searchIndexService.updateSearchIndex(searchIndexer, (SearchItem)this.asSearchItem(branch));
        } else if (Intrinsics.areEqual((Object)eventType, (Object)EventFactory.DELETE_BRANCH)) {
            int branchId = event.getIntValue("branch_id");
            SearchIndexServiceKt.deleteSearchIndex((SearchIndexService)this.searchIndexService, (SearchIndexer)((SearchIndexer)this), (Object)branchId);
        }
    }

    private BranchSearchItem asSearchItem(Branch $this$asSearchItem) {
        return new BranchSearchItem($this$asSearchItem);
    }

    @Nullable
    public Integer getIndexBatch() {
        return SearchIndexer.DefaultImpls.getIndexBatch((SearchIndexer)this);
    }

    @NotNull
    public String getIndexerId() {
        return SearchIndexer.DefaultImpls.getIndexerId((SearchIndexer)this);
    }

    @NotNull
    public Schedule getIndexerSchedule() {
        return SearchIndexer.DefaultImpls.getIndexerSchedule((SearchIndexer)this);
    }

    public boolean isIndexationDisabled() {
        return SearchIndexer.DefaultImpls.isIndexationDisabled((SearchIndexer)this);
    }
}

