/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.support;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.nemerosa.ontrack.boot.support.LoginSuccessHandler;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.Base64Utils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnet/nemerosa/ontrack/boot/support/LoginSuccessHandler;", "Lorg/springframework/security/web/authentication/SimpleUrlAuthenticationSuccessHandler;", "()V", "requestCache", "Lorg/springframework/security/web/savedrequest/RequestCache;", "determineTargetUrl", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "response", "Ljavax/servlet/http/HttpServletResponse;", "Companion", "ontrack-ui"})
public final class LoginSuccessHandler
extends SimpleUrlAuthenticationSuccessHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RequestCache requestCache = (RequestCache)new HttpSessionRequestCache();
    @NotNull
    public static final String COOKIE_HASH_PART = "hashPart";

    @NotNull
    protected String determineTargetUrl(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        Cookie[] cookieArray;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        Object targetUrl = savedRequest != null && (cookieArray = savedRequest.getRedirectUrl()) != null ? cookieArray : super.determineTargetUrl(request, response);
        Cookie[] cookieArray2 = request.getCookies();
        Intrinsics.checkNotNullExpressionValue((Object)cookieArray2, (String)"request.cookies");
        for (Cookie cookie : cookieArray2) {
            if (!Intrinsics.areEqual((Object)cookie.getName(), (Object)COOKIE_HASH_PART)) continue;
            String value = cookie.getValue();
            CharSequence charSequence = value;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                byte[] byArray = Base64Utils.decodeFromString((String)value);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decodeFromString(value)");
                byte[] byArray2 = byArray;
                String actualValue = new String(byArray2, Charsets.UTF_8);
                targetUrl = (String)targetUrl + actualValue;
            }
            cookie.setMaxAge(0);
            response.addCookie(cookie);
            break;
        }
        this.logger.debug((Object)("Login target URL = " + (String)targetUrl));
        String string = targetUrl;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetUrl");
        return string;
    }
}

