/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import net.nemerosa.ontrack.boot.ui.UIErrorMessage;
import net.nemerosa.ontrack.model.exceptions.InputException;
import net.nemerosa.ontrack.model.exceptions.NotFoundException;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.support.ApplicationLogEntry;
import net.nemerosa.ontrack.model.support.ApplicationLogService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@ControllerAdvice(annotations={RestController.class})
public class UIErrorHandler {
    private final MessageSource messageSource;
    private final ApplicationLogService applicationLogService;

    @Autowired
    public UIErrorHandler(MessageSource messageSource, ApplicationLogService applicationLogService) {
        this.messageSource = messageSource;
        this.applicationLogService = applicationLogService;
    }

    @ExceptionHandler(value={NotFoundException.class})
    @ResponseBody
    public ResponseEntity<UIErrorMessage> onInputException(NotFoundException ex) {
        String message = ex.getMessage();
        return this.getMessageResponse(HttpStatus.NOT_FOUND, message);
    }

    @ExceptionHandler(value={InputException.class})
    @ResponseBody
    public ResponseEntity<UIErrorMessage> onInputException(InputException ex) {
        String message = ex.getMessage();
        return this.getMessageResponse(HttpStatus.BAD_REQUEST, message);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public ResponseEntity<UIErrorMessage> onValidationException(MethodArgumentNotValidException ex) {
        List messages = ex.getBindingResult().getFieldErrors().stream().map(fieldError -> {
            String defaultMessage = fieldError.getDefaultMessage();
            if (StringUtils.isNotBlank((CharSequence)defaultMessage)) {
                return defaultMessage;
            }
            return this.messageSource.getMessage((MessageSourceResolvable)fieldError, Locale.ENGLISH);
        }).collect(Collectors.toList());
        String message = messages.size() > 1 ? messages.stream().map(s -> "* " + s + "\n").collect(Collectors.joining("")) : (String)messages.get(0);
        return this.getMessageResponse(HttpStatus.BAD_REQUEST, message);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    @ResponseBody
    public ResponseEntity<UIErrorMessage> onAccessDeniedException() {
        return this.getMessageResponse(HttpStatus.FORBIDDEN, "Not authorized.");
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResponseEntity<UIErrorMessage> onAnyException(HttpServletRequest request, Exception ex) {
        if (ex instanceof AccessDeniedException) {
            throw (AccessDeniedException)ex;
        }
        String message = "An error has occurred.";
        this.applicationLogService.log(ApplicationLogEntry.error((Throwable)ex, (NameDescription)NameDescription.nd((String)"ui-error", (String)"Error display to the user"), (String)request.getServletPath()));
        return this.getMessageResponse(HttpStatus.INTERNAL_SERVER_ERROR, message);
    }

    protected ResponseEntity<UIErrorMessage> getMessageResponse(HttpStatus status, String message) {
        return new ResponseEntity((Object)new UIErrorMessage(status.value(), message), status);
    }
}

