/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.support;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.boot.support.DocumentHttpMessageConverter;
import net.nemerosa.ontrack.boot.support.ResourceHttpMessageConverter;
import net.nemerosa.ontrack.boot.support.WebConfig;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.ui.controller.EntityURIBuilder;
import net.nemerosa.ontrack.ui.resource.ResourceModule;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.task.TaskExecutorBuilder;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.filter.ShallowEtagHeaderFilter;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000  2\u00020\u0001:\u0001 B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u00020\u00102\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u0010H\u0017J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0017R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lnet/nemerosa/ontrack/boot/support/WebConfig;", "Lorg/springframework/web/servlet/config/annotation/WebMvcConfigurer;", "uriBuilder", "Lnet/nemerosa/ontrack/ui/controller/EntityURIBuilder;", "securityService", "Lnet/nemerosa/ontrack/model/security/SecurityService;", "resourceModules", "", "Lnet/nemerosa/ontrack/ui/resource/ResourceModule;", "taskExecutorBuilder", "Lorg/springframework/boot/task/TaskExecutorBuilder;", "(Lnet/nemerosa/ontrack/ui/controller/EntityURIBuilder;Lnet/nemerosa/ontrack/model/security/SecurityService;Ljava/util/List;Lorg/springframework/boot/task/TaskExecutorBuilder;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "addCorsMappings", "", "registry", "Lorg/springframework/web/servlet/config/annotation/CorsRegistry;", "configureAsyncSupport", "configurer", "Lorg/springframework/web/servlet/config/annotation/AsyncSupportConfigurer;", "configureContentNegotiation", "Lorg/springframework/web/servlet/config/annotation/ContentNegotiationConfigurer;", "configureMessageConverters", "converters", "", "Lorg/springframework/http/converter/HttpMessageConverter;", "log", "shallowEtagHeaderFilter", "Lorg/springframework/boot/web/servlet/FilterRegistrationBean;", "Lorg/springframework/web/filter/ShallowEtagHeaderFilter;", "Companion", "ontrack-ui"})
public class WebConfig
implements WebMvcConfigurer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EntityURIBuilder uriBuilder;
    @NotNull
    private final SecurityService securityService;
    @NotNull
    private final List<ResourceModule> resourceModules;
    @NotNull
    private final TaskExecutorBuilder taskExecutorBuilder;
    private final Logger logger;
    @NotNull
    private static final Set<String> ALLOWED_API_METHODS;

    public WebConfig(@NotNull EntityURIBuilder uriBuilder, @NotNull SecurityService securityService, @NotNull List<? extends ResourceModule> resourceModules, @NotNull TaskExecutorBuilder taskExecutorBuilder) {
        Intrinsics.checkNotNullParameter((Object)uriBuilder, (String)"uriBuilder");
        Intrinsics.checkNotNullParameter((Object)securityService, (String)"securityService");
        Intrinsics.checkNotNullParameter(resourceModules, (String)"resourceModules");
        Intrinsics.checkNotNullParameter((Object)taskExecutorBuilder, (String)"taskExecutorBuilder");
        this.uriBuilder = uriBuilder;
        this.securityService = securityService;
        this.resourceModules = resourceModules;
        this.taskExecutorBuilder = taskExecutorBuilder;
        this.logger = LoggerFactory.getLogger(WebConfig.class);
    }

    @PostConstruct
    public void log() {
        this.logger.info("[web] URI builder = " + this.uriBuilder.getClass().getName());
    }

    public void configureAsyncSupport(@NotNull AsyncSupportConfigurer configurer) {
        Intrinsics.checkNotNullParameter((Object)configurer, (String)"configurer");
        ThreadPoolTaskExecutor executor = this.taskExecutorBuilder.build();
        executor.initialize();
        configurer.setTaskExecutor((AsyncTaskExecutor)executor);
        configurer.setDefaultTimeout(300000L);
    }

    public void configureContentNegotiation(@NotNull ContentNegotiationConfigurer configurer) {
        Intrinsics.checkNotNullParameter((Object)configurer, (String)"configurer");
        configurer.favorParameter(false);
    }

    @Bean
    @NotNull
    public FilterRegistrationBean<ShallowEtagHeaderFilter> shallowEtagHeaderFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new ShallowEtagHeaderFilter());
        Object[] objectArray = new DispatcherType[]{DispatcherType.ASYNC};
        registration.setDispatcherTypes(DispatcherType.REQUEST, objectArray);
        objectArray = new String[]{"/*"};
        registration.addUrlPatterns((String[])objectArray);
        return registration;
    }

    public void configureMessageConverters(@NotNull List<HttpMessageConverter<?>> converters) {
        Intrinsics.checkNotNullParameter(converters, (String)"converters");
        converters.clear();
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new DocumentHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter(this.uriBuilder, this.securityService, this.resourceModules));
    }

    public void addCorsMappings(@NotNull CorsRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Object[] objectArray = new String[]{"/graphql/**", "/rest/**", "/extension/**", "/hook/secured/**"};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String[] stringArray;
            String it = (String)element$iv;
            boolean bl = false;
            Collection $this$toTypedArray$iv = ALLOWED_API_METHODS;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            if (thisCollection$iv.toArray(new String[0]) == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            registry.addMapping(it).allowedMethods(Arrays.copyOf(stringArray, stringArray.length));
        }
    }

    static {
        Object[] objectArray = new String[]{"GET", "POST", "PUT", "DELETE", "HEAD"};
        ALLOWED_API_METHODS = SetsKt.setOf((Object[])objectArray);
    }
}

