/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.net.URI;
import java.util.Collection;
import javax.validation.Valid;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.form.AbstractField;
import net.nemerosa.ontrack.model.form.Email;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.MultiSelection;
import net.nemerosa.ontrack.model.form.Password;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.form.YesNo;
import net.nemerosa.ontrack.model.security.Account;
import net.nemerosa.ontrack.model.security.AccountGroup;
import net.nemerosa.ontrack.model.security.AccountGroupInput;
import net.nemerosa.ontrack.model.security.AccountInput;
import net.nemerosa.ontrack.model.security.AccountService;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.LinkContainer;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/rest/accounts"})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017J\u0012\u0010\u0005\u001a\u00020\t2\b\b\u0001\u0010\u0007\u001a\u00020\nH\u0017J\u0012\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u0012\u0010\u000f\u001a\u00020\f2\b\b\u0001\u0010\u0010\u001a\u00020\u000eH\u0017J\u0012\u0010\u0011\u001a\u00020\t2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0017J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0013H\u0017J\b\u0010\u0015\u001a\u00020\u0016H\u0017J\u0012\u0010\u0017\u001a\u00020\u00062\b\b\u0001\u0010\u0010\u001a\u00020\u000eH\u0017J\b\u0010\u0018\u001a\u00020\u0016H\u0017J\u0012\u0010\u0019\u001a\u00020\u00162\b\b\u0001\u0010\u0010\u001a\u00020\u000eH\u0017J\u0012\u0010\u001a\u001a\u00020\u00162\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u001c\u0010\u001b\u001a\u00020\t2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u0007\u001a\u00020\nH\u0017J\u001c\u0010\u001c\u001a\u00020\u00062\b\b\u0001\u0010\u0010\u001a\u00020\u000e2\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lnet/nemerosa/ontrack/boot/ui/AccountController;", "Lnet/nemerosa/ontrack/ui/controller/AbstractResourceController;", "accountService", "Lnet/nemerosa/ontrack/model/security/AccountService;", "(Lnet/nemerosa/ontrack/model/security/AccountService;)V", "create", "Lnet/nemerosa/ontrack/model/security/AccountGroup;", "input", "Lnet/nemerosa/ontrack/model/security/AccountGroupInput;", "Lnet/nemerosa/ontrack/model/security/Account;", "Lnet/nemerosa/ontrack/model/security/AccountInput;", "deleteAccount", "Lnet/nemerosa/ontrack/model/Ack;", "accountId", "Lnet/nemerosa/ontrack/model/structure/ID;", "deleteGroup", "groupId", "getAccount", "getAccountGroups", "Lnet/nemerosa/ontrack/ui/resource/Resources;", "getAccounts", "getCreationForm", "Lnet/nemerosa/ontrack/model/form/Form;", "getGroup", "getGroupCreationForm", "getGroupUpdateForm", "getUpdateForm", "updateAccount", "updateGroup", "ontrack-ui"})
public class AccountController
extends AbstractResourceController {
    @NotNull
    private final AccountService accountService;

    public AccountController(@NotNull AccountService accountService) {
        Intrinsics.checkNotNullParameter((Object)accountService, (String)"accountService");
        this.accountService = accountService;
    }

    @GetMapping(value={""})
    @NotNull
    public Resources<Account> getAccounts() {
        LinkContainer linkContainer = Resources.of((Collection)this.accountService.getAccounts(), (URI)this.uri((Object)((AccountController)MvcUriComponentsBuilder.on(this.getClass())).getAccounts())).with("_create", this.uri((Object)((AccountController)MvcUriComponentsBuilder.on(AccountController.class)).getCreationForm()));
        Intrinsics.checkNotNullExpressionValue((Object)linkContainer, (String)"of(\n            accountS\u2026java).getCreationForm()))");
        return (Resources)linkContainer;
    }

    @GetMapping(value={"create"})
    @NotNull
    public Form getCreationForm() {
        Form form = Form.Companion.create().with((Field)Form.Companion.defaultNameField());
        AbstractField abstractField = ((Text)((Text)Text.of((String)"fullName").length(100)).label("Full name")).help("Display name for the account");
        Intrinsics.checkNotNullExpressionValue((Object)abstractField, (String)"of(\"fullName\").length(10\u2026ay name for the account\")");
        Form form2 = form.with((Field)abstractField);
        AbstractField abstractField2 = ((Email)((Email)Email.of((String)"email").label("Email")).length(200)).help("Contact email for the account");
        Intrinsics.checkNotNullExpressionValue((Object)abstractField2, (String)"of(\"email\").label(\"Email\u2026t email for the account\")");
        Form form3 = form2.with((Field)abstractField2);
        AbstractField abstractField3 = ((Password)((Password)Password.of((String)"password").label("Password")).length(40)).help("Password for the account");
        Intrinsics.checkNotNullExpressionValue((Object)abstractField3, (String)"of(\"password\").label(\"Pa\u2026assword for the account\")");
        Form form4 = form3.with((Field)abstractField3);
        MultiSelection multiSelection = ((MultiSelection)MultiSelection.of((String)"groups").label("Groups")).items(this.accountService.getAccountGroupsForSelection(ID.NONE));
        Intrinsics.checkNotNullExpressionValue((Object)multiSelection, (String)"of(\"groups\").label(\"Grou\u2026upsForSelection(ID.NONE))");
        Form form5 = form4.with((Field)multiSelection);
        AbstractField abstractField4 = ((YesNo)((YesNo)YesNo.of((String)"disabled").label("Disabled")).help("Is this account disabled? If disabled, it cannot be used to access Ontrack any longer.")).value((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)abstractField4, (String)"of(Account::disabled.nam\u2026            .value(false)");
        Form form6 = form5.with((Field)abstractField4);
        AbstractField abstractField5 = ((YesNo)((YesNo)YesNo.of((String)"locked").label("Locked")).help("Is this account locked? If locked, it can be updated only by an administrator.")).value((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)abstractField5, (String)"of(Account::locked.name)\u2026            .value(false)");
        return form6.with((Field)abstractField5);
    }

    @PostMapping(value={"create"})
    @NotNull
    public Account create(@RequestBody @Valid @NotNull AccountInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Account account = this.accountService.create(input);
        Intrinsics.checkNotNullExpressionValue((Object)account, (String)"accountService.create(input)");
        return account;
    }

    @GetMapping(value={"{accountId}"})
    @NotNull
    public Account getAccount(@PathVariable @NotNull ID accountId) {
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Account account = this.accountService.getAccount(accountId);
        Intrinsics.checkNotNullExpressionValue((Object)account, (String)"accountService.getAccount(accountId)");
        return account;
    }

    @GetMapping(value={"{accountId}/update"})
    @NotNull
    public Form getUpdateForm(@PathVariable @NotNull ID accountId) {
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Account account = this.accountService.getAccount(accountId);
        Form form = this.getCreationForm();
        if (account.isDefaultAdmin()) {
            AbstractField abstractField = Form.Companion.defaultNameField().readOnly();
            Intrinsics.checkNotNullExpressionValue((Object)abstractField, (String)"defaultNameField().readOnly()");
            form = form.with((Field)abstractField);
        }
        AbstractField abstractField = ((Password)((Password)((Password)Password.of((String)"password").label("Password")).length(40)).help("Password for the account. Leave blank to keep it unchanged.")).optional();
        Intrinsics.checkNotNullExpressionValue((Object)abstractField, (String)"of(\"password\").label(\"Pa\u2026t unchanged.\").optional()");
        form = form.with((Field)abstractField);
        MultiSelection multiSelection = ((MultiSelection)MultiSelection.of((String)"groups").label("Groups")).items(this.accountService.getAccountGroupsForSelection(accountId));
        Intrinsics.checkNotNullExpressionValue((Object)multiSelection, (String)"of(\"groups\").label(\"Grou\u2026sForSelection(accountId))");
        form = form.with((Field)multiSelection);
        return form.fill("name", (Object)account.getName()).fill("fullName", (Object)account.getFullName()).fill("email", (Object)account.getEmail()).fill("disabled", (Object)account.getDisabled()).fill("locked", (Object)account.getLocked());
    }

    @PutMapping(value={"{accountId}/update"})
    @NotNull
    public Account updateAccount(@PathVariable @NotNull ID accountId, @RequestBody @Valid @NotNull AccountInput input) {
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Account account = this.accountService.updateAccount(accountId, input);
        Intrinsics.checkNotNullExpressionValue((Object)account, (String)"accountService.updateAccount(accountId, input)");
        return account;
    }

    @DeleteMapping(value={"{accountId}"})
    @NotNull
    public Ack deleteAccount(@PathVariable @NotNull ID accountId) {
        Intrinsics.checkNotNullParameter((Object)accountId, (String)"accountId");
        Ack ack = this.accountService.deleteAccount(accountId);
        Intrinsics.checkNotNullExpressionValue((Object)ack, (String)"accountService.deleteAccount(accountId)");
        return ack;
    }

    @GetMapping(value={"groups"})
    @NotNull
    public Resources<AccountGroup> getAccountGroups() {
        LinkContainer linkContainer = Resources.of((Collection)this.accountService.getAccountGroups(), (URI)this.uri((Object)((AccountController)MvcUriComponentsBuilder.on(this.getClass())).getAccountGroups())).with("_create", this.uri((Object)((AccountController)MvcUriComponentsBuilder.on(AccountController.class)).getGroupCreationForm()));
        Intrinsics.checkNotNullExpressionValue((Object)linkContainer, (String)"of(\n            accountS\u2026.getGroupCreationForm()))");
        return (Resources)linkContainer;
    }

    @GetMapping(value={"groups/create"})
    @NotNull
    public Form getGroupCreationForm() {
        return Form.Companion.create().name().description();
    }

    @PostMapping(value={"groups/create"})
    @NotNull
    public AccountGroup create(@RequestBody @Valid @NotNull AccountGroupInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        AccountGroup accountGroup = this.accountService.createGroup(input);
        Intrinsics.checkNotNullExpressionValue((Object)accountGroup, (String)"accountService.createGroup(input)");
        return accountGroup;
    }

    @GetMapping(value={"groups/{groupId}"})
    @NotNull
    public AccountGroup getGroup(@PathVariable @NotNull ID groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        AccountGroup accountGroup = this.accountService.getAccountGroup(groupId);
        Intrinsics.checkNotNullExpressionValue((Object)accountGroup, (String)"accountService.getAccountGroup(groupId)");
        return accountGroup;
    }

    @GetMapping(value={"groups/{groupId}/update"})
    @NotNull
    public Form getGroupUpdateForm(@PathVariable @NotNull ID groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        AccountGroup accountGroup = this.accountService.getAccountGroup(groupId);
        return this.getGroupCreationForm().fill("name", (Object)accountGroup.getName()).fill("description", (Object)accountGroup.getDescription());
    }

    @PutMapping(value={"groups/{groupId}/update"})
    @NotNull
    public AccountGroup updateGroup(@PathVariable @NotNull ID groupId, @RequestBody @Valid @NotNull AccountGroupInput input) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        AccountGroup accountGroup = this.accountService.updateGroup(groupId, input);
        Intrinsics.checkNotNullExpressionValue((Object)accountGroup, (String)"accountService.updateGroup(groupId, input)");
        return accountGroup;
    }

    @DeleteMapping(value={"groups/{groupId}"})
    @NotNull
    public Ack deleteGroup(@PathVariable @NotNull ID groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Ack ack = this.accountService.deleteGroup(groupId);
        Intrinsics.checkNotNullExpressionValue((Object)ack, (String)"accountService.deleteGroup(groupId)");
        return ack;
    }
}

