/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.util.Collection;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.common.Document;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.ServiceConfigurator;
import net.nemerosa.ontrack.model.settings.PredefinedValidationStampService;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.PredefinedValidationStamp;
import net.nemerosa.ontrack.model.structure.ServiceConfiguration;
import net.nemerosa.ontrack.model.structure.ServiceConfigurationSource;
import net.nemerosa.ontrack.model.structure.ValidationDataType;
import net.nemerosa.ontrack.model.structure.ValidationDataTypeConfig;
import net.nemerosa.ontrack.model.structure.ValidationDataTypeService;
import net.nemerosa.ontrack.model.structure.ValidationDataTypeServiceExtensionsKt;
import net.nemerosa.ontrack.model.structure.ValidationStampInput;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.LinkContainer;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@RestController
@RequestMapping(value={"/rest/admin"})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\u0012\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\u0012\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\u0017\u0010\u000f\u001a\u00020\f2\r\b\u0001\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012H\u0017J\b\u0010\u0013\u001a\u00020\u0014H\u0017J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016H\u0017J\u001c\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J!\u0010\u001b\u001a\u00020\f2\b\b\u0001\u0010\t\u001a\u00020\n2\r\b\u0001\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012H\u0017J\u0012\u0010\u001c\u001a\u00020\u00142\b\b\u0001\u0010\t\u001a\u00020\nH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lnet/nemerosa/ontrack/boot/ui/PredefinedValidationStampController;", "Lnet/nemerosa/ontrack/ui/controller/AbstractResourceController;", "predefinedValidationStampService", "Lnet/nemerosa/ontrack/model/settings/PredefinedValidationStampService;", "validationDataTypeService", "Lnet/nemerosa/ontrack/model/structure/ValidationDataTypeService;", "(Lnet/nemerosa/ontrack/model/settings/PredefinedValidationStampService;Lnet/nemerosa/ontrack/model/structure/ValidationDataTypeService;)V", "deleteValidationStamp", "Lnet/nemerosa/ontrack/model/Ack;", "predefinedValidationStampId", "Lnet/nemerosa/ontrack/model/structure/ID;", "getValidationStamp", "Lnet/nemerosa/ontrack/model/structure/PredefinedValidationStamp;", "getValidationStampImage", "Lnet/nemerosa/ontrack/common/Document;", "newPredefinedValidationStamp", "input", "Lnet/nemerosa/ontrack/model/structure/ValidationStampInput;", "Ljavax/validation/Valid;", "predefinedValidationStampCreationForm", "Lnet/nemerosa/ontrack/model/form/Form;", "predefinedValidationStampList", "Lnet/nemerosa/ontrack/ui/resource/Resources;", "setValidationStampImage", "", "file", "Lorg/springframework/web/multipart/MultipartFile;", "updateValidationStamp", "updateValidationStampForm", "ontrack-ui"})
public class PredefinedValidationStampController
extends AbstractResourceController {
    @NotNull
    private final PredefinedValidationStampService predefinedValidationStampService;
    @NotNull
    private final ValidationDataTypeService validationDataTypeService;

    public PredefinedValidationStampController(@NotNull PredefinedValidationStampService predefinedValidationStampService, @NotNull ValidationDataTypeService validationDataTypeService) {
        Intrinsics.checkNotNullParameter((Object)predefinedValidationStampService, (String)"predefinedValidationStampService");
        Intrinsics.checkNotNullParameter((Object)validationDataTypeService, (String)"validationDataTypeService");
        this.predefinedValidationStampService = predefinedValidationStampService;
        this.validationDataTypeService = validationDataTypeService;
    }

    @GetMapping(value={"predefinedValidationStamps"})
    @NotNull
    public Resources<PredefinedValidationStamp> predefinedValidationStampList() {
        LinkContainer linkContainer = Resources.of((Collection)this.predefinedValidationStampService.getPredefinedValidationStamps(), (URI)this.uri((Object)((PredefinedValidationStampController)MvcUriComponentsBuilder.on(this.getClass())).predefinedValidationStampList())).with("_create", this.uri((Object)((PredefinedValidationStampController)MvcUriComponentsBuilder.on(this.getClass())).predefinedValidationStampCreationForm()));
        Intrinsics.checkNotNullExpressionValue((Object)linkContainer, (String)"of(\n        predefinedVa\u2026tampCreationForm())\n    )");
        return (Resources)linkContainer;
    }

    @GetMapping(value={"predefinedValidationStamps/create"})
    @NotNull
    public Form predefinedValidationStampCreationForm() {
        Form form = Form.Companion.nameAndDescription();
        ServiceConfigurator serviceConfigurator = ((ServiceConfigurator)((ServiceConfigurator)((ServiceConfigurator)ServiceConfigurator.of((String)"dataType").label("Data type")).help("Type of the data to associate with a validation run.")).optional()).sources(this.validationDataTypeService.getAllTypes().stream().map(PredefinedValidationStampController::predefinedValidationStampCreationForm$lambda-0).collect(Collectors.toList()));
        Intrinsics.checkNotNullExpressionValue((Object)serviceConfigurator, (String)"of(\"dataType\")\n         \u2026())\n                    )");
        return form.with((Field)serviceConfigurator);
    }

    @PostMapping(value={"predefinedValidationStamps/create"})
    @NotNull
    public PredefinedValidationStamp newPredefinedValidationStamp(@RequestBody @NotNull ValidationStampInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        ServiceConfiguration serviceConfiguration = input.getDataType();
        ServiceConfiguration serviceConfiguration2 = input.getDataType();
        ValidationDataTypeConfig config = ValidationDataTypeServiceExtensionsKt.validateValidationDataTypeConfig((ValidationDataTypeService)this.validationDataTypeService, (String)(serviceConfiguration != null ? serviceConfiguration.getId() : null), (JsonNode)(serviceConfiguration2 != null ? serviceConfiguration2.getData() : null));
        String string = input.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.name");
        PredefinedValidationStamp predefinedValidationStamp = this.predefinedValidationStampService.newPredefinedValidationStamp(PredefinedValidationStamp.Companion.of(NameDescription.Companion.nd(string, input.getDescription())).withDataType(config));
        Intrinsics.checkNotNullExpressionValue((Object)predefinedValidationStamp, (String)"predefinedValidationStam\u2026ataType(config)\n        )");
        return predefinedValidationStamp;
    }

    @GetMapping(value={"predefinedValidationStamps/{predefinedValidationStampId}"})
    @NotNull
    public PredefinedValidationStamp getValidationStamp(@PathVariable @NotNull ID predefinedValidationStampId) {
        Intrinsics.checkNotNullParameter((Object)predefinedValidationStampId, (String)"predefinedValidationStampId");
        PredefinedValidationStamp predefinedValidationStamp = this.predefinedValidationStampService.getPredefinedValidationStamp(predefinedValidationStampId);
        Intrinsics.checkNotNullExpressionValue((Object)predefinedValidationStamp, (String)"predefinedValidationStam\u2026definedValidationStampId)");
        return predefinedValidationStamp;
    }

    @GetMapping(value={"predefinedValidationStamps/{predefinedValidationStampId}/update"})
    @NotNull
    public Form updateValidationStampForm(@PathVariable @NotNull ID predefinedValidationStampId) {
        Intrinsics.checkNotNullParameter((Object)predefinedValidationStampId, (String)"predefinedValidationStampId");
        PredefinedValidationStamp validationStamp = this.predefinedValidationStampService.getPredefinedValidationStamp(predefinedValidationStampId);
        return this.predefinedValidationStampCreationForm().fill("name", (Object)validationStamp.getName()).fill("description", (Object)validationStamp.getDescription()).fill("dataType", (Object)this.validationDataTypeService.getServiceConfigurationForConfig(validationStamp.getDataType()));
    }

    @PutMapping(value={"predefinedValidationStamps/{predefinedValidationStampId}/update"})
    @NotNull
    public PredefinedValidationStamp updateValidationStamp(@PathVariable @NotNull ID predefinedValidationStampId, @RequestBody @NotNull ValidationStampInput input) {
        Intrinsics.checkNotNullParameter((Object)predefinedValidationStampId, (String)"predefinedValidationStampId");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        PredefinedValidationStamp validationStamp = this.predefinedValidationStampService.getPredefinedValidationStamp(predefinedValidationStampId);
        ServiceConfiguration serviceConfiguration = input.getDataType();
        ServiceConfiguration serviceConfiguration2 = input.getDataType();
        ValidationDataTypeConfig dataTypeServiceConfig = ValidationDataTypeServiceExtensionsKt.validateValidationDataTypeConfig((ValidationDataTypeService)this.validationDataTypeService, (String)(serviceConfiguration != null ? serviceConfiguration.getId() : null), (JsonNode)(serviceConfiguration2 != null ? serviceConfiguration2.getData() : null));
        String string = input.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.name");
        validationStamp = validationStamp.update(NameDescription.Companion.nd(string, input.getDescription())).withDataType(dataTypeServiceConfig);
        this.predefinedValidationStampService.savePredefinedValidationStamp(validationStamp);
        PredefinedValidationStamp predefinedValidationStamp = validationStamp;
        Intrinsics.checkNotNullExpressionValue((Object)predefinedValidationStamp, (String)"validationStamp");
        return predefinedValidationStamp;
    }

    @DeleteMapping(value={"predefinedValidationStamps/{predefinedValidationStampId}"})
    @NotNull
    public Ack deleteValidationStamp(@PathVariable @NotNull ID predefinedValidationStampId) {
        Intrinsics.checkNotNullParameter((Object)predefinedValidationStampId, (String)"predefinedValidationStampId");
        Ack ack = this.predefinedValidationStampService.deletePredefinedValidationStamp(predefinedValidationStampId);
        Intrinsics.checkNotNullExpressionValue((Object)ack, (String)"predefinedValidationStam\u2026definedValidationStampId)");
        return ack;
    }

    @GetMapping(value={"predefinedValidationStamps/{predefinedValidationStampId}/image"})
    @NotNull
    public Document getValidationStampImage(@PathVariable @NotNull ID predefinedValidationStampId) {
        Intrinsics.checkNotNullParameter((Object)predefinedValidationStampId, (String)"predefinedValidationStampId");
        Document document = this.predefinedValidationStampService.getPredefinedValidationStampImage(predefinedValidationStampId);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"predefinedValidationStam\u2026definedValidationStampId)");
        return document;
    }

    @PostMapping(value={"predefinedValidationStamps/{predefinedValidationStampId}/image"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void setValidationStampImage(@PathVariable @NotNull ID predefinedValidationStampId, @RequestParam @NotNull MultipartFile file) {
        Intrinsics.checkNotNullParameter((Object)predefinedValidationStampId, (String)"predefinedValidationStampId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getContentType();
        Intrinsics.checkNotNull((Object)string);
        byte[] byArray = file.getBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"file.bytes");
        this.predefinedValidationStampService.setPredefinedValidationStampImage(predefinedValidationStampId, new Document(string, byArray));
    }

    private static final ServiceConfigurationSource predefinedValidationStampCreationForm$lambda-0(ValidationDataType dataType) {
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        return new ServiceConfigurationSource(dataType.getClass().getName(), dataType.getDisplayName(), dataType.getConfigForm(null), MapsKt.emptyMap());
    }
}

