/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.boot.ui.ValidationRunRequestForm;
import net.nemerosa.ontrack.boot.ui.ValidationRunRequestFormData;
import net.nemerosa.ontrack.json.JsonParseException;
import net.nemerosa.ontrack.model.exceptions.ValidationRunDataJSONInputException;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Selection;
import net.nemerosa.ontrack.model.form.ServiceConfigurator;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.ServiceConfigurationSource;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.model.structure.ValidationDataType;
import net.nemerosa.ontrack.model.structure.ValidationDataTypeConfig;
import net.nemerosa.ontrack.model.structure.ValidationDataTypeDescriptor;
import net.nemerosa.ontrack.model.structure.ValidationDataTypeService;
import net.nemerosa.ontrack.model.structure.ValidationRun;
import net.nemerosa.ontrack.model.structure.ValidationRunRequest;
import net.nemerosa.ontrack.model.structure.ValidationRunStatus;
import net.nemerosa.ontrack.model.structure.ValidationRunStatusChangeRequest;
import net.nemerosa.ontrack.model.structure.ValidationRunStatusID;
import net.nemerosa.ontrack.model.structure.ValidationRunStatusService;
import net.nemerosa.ontrack.model.structure.ValidationStamp;
import net.nemerosa.ontrack.model.structure.ValidationStampRunView;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.Pagination;
import net.nemerosa.ontrack.ui.resource.PaginationCountException;
import net.nemerosa.ontrack.ui.resource.PaginationOffsetException;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/rest/structure"})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u0012\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u000eH\u0017J,\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\b\b\u0001\u0010\u0015\u001a\u00020\u000e2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u0017H\u0017J\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u000eH\u0017J\u001c\u0010\u001b\u001a\u00020\f2\b\b\u0001\u0010\u0013\u001a\u00020\u000e2\b\b\u0001\u0010\u001c\u001a\u00020\u001dH\u0017J\u0012\u0010\u001e\u001a\u00020\u00102\b\b\u0001\u0010\u0013\u001a\u00020\u000eH\u0017J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001dH\u0012J\u001c\u0010#\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010$\u001a\u00020%H\u0017R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lnet/nemerosa/ontrack/boot/ui/ValidationRunController;", "Lnet/nemerosa/ontrack/ui/controller/AbstractResourceController;", "structureService", "Lnet/nemerosa/ontrack/model/structure/StructureService;", "validationRunStatusService", "Lnet/nemerosa/ontrack/model/structure/ValidationRunStatusService;", "validationDataTypeService", "Lnet/nemerosa/ontrack/model/structure/ValidationDataTypeService;", "securityService", "Lnet/nemerosa/ontrack/model/security/SecurityService;", "(Lnet/nemerosa/ontrack/model/structure/StructureService;Lnet/nemerosa/ontrack/model/structure/ValidationRunStatusService;Lnet/nemerosa/ontrack/model/structure/ValidationDataTypeService;Lnet/nemerosa/ontrack/model/security/SecurityService;)V", "getValidationRun", "Lnet/nemerosa/ontrack/model/structure/ValidationRun;", "validationRunId", "Lnet/nemerosa/ontrack/model/structure/ID;", "getValidationRunStatusChangeForm", "Lnet/nemerosa/ontrack/model/form/Form;", "getValidationRuns", "Lnet/nemerosa/ontrack/ui/resource/Resources;", "buildId", "getValidationRunsForValidationStamp", "validationStampId", "offset", "", "count", "getValidationStampRunViews", "Lnet/nemerosa/ontrack/model/structure/ValidationStampRunView;", "newValidationRun", "validationRunRequestForm", "Lnet/nemerosa/ontrack/boot/ui/ValidationRunRequestForm;", "newValidationRunForm", "parseValidationRunData", "", "build", "Lnet/nemerosa/ontrack/model/structure/Build;", "validationRunStatusChange", "request", "Lnet/nemerosa/ontrack/model/structure/ValidationRunStatusChangeRequest;", "ontrack-ui"})
public class ValidationRunController
extends AbstractResourceController {
    @NotNull
    private final StructureService structureService;
    @NotNull
    private final ValidationRunStatusService validationRunStatusService;
    @NotNull
    private final ValidationDataTypeService validationDataTypeService;
    @NotNull
    private final SecurityService securityService;

    @Autowired
    public ValidationRunController(@NotNull StructureService structureService, @NotNull ValidationRunStatusService validationRunStatusService, @NotNull ValidationDataTypeService validationDataTypeService, @NotNull SecurityService securityService) {
        Intrinsics.checkNotNullParameter((Object)structureService, (String)"structureService");
        Intrinsics.checkNotNullParameter((Object)validationRunStatusService, (String)"validationRunStatusService");
        Intrinsics.checkNotNullParameter((Object)validationDataTypeService, (String)"validationDataTypeService");
        Intrinsics.checkNotNullParameter((Object)securityService, (String)"securityService");
        this.structureService = structureService;
        this.validationRunStatusService = validationRunStatusService;
        this.validationDataTypeService = validationDataTypeService;
        this.securityService = securityService;
    }

    @GetMapping(value={"builds/{buildId}/validationRuns/view"})
    @NotNull
    public Resources<ValidationStampRunView> getValidationStampRunViews(@PathVariable @NotNull ID buildId) {
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Build build = this.structureService.getBuild(buildId);
        List views = StructureService.DefaultImpls.getValidationStampRunViewsForBuild$default((StructureService)this.structureService, (Build)build, (int)0, (int)0, (int)6, null);
        URI uri = this.uri((Object)((ValidationRunController)MvcUriComponentsBuilder.on(this.getClass())).getValidationStampRunViews(buildId));
        Resources resources = Resources.of((Collection)views, (URI)uri).forView(ValidationStampRunView.class);
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"of(\n                view\u2026StampRunView::class.java)");
        return resources;
    }

    @GetMapping(value={"builds/{buildId}/validationRuns"})
    @NotNull
    public Resources<ValidationRun> getValidationRuns(@PathVariable @NotNull ID buildId) {
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Resources resources = Resources.of((Collection)this.structureService.getValidationRunsForBuild(buildId, 0, 100), (URI)this.uri((Object)((ValidationRunController)MvcUriComponentsBuilder.on(ValidationRunController.class)).getValidationRuns(buildId))).forView(Build.class);
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"of(\n                stru\u2026orView(Build::class.java)");
        return resources;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"builds/{buildId}/validationRuns/create"})
    @NotNull
    public Form newValidationRunForm(@PathVariable @NotNull ID buildId) {
        Collection<ServiceConfigurationSource> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Build build = this.structureService.getBuild(buildId);
        Iterable iterable = this.structureService.getValidationStampListForBranch(build.getBranch().getId());
        ServiceConfigurator serviceConfigurator = (ServiceConfigurator)ServiceConfigurator.of((String)"validationStampData").label("Validation stamp");
        Form form = Form.Companion.create();
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ValidationDataTypeConfig validationDataTypeConfig;
            String string;
            String string2;
            block4: {
                block3: {
                    void dataType;
                    void it;
                    ValidationStamp validationStamp = (ValidationStamp)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    string2 = it.getName();
                    string = it.getName();
                    validationDataTypeConfig = it.getDataType();
                    if (validationDataTypeConfig == null) break block3;
                    ValidationDataTypeConfig validationDataTypeConfig2 = validationDataTypeConfig;
                    String string3 = string;
                    String string4 = string2;
                    boolean bl2 = false;
                    ValidationDataType validationDataType = this.validationDataTypeService.getValidationDataType(dataType.getDescriptor().getId());
                    Form form2 = validationDataType != null ? validationDataType.getForm(null) : null;
                    string2 = string4;
                    string = string3;
                    Form form3 = form2;
                    validationDataTypeConfig = form3;
                    if (form3 != null) break block4;
                }
                validationDataTypeConfig = Form.Companion.create();
            }
            ValidationDataTypeConfig validationDataTypeConfig3 = validationDataTypeConfig;
            String string5 = string;
            String string6 = string2;
            collection.add(new ServiceConfigurationSource(string6, string5, (Form)validationDataTypeConfig3));
        }
        collection = (List)destination$iv$iv;
        ServiceConfigurator serviceConfigurator2 = serviceConfigurator.sources((List)collection);
        Intrinsics.checkNotNullExpressionValue((Object)serviceConfigurator2, (String)"of(\"validationStampData\"\u2026                        )");
        Form form4 = form.with((Field)serviceConfigurator2);
        Selection selection = ((Selection)((Selection)Selection.of((String)"validationRunStatusId").label("Status")).optional()).items(this.validationRunStatusService.getValidationRunStatusRoots());
        Intrinsics.checkNotNullExpressionValue((Object)selection, (String)"of(\"validationRunStatusI\u2026validationRunStatusRoots)");
        return form4.with((Field)selection).description();
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"builds/{buildId}/validationRuns/create"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @NotNull
    public ValidationRun newValidationRun(@PathVariable @NotNull ID buildId, @RequestBody @NotNull ValidationRunRequestForm validationRunRequestForm) {
        ValidationRunStatusID validationRunStatusID;
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)validationRunRequestForm, (String)"validationRunRequestForm");
        Build build = this.structureService.getBuild(buildId);
        String string = validationRunRequestForm.getActualValidationStampName();
        String string2 = validationRunRequestForm.getValidationRunStatusId();
        if (string2 != null) {
            void $this$newValidationRun_u24lambda_u2d2;
            String string3 = string2;
            String string4 = string;
            boolean bl = false;
            validationRunStatusID = this.validationRunStatusService.getValidationRunStatus((String)$this$newValidationRun_u24lambda_u2d2);
            string = string4;
        } else {
            validationRunStatusID = null;
        }
        ValidationRunRequestFormData validationRunRequestFormData = validationRunRequestForm.getValidationStampData();
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 64;
        Signature signature = null;
        List list = validationRunRequestForm.getProperties();
        String string5 = validationRunRequestForm.getDescription();
        Object object = this.parseValidationRunData(build, validationRunRequestForm);
        String string6 = validationRunRequestFormData != null ? validationRunRequestFormData.getType() : null;
        ValidationRunStatusID validationRunStatusID2 = validationRunStatusID;
        String string7 = string;
        ValidationRunRequest validationRunRequest = new ValidationRunRequest(string7, validationRunStatusID2, string6, object, string5, list, signature, n, defaultConstructorMarker);
        return this.structureService.newValidationRun(build, validationRunRequest);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object parseValidationRunData(Build build, ValidationRunRequestForm validationRunRequestForm) {
        Object object;
        String typeId;
        ValidationRunRequestFormData validationRunRequestFormData = validationRunRequestForm.getValidationStampData();
        ValidationRunRequestFormData validationRunRequestFormData2 = validationRunRequestFormData;
        if (validationRunRequestFormData == null) return null;
        JsonNode jsonNode = validationRunRequestFormData2.getData();
        validationRunRequestFormData2 = jsonNode;
        if (jsonNode == null) return null;
        ValidationRunRequestFormData $this$parseValidationRunData_u24lambda_u2d5 = validationRunRequestFormData2;
        boolean bl = false;
        ValidationStamp validationStamp = this.structureService.getOrCreateValidationStamp(build.getBranch(), validationRunRequestForm.getActualValidationStampName());
        String string = validationRunRequestForm.getValidationStampData().getType();
        if (string == null) {
            ValidationDataTypeConfig validationDataTypeConfig = validationStamp.getDataType();
            ValidationDataTypeConfig validationDataTypeConfig2 = validationDataTypeConfig;
            if (validationDataTypeConfig == null) return null;
            ValidationDataTypeDescriptor validationDataTypeDescriptor = validationDataTypeConfig2.getDescriptor();
            validationDataTypeConfig2 = validationDataTypeDescriptor;
            if (validationDataTypeDescriptor == null) return null;
            string = validationDataTypeConfig2.getId();
        }
        if ((typeId = string) == null) return null;
        String $this$parseValidationRunData_u24lambda_u2d5_u24lambda_u2d3 = typeId;
        boolean bl2 = false;
        ValidationDataType validationDataType = this.validationDataTypeService.getValidationDataType($this$parseValidationRunData_u24lambda_u2d5_u24lambda_u2d3);
        if (validationDataType == null) return null;
        ValidationDataType $this$parseValidationRunData_u24lambda_u2d5_u24lambda_u2d4 = validationDataType;
        boolean bl3 = false;
        try {
            object = $this$parseValidationRunData_u24lambda_u2d5_u24lambda_u2d4.fromForm(validationRunRequestForm.getValidationStampData().getData());
        }
        catch (JsonParseException ex) {
            throw new ValidationRunDataJSONInputException(ex, validationRunRequestForm.getValidationStampData().getData());
        }
        Object object2 = object;
        return object2;
    }

    @GetMapping(value={"validationRuns/{validationRunId}"})
    @NotNull
    public ValidationRun getValidationRun(@PathVariable @NotNull ID validationRunId) {
        Intrinsics.checkNotNullParameter((Object)validationRunId, (String)"validationRunId");
        return this.structureService.getValidationRun(validationRunId);
    }

    @GetMapping(value={"validationRuns/{validationRunId}/status/change"})
    @NotNull
    public Form getValidationRunStatusChangeForm(@PathVariable @NotNull ID validationRunId) {
        Intrinsics.checkNotNullParameter((Object)validationRunId, (String)"validationRunId");
        ValidationRun validationRun = this.structureService.getValidationRun(validationRunId);
        Form form = Form.Companion.create();
        Selection selection = ((Selection)Selection.of((String)"validationRunStatusId").label("Status")).items(this.validationRunStatusService.getNextValidationRunStatusList(validationRun.getLastStatus().getStatusID().getId()));
        Intrinsics.checkNotNullExpressionValue((Object)selection, (String)"of(\"validationRunStatusI\u2026                        )");
        return form.with((Field)selection).description();
    }

    @PostMapping(value={"validationRuns/{validationRunId}/status/change"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @NotNull
    public ValidationRun validationRunStatusChange(@PathVariable @NotNull ID validationRunId, @RequestBody @NotNull ValidationRunStatusChangeRequest request) {
        Intrinsics.checkNotNullParameter((Object)validationRunId, (String)"validationRunId");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ValidationRun run = this.structureService.getValidationRun(validationRunId);
        Signature signature = this.securityService.getCurrentSignature();
        ValidationRunStatusID validationRunStatusID = this.validationRunStatusService.getValidationRunStatus(request.getValidationRunStatusId());
        Intrinsics.checkNotNullExpressionValue((Object)validationRunStatusID, (String)"validationRunStatusServi\u2026st.validationRunStatusId)");
        ValidationRunStatus runStatus = new ValidationRunStatus(ID.NONE, signature, validationRunStatusID, request.getDescription());
        return this.structureService.newValidationRunStatus(run, runStatus);
    }

    @GetMapping(value={"validationStamps/{validationStampId}/validationRuns"})
    @NotNull
    public Resources<ValidationRun> getValidationRunsForValidationStamp(@PathVariable @NotNull ID validationStampId, @RequestParam(required=false, defaultValue="0") int offset, @RequestParam(required=false, defaultValue="10") int count) {
        Intrinsics.checkNotNullParameter((Object)validationStampId, (String)"validationStampId");
        List runs = this.structureService.getValidationRunsForValidationStamp(validationStampId, 0, Integer.MAX_VALUE);
        int total = runs.size();
        if (offset < 0) {
            throw new PaginationOffsetException(offset);
        }
        if (offset > 0 && offset >= total) {
            throw new PaginationOffsetException(offset);
        }
        if (count <= 0) {
            throw new PaginationCountException(count);
        }
        Resources resources = Resources.of((Collection)runs.subList(offset, Math.min(offset + count, runs.size())), (URI)this.uri((Object)((ValidationRunController)MvcUriComponentsBuilder.on(ValidationRunController.class)).getValidationRunsForValidationStamp(validationStampId, offset, count)));
        Pagination pagination2 = Pagination.Companion.of(offset, count, total);
        if (offset > 0) {
            pagination2 = pagination2.withPrev(this.uri((Object)((ValidationRunController)MvcUriComponentsBuilder.on(ValidationRunController.class)).getValidationRunsForValidationStamp(validationStampId, Math.max(0, offset - count), count)));
        }
        if (offset + count < total) {
            pagination2 = pagination2.withNext(this.uri((Object)((ValidationRunController)MvcUriComponentsBuilder.on(ValidationRunController.class)).getValidationRunsForValidationStamp(validationStampId, offset + count, count)));
        }
        Resources resources2 = resources.withPagination(pagination2).forView(ValidationStampRunView.class);
        Intrinsics.checkNotNullExpressionValue((Object)resources2, (String)"resources.withPagination\u2026StampRunView::class.java)");
        return resources2;
    }
}

