/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import javax.validation.Valid;
import net.nemerosa.ontrack.common.Document;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.settings.PredefinedPromotionLevelService;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.PredefinedPromotionLevel;
import net.nemerosa.ontrack.model.structure.Reordering;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/rest/admin"})
public class PredefinedPromotionLevelController
extends AbstractResourceController {
    private final PredefinedPromotionLevelService predefinedPromotionLevelService;

    @Autowired
    public PredefinedPromotionLevelController(PredefinedPromotionLevelService predefinedPromotionLevelService) {
        this.predefinedPromotionLevelService = predefinedPromotionLevelService;
    }

    @RequestMapping(value={"predefinedPromotionLevels"}, method={RequestMethod.GET})
    public Resources<PredefinedPromotionLevel> getPredefinedPromotionLevelList() {
        return (Resources)((Resources)Resources.of((Collection)this.predefinedPromotionLevelService.getPredefinedPromotionLevels(), (URI)this.uri((Object)((PredefinedPromotionLevelController)MvcUriComponentsBuilder.on(this.getClass())).getPredefinedPromotionLevelList())).with("_create", this.uri((Object)((PredefinedPromotionLevelController)MvcUriComponentsBuilder.on(this.getClass())).getPredefinedPromotionLevelCreationForm()))).with("_reorderPromotionLevels", this.uri((Object)((PredefinedPromotionLevelController)MvcUriComponentsBuilder.on(this.getClass())).reorderPromotionLevelListForBranch(null)));
    }

    @RequestMapping(value={"predefinedPromotionLevels/reorder"}, method={RequestMethod.PUT})
    public Resources<PredefinedPromotionLevel> reorderPromotionLevelListForBranch(@RequestBody Reordering reordering) {
        this.predefinedPromotionLevelService.reorderPromotionLevels(reordering);
        return this.getPredefinedPromotionLevelList();
    }

    @RequestMapping(value={"predefinedPromotionLevels/create"}, method={RequestMethod.GET})
    public Form getPredefinedPromotionLevelCreationForm() {
        return PredefinedPromotionLevel.form();
    }

    @RequestMapping(value={"predefinedPromotionLevels/create"}, method={RequestMethod.POST})
    public PredefinedPromotionLevel newPredefinedPromotionLevel(@RequestBody @Valid NameDescription nameDescription) {
        return this.predefinedPromotionLevelService.newPredefinedPromotionLevel(PredefinedPromotionLevel.of((NameDescription)nameDescription));
    }

    @RequestMapping(value={"predefinedPromotionLevels/{predefinedPromotionLevelId}"}, method={RequestMethod.GET})
    public PredefinedPromotionLevel getPromotionLevel(@PathVariable ID predefinedPromotionLevelId) {
        return this.predefinedPromotionLevelService.getPredefinedPromotionLevel(predefinedPromotionLevelId);
    }

    @RequestMapping(value={"predefinedPromotionLevels/{predefinedPromotionLevelId}/update"}, method={RequestMethod.GET})
    public Form updatePromotionLevelForm(@PathVariable ID predefinedPromotionLevelId) {
        return this.predefinedPromotionLevelService.getPredefinedPromotionLevel(predefinedPromotionLevelId).asForm();
    }

    @RequestMapping(value={"predefinedPromotionLevels/{predefinedPromotionLevelId}/update"}, method={RequestMethod.PUT})
    public PredefinedPromotionLevel updatePromotionLevel(@PathVariable ID predefinedPromotionLevelId, @RequestBody @Valid NameDescription nameDescription) {
        PredefinedPromotionLevel promotionLevel = this.predefinedPromotionLevelService.getPredefinedPromotionLevel(predefinedPromotionLevelId);
        promotionLevel = promotionLevel.update(nameDescription);
        this.predefinedPromotionLevelService.savePredefinedPromotionLevel(promotionLevel);
        return promotionLevel;
    }

    @RequestMapping(value={"predefinedPromotionLevels/{predefinedPromotionLevelId}"}, method={RequestMethod.DELETE})
    public Ack deletePromotionLevel(@PathVariable ID predefinedPromotionLevelId) {
        return this.predefinedPromotionLevelService.deletePredefinedPromotionLevel(predefinedPromotionLevelId);
    }

    @RequestMapping(value={"predefinedPromotionLevels/{predefinedPromotionLevelId}/image"}, method={RequestMethod.GET})
    public Document getPromotionLevelImage(@PathVariable ID predefinedPromotionLevelId) {
        return this.predefinedPromotionLevelService.getPredefinedPromotionLevelImage(predefinedPromotionLevelId);
    }

    @RequestMapping(value={"predefinedPromotionLevels/{predefinedPromotionLevelId}/image"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void setPromotionLevelImage(@PathVariable ID predefinedPromotionLevelId, @RequestParam MultipartFile file) throws IOException {
        this.predefinedPromotionLevelService.setPredefinedPromotionLevelImage(predefinedPromotionLevelId, new Document(file.getContentType(), file.getBytes()));
    }
}

