/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.common.Document;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.ServiceConfigurator;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.security.ValidationStampCreate;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.DecorationService;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.Reordering;
import net.nemerosa.ontrack.model.structure.ServiceConfiguration;
import net.nemerosa.ontrack.model.structure.ServiceConfigurationSource;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.model.structure.ValidationDataType;
import net.nemerosa.ontrack.model.structure.ValidationDataTypeConfig;
import net.nemerosa.ontrack.model.structure.ValidationDataTypeService;
import net.nemerosa.ontrack.model.structure.ValidationDataTypeServiceExtensionsKt;
import net.nemerosa.ontrack.model.structure.ValidationStamp;
import net.nemerosa.ontrack.model.structure.ValidationStampInput;
import net.nemerosa.ontrack.model.structure.ValidationStampView;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.LinkContainer;
import net.nemerosa.ontrack.ui.resource.Resources;
import net.nemerosa.ontrack.ui.support.UIUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@RestController
@RequestMapping(value={"/rest/structure"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u0012\u0010\u000f\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u0012\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u001c\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u000eH\u0017J\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u000eH\u0017J!\u0010\u001b\u001a\u00020\u00112\b\b\u0001\u0010\u0018\u001a\u00020\u000e2\r\b\u0001\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001eH\u0017J\u0012\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010\u0018\u001a\u00020\u000eH\u0017J$\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u000e2\n\b\u0001\u0010\"\u001a\u0004\u0018\u00010#H\u0017J\u001c\u0010$\u001a\u00020%2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010&\u001a\u00020'H\u0017J!\u0010(\u001a\u00020\u00112\b\b\u0001\u0010\r\u001a\u00020\u000e2\r\b\u0001\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001eH\u0017J\u0012\u0010)\u001a\u00020 2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lnet/nemerosa/ontrack/boot/ui/ValidationStampController;", "Lnet/nemerosa/ontrack/ui/controller/AbstractResourceController;", "structureService", "Lnet/nemerosa/ontrack/model/structure/StructureService;", "securityService", "Lnet/nemerosa/ontrack/model/security/SecurityService;", "decorationService", "Lnet/nemerosa/ontrack/model/structure/DecorationService;", "validationDataTypeService", "Lnet/nemerosa/ontrack/model/structure/ValidationDataTypeService;", "(Lnet/nemerosa/ontrack/model/structure/StructureService;Lnet/nemerosa/ontrack/model/security/SecurityService;Lnet/nemerosa/ontrack/model/structure/DecorationService;Lnet/nemerosa/ontrack/model/structure/ValidationDataTypeService;)V", "bulkUpdate", "Lnet/nemerosa/ontrack/model/Ack;", "validationStampId", "Lnet/nemerosa/ontrack/model/structure/ID;", "deleteValidationStamp", "getValidationStamp", "Lnet/nemerosa/ontrack/model/structure/ValidationStamp;", "getValidationStampImage_", "Lnet/nemerosa/ontrack/common/Document;", "response", "Ljavax/servlet/http/HttpServletResponse;", "getValidationStampListForBranch", "Lnet/nemerosa/ontrack/ui/resource/Resources;", "branchId", "getValidationStampViewListForBranch", "Lnet/nemerosa/ontrack/model/structure/ValidationStampView;", "newValidationStamp", "input", "Lnet/nemerosa/ontrack/model/structure/ValidationStampInput;", "Ljavax/validation/Valid;", "newValidationStampForm", "Lnet/nemerosa/ontrack/model/form/Form;", "reorderValidationStampListForBranch", "reordering", "Lnet/nemerosa/ontrack/model/structure/Reordering;", "setValidationStampImage", "", "file", "Lorg/springframework/web/multipart/MultipartFile;", "updateValidationStamp", "updateValidationStampForm", "ontrack-ui"})
public class ValidationStampController
extends AbstractResourceController {
    @NotNull
    private final StructureService structureService;
    @NotNull
    private final SecurityService securityService;
    @NotNull
    private final DecorationService decorationService;
    @NotNull
    private final ValidationDataTypeService validationDataTypeService;

    public ValidationStampController(@NotNull StructureService structureService, @NotNull SecurityService securityService, @NotNull DecorationService decorationService, @NotNull ValidationDataTypeService validationDataTypeService) {
        Intrinsics.checkNotNullParameter((Object)structureService, (String)"structureService");
        Intrinsics.checkNotNullParameter((Object)securityService, (String)"securityService");
        Intrinsics.checkNotNullParameter((Object)decorationService, (String)"decorationService");
        Intrinsics.checkNotNullParameter((Object)validationDataTypeService, (String)"validationDataTypeService");
        this.structureService = structureService;
        this.securityService = securityService;
        this.decorationService = decorationService;
        this.validationDataTypeService = validationDataTypeService;
    }

    @GetMapping(value={"branches/{branchId}/validationStamps"})
    @NotNull
    public Resources<ValidationStamp> getValidationStampListForBranch(@PathVariable @NotNull ID branchId) {
        Intrinsics.checkNotNullParameter((Object)branchId, (String)"branchId");
        Project project = this.structureService.getBranch(branchId).component5();
        LinkContainer linkContainer = Resources.of((Collection)this.structureService.getValidationStampListForBranch(branchId), (URI)this.uri((Object)((ValidationStampController)MvcUriComponentsBuilder.on(ValidationStampController.class)).getValidationStampListForBranch(branchId))).with("_create", this.uri((Object)((ValidationStampController)MvcUriComponentsBuilder.on(ValidationStampController.class)).newValidationStampForm(branchId)), this.securityService.isProjectFunctionGranted(project.id(), ValidationStampCreate.class));
        Intrinsics.checkNotNullExpressionValue((Object)linkContainer, (String)"of(\n            structur\u2026class.java)\n            )");
        return (Resources)linkContainer;
    }

    @GetMapping(value={"branches/{branchId}/validationStamps/view"})
    @Transactional
    @NotNull
    public Resources<ValidationStampView> getValidationStampViewListForBranch(@PathVariable @NotNull ID branchId) {
        Intrinsics.checkNotNullParameter((Object)branchId, (String)"branchId");
        Resources resources = this.getValidationStampListForBranch(branchId).transform(arg_0 -> ValidationStampController.getValidationStampViewListForBranch$lambda-0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"getValidationStampListFo\u2026          )\n            }");
        return resources;
    }

    @PutMapping(value={"branches/{branchId}/validationStamps/reorder"})
    @NotNull
    public Resources<ValidationStamp> reorderValidationStampListForBranch(@PathVariable @NotNull ID branchId, @RequestBody @Nullable Reordering reordering) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)branchId, (String)"branchId");
            Reordering reordering2 = reordering;
            if (reordering2 == null) break block0;
            Reordering it = reordering2;
            boolean bl = false;
            this.structureService.reorderValidationStamps(branchId, reordering);
        }
        return this.getValidationStampListForBranch(branchId);
    }

    @GetMapping(value={"branches/{branchId}/validationStamps/create"})
    @NotNull
    public Form newValidationStampForm(@PathVariable @NotNull ID branchId) {
        Intrinsics.checkNotNullParameter((Object)branchId, (String)"branchId");
        this.structureService.getBranch(branchId);
        Form form = Form.Companion.nameAndDescription();
        ServiceConfigurator serviceConfigurator = ((ServiceConfigurator)((ServiceConfigurator)((ServiceConfigurator)ServiceConfigurator.of((String)"dataType").label("Data type")).help("Type of the data to associate with a validation run.")).optional()).sources(this.validationDataTypeService.getAllTypes().stream().map(ValidationStampController::newValidationStampForm$lambda-2).collect(Collectors.toList()));
        Intrinsics.checkNotNullExpressionValue((Object)serviceConfigurator, (String)"of(\"dataType\")\n         \u2026())\n                    )");
        return form.with((Field)serviceConfigurator);
    }

    @PostMapping(value={"branches/{branchId}/validationStamps/create"})
    @NotNull
    public ValidationStamp newValidationStamp(@PathVariable @NotNull ID branchId, @RequestBody @NotNull ValidationStampInput input) {
        Intrinsics.checkNotNullParameter((Object)branchId, (String)"branchId");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Branch branch = this.structureService.getBranch(branchId);
        ServiceConfiguration serviceConfiguration = input.getDataType();
        ServiceConfiguration serviceConfiguration2 = input.getDataType();
        ValidationDataTypeConfig config = ValidationDataTypeServiceExtensionsKt.validateValidationDataTypeConfig((ValidationDataTypeService)this.validationDataTypeService, (String)(serviceConfiguration != null ? serviceConfiguration.getId() : null), (JsonNode)(serviceConfiguration2 != null ? serviceConfiguration2.getData() : null));
        NameDescription nameDescription = input.asNameDescription();
        Intrinsics.checkNotNullExpressionValue((Object)nameDescription, (String)"input.asNameDescription()");
        ValidationStamp validationStamp = ValidationStamp.Companion.of(branch, nameDescription).withDataType(config);
        return this.structureService.newValidationStamp(validationStamp);
    }

    @GetMapping(value={"validationStamps/{validationStampId}"})
    @NotNull
    public ValidationStamp getValidationStamp(@PathVariable @NotNull ID validationStampId) {
        Intrinsics.checkNotNullParameter((Object)validationStampId, (String)"validationStampId");
        return this.structureService.getValidationStamp(validationStampId);
    }

    @GetMapping(value={"validationStamps/{validationStampId}/update"})
    @NotNull
    public Form updateValidationStampForm(@PathVariable @NotNull ID validationStampId) {
        Intrinsics.checkNotNullParameter((Object)validationStampId, (String)"validationStampId");
        ValidationStamp validationStamp = this.structureService.getValidationStamp(validationStampId);
        String name = validationStamp.component2();
        String description = validationStamp.component3();
        Branch branch = validationStamp.component4();
        ValidationDataTypeConfig dataType = validationStamp.component8();
        return this.newValidationStampForm(branch.getId()).fill("name", (Object)name).fill("description", (Object)description).fill("dataType", (Object)this.validationDataTypeService.getServiceConfigurationForConfig(dataType));
    }

    @PutMapping(value={"validationStamps/{validationStampId}/update"})
    @NotNull
    public ValidationStamp updateValidationStamp(@PathVariable @NotNull ID validationStampId, @RequestBody @NotNull ValidationStampInput input) {
        Intrinsics.checkNotNullParameter((Object)validationStampId, (String)"validationStampId");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        ValidationStamp validationStamp = this.structureService.getValidationStamp(validationStampId);
        ServiceConfiguration serviceConfiguration = input.getDataType();
        ServiceConfiguration serviceConfiguration2 = input.getDataType();
        ValidationDataTypeConfig dataTypeServiceConfig = ValidationDataTypeServiceExtensionsKt.validateValidationDataTypeConfig((ValidationDataTypeService)this.validationDataTypeService, (String)(serviceConfiguration != null ? serviceConfiguration.getId() : null), (JsonNode)(serviceConfiguration2 != null ? serviceConfiguration2.getData() : null));
        NameDescription nameDescription = input.asNameDescription();
        Intrinsics.checkNotNullExpressionValue((Object)nameDescription, (String)"input.asNameDescription()");
        validationStamp = validationStamp.update(nameDescription).withDataType(dataTypeServiceConfig);
        this.structureService.saveValidationStamp(validationStamp);
        return validationStamp;
    }

    @DeleteMapping(value={"validationStamps/{validationStampId}"})
    @NotNull
    public Ack deleteValidationStamp(@PathVariable @NotNull ID validationStampId) {
        Intrinsics.checkNotNullParameter((Object)validationStampId, (String)"validationStampId");
        return this.structureService.deleteValidationStamp(validationStampId);
    }

    @GetMapping(value={"validationStamps/{validationStampId}/image"})
    @NotNull
    public Document getValidationStampImage_(@Nullable HttpServletResponse response, @PathVariable @NotNull ID validationStampId) {
        Intrinsics.checkNotNullParameter((Object)validationStampId, (String)"validationStampId");
        Document image = this.structureService.getValidationStampImage(validationStampId);
        UIUtils.setupDefaultImageCache((HttpServletResponse)response, (Document)image);
        return image;
    }

    @PostMapping(value={"validationStamps/{validationStampId}/image"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void setValidationStampImage(@PathVariable @NotNull ID validationStampId, @RequestParam @NotNull MultipartFile file) {
        Intrinsics.checkNotNullParameter((Object)validationStampId, (String)"validationStampId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getContentType();
        Intrinsics.checkNotNull((Object)string);
        byte[] byArray = file.getBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"file.bytes");
        this.structureService.setValidationStampImage(validationStampId, new Document(string, byArray));
    }

    @PutMapping(value={"validationStamps/{validationStampId}/bulk"})
    @NotNull
    public Ack bulkUpdate(@PathVariable @NotNull ID validationStampId) {
        Intrinsics.checkNotNullParameter((Object)validationStampId, (String)"validationStampId");
        return this.structureService.bulkUpdateValidationStamps(validationStampId);
    }

    private static final ValidationStampView getValidationStampViewListForBranch$lambda-0(ValidationStampController this$0, ValidationStamp validationStamp) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return ValidationStampView.of((ValidationStamp)validationStamp, (List)this$0.decorationService.getDecorations((ProjectEntity)validationStamp));
    }

    private static final ServiceConfigurationSource newValidationStampForm$lambda-2(ValidationDataType dataType) {
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        return new ServiceConfigurationSource(dataType.getClass().getName(), dataType.getDisplayName(), dataType.getConfigForm(null), MapsKt.emptyMap());
    }
}

