/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.support;

import java.io.IOException;
import java.io.InputStream;
import net.nemerosa.ontrack.common.Document;
import org.apache.commons.io.IOUtils;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class DocumentHttpMessageConverter
extends AbstractHttpMessageConverter<Document> {
    public DocumentHttpMessageConverter() {
        super(new MediaType[]{MediaType.IMAGE_GIF, MediaType.IMAGE_JPEG, MediaType.IMAGE_PNG});
    }

    protected boolean supports(Class<?> clazz) {
        return Document.class.isAssignableFrom(clazz);
    }

    protected Document readInternal(Class<? extends Document> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return new Document(inputMessage.getHeaders().getContentType().toString(), IOUtils.toByteArray((InputStream)inputMessage.getBody()));
    }

    protected void writeInternal(Document document, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        outputMessage.getHeaders().setContentType(MediaType.parseMediaType((String)document.getType()));
        byte[] content = document.getContent();
        outputMessage.getHeaders().setContentLength((long)content.length);
        outputMessage.getBody().write(content);
    }
}

