/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import net.nemerosa.ontrack.extension.api.BuildDiffExtension;
import net.nemerosa.ontrack.extension.api.ExtensionManager;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.buildfilter.BuildFilterProviderData;
import net.nemerosa.ontrack.model.buildfilter.BuildFilterService;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Replacements;
import net.nemerosa.ontrack.model.form.Selection;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.security.BranchCreate;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.BranchBuildView;
import net.nemerosa.ontrack.model.structure.BranchBulkUpdateRequest;
import net.nemerosa.ontrack.model.structure.BranchCloneRequest;
import net.nemerosa.ontrack.model.structure.BranchCopyRequest;
import net.nemerosa.ontrack.model.structure.BranchFavouriteService;
import net.nemerosa.ontrack.model.structure.BranchStatusView;
import net.nemerosa.ontrack.model.structure.CopyService;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescriptionState;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.Resources;
import net.nemerosa.ontrack.ui.support.UIUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/rest/structure"})
public class BranchController
extends AbstractResourceController {
    private final StructureService structureService;
    private final CopyService copyService;
    private final BuildFilterService buildFilterService;
    private final ExtensionManager extensionManager;
    private final SecurityService securityService;
    private final BranchFavouriteService branchFavouriteService;

    @Autowired
    public BranchController(StructureService structureService, CopyService copyService, BuildFilterService buildFilterService, ExtensionManager extensionManager, SecurityService securityService, BranchFavouriteService branchFavouriteService) {
        this.structureService = structureService;
        this.copyService = copyService;
        this.buildFilterService = buildFilterService;
        this.extensionManager = extensionManager;
        this.securityService = securityService;
        this.branchFavouriteService = branchFavouriteService;
    }

    @RequestMapping(value={"projects/{projectId}/branches"}, method={RequestMethod.GET})
    public Resources<Branch> getBranchListForProject(@PathVariable ID projectId) {
        return (Resources)Resources.of((Collection)this.structureService.getBranchesForProject(projectId), (URI)this.uri((Object)((BranchController)MvcUriComponentsBuilder.on(BranchController.class)).getBranchListForProject(projectId))).with("_create", this.uri((Object)((BranchController)MvcUriComponentsBuilder.on(BranchController.class)).newBranch(projectId, null)), this.securityService.isProjectFunctionGranted(projectId.getValue(), BranchCreate.class));
    }

    @RequestMapping(value={"projects/{projectId}/branches/create"}, method={RequestMethod.GET})
    public Form newBranchForm(@PathVariable ID projectId) {
        this.structureService.getProject(projectId);
        return Branch.form();
    }

    @RequestMapping(value={"projects/{projectId}/branches/create"}, method={RequestMethod.POST})
    public Branch newBranch(@PathVariable ID projectId, @RequestBody @Valid NameDescriptionState nameDescription) {
        Project project = this.structureService.getProject(projectId);
        Branch branch = Branch.of((Project)project, (NameDescriptionState)nameDescription);
        branch = this.structureService.newBranch(branch);
        return branch;
    }

    @RequestMapping(value={"branches/{branchId}"}, method={RequestMethod.GET})
    public Branch getBranch(@PathVariable ID branchId) {
        return this.structureService.getBranch(branchId);
    }

    @RequestMapping(value={"branches/{branchId}"}, method={RequestMethod.DELETE})
    public Ack deleteBranch(@PathVariable ID branchId) {
        return this.structureService.deleteBranch(branchId);
    }

    @RequestMapping(value={"branches/{branchId}/update"}, method={RequestMethod.GET})
    public Form getUpdateForm(@PathVariable ID branchId) {
        return this.structureService.getBranch(branchId).toForm();
    }

    @RequestMapping(value={"branches/{branchId}/update"}, method={RequestMethod.PUT})
    public Branch updateBranch(@PathVariable ID branchId, @RequestBody @Valid NameDescriptionState form) {
        Branch branch = this.structureService.getBranch(branchId).update(form);
        this.structureService.saveBranch(branch);
        return branch;
    }

    @RequestMapping(value={"branches/{branchId}/enable"}, method={RequestMethod.PUT})
    public Branch enableBranch(@PathVariable ID branchId) {
        Branch branch = this.structureService.getBranch(branchId);
        return this.structureService.enableBranch(branch);
    }

    @RequestMapping(value={"branches/{branchId}/disable"}, method={RequestMethod.PUT})
    public Branch disableBranch(@PathVariable ID branchId) {
        Branch branch = this.structureService.getBranch(branchId).withDisabled(true);
        return this.structureService.disableBranch(branch);
    }

    @RequestMapping(value={"branches/{branchId}/status"}, method={RequestMethod.GET})
    public BranchStatusView getBranchStatusView(@PathVariable ID branchId) {
        return this.structureService.getBranchStatusView(this.structureService.getBranch(branchId));
    }

    @RequestMapping(value={"branches/{branchId}/view"}, method={RequestMethod.GET})
    public BranchBuildView buildView(@PathVariable ID branchId) {
        return this.buildViewWithFilter(branchId, this.buildFilterService.defaultFilterProviderData());
    }

    @RequestMapping(value={"branches/{branchId}/view/{filterType:.*}"}, method={RequestMethod.GET})
    public <T> BranchBuildView buildViewWithFilter(@PathVariable ID branchId, @PathVariable String filterType, WebRequest request) {
        JsonNode jsonParameters = UIUtils.requestParametersToJson((WebRequest)request);
        BuildFilterProviderData buildFilterProvider = this.buildFilterService.getBuildFilterProviderData(filterType, jsonParameters);
        return this.buildViewWithFilter(branchId, buildFilterProvider);
    }

    @RequestMapping(value={"branches/{branchId}/copy"}, method={RequestMethod.GET})
    public Form copy(@PathVariable ID branchId) {
        return Form.create().with((Field)((Selection)((Selection)Selection.of((String)"sourceBranch").label("Source branch")).help("Branch to copy configuration from")).items(this.structureService.getProjectList().stream().flatMap(project -> this.structureService.getBranchesForProject(project.getId()).stream()).filter(branch -> !branchId.equals((Object)branch.getId())).collect(Collectors.toList()))).with((Field)Replacements.of((String)"replacements").label("Replacements"));
    }

    @RequestMapping(value={"branches/{branchId}/copy"}, method={RequestMethod.PUT})
    public Branch copy(@PathVariable ID branchId, @RequestBody BranchCopyRequest request) {
        Branch branch = this.structureService.getBranch(branchId);
        return this.copyService.copy(branch, request);
    }

    @RequestMapping(value={"branches/{branchId}/update/bulk"}, method={RequestMethod.GET})
    public Form bulkUpdate(@PathVariable ID branchId) {
        return Form.create().with((Field)Replacements.of((String)"replacements").label("Replacements"));
    }

    @RequestMapping(value={"branches/{branchId}/update/bulk"}, method={RequestMethod.PUT})
    public Branch bulkUpdate(@PathVariable ID branchId, @RequestBody BranchBulkUpdateRequest request) {
        Branch branch = this.structureService.getBranch(branchId);
        return this.copyService.update(branch, request);
    }

    @RequestMapping(value={"branches/{branchId}/clone"}, method={RequestMethod.GET})
    public Form clone(@PathVariable ID branchId) {
        return Form.create().with((Field)((Text)Text.of((String)"name").label("Target branch")).help("Name of the branch to create")).with((Field)Replacements.of((String)"replacements").label("Replacements"));
    }

    @RequestMapping(value={"branches/{branchId}/clone"}, method={RequestMethod.POST})
    public Branch clone(@PathVariable ID branchId, @RequestBody BranchCloneRequest request) {
        Branch branch = this.structureService.getBranch(branchId);
        return this.copyService.cloneBranch(branch, request);
    }

    private <T> BranchBuildView buildViewWithFilter(ID branchId, BuildFilterProviderData<T> buildFilterProviderData) {
        Branch branch = this.structureService.getBranch(branchId);
        List builds = buildFilterProviderData.filterBranchBuilds(branch);
        List buildDiffActions = this.extensionManager.getExtensions(BuildDiffExtension.class).stream().filter(extension -> extension.apply(branch.getProject())).map(arg_0 -> ((BranchController)this).resolveExtensionAction(arg_0)).collect(Collectors.toList());
        return new BranchBuildView(builds.stream().map(build -> this.structureService.getBuildView(build, true)).collect(Collectors.toList()), buildDiffActions);
    }

    @RequestMapping(value={"branches/{branchId}/favourite"}, method={RequestMethod.PUT})
    public Branch favouriteBranch(@PathVariable ID branchId) {
        Branch branch = this.structureService.getBranch(branchId);
        this.branchFavouriteService.setBranchFavourite(branch, true);
        return branch;
    }

    @RequestMapping(value={"branches/{branchId}/unfavourite"}, method={RequestMethod.PUT})
    public Branch unfavouriteBranch(@PathVariable ID branchId) {
        Branch branch = this.structureService.getBranch(branchId);
        this.branchFavouriteService.setBranchFavourite(branch, false);
        return branch;
    }
}

