/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.boot.ui.SearchController;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.structure.SearchRequest;
import net.nemerosa.ontrack.model.structure.SearchResultType;
import net.nemerosa.ontrack.model.structure.SearchResults;
import net.nemerosa.ontrack.model.structure.SearchService;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/search"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0017J\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017J\u0012\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000b\u001a\u00020\u000fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/nemerosa/ontrack/boot/ui/SearchController;", "", "searchService", "Lnet/nemerosa/ontrack/model/structure/SearchService;", "(Lnet/nemerosa/ontrack/model/structure/SearchService;)V", "getSearchTypes", "", "Lnet/nemerosa/ontrack/model/structure/SearchResultType;", "search", "Lorg/springframework/http/ResponseEntity;", "Lnet/nemerosa/ontrack/model/structure/SearchResults;", "request", "Lnet/nemerosa/ontrack/model/structure/SearchRequest;", "searchIndexReset", "Lnet/nemerosa/ontrack/model/Ack;", "Lnet/nemerosa/ontrack/boot/ui/SearchController$SearchIndexResetRequest;", "SearchIndexResetRequest", "ontrack-ui"})
public class SearchController {
    @NotNull
    private final SearchService searchService;

    public SearchController(@NotNull SearchService searchService) {
        Intrinsics.checkNotNullParameter((Object)searchService, (String)"searchService");
        this.searchService = searchService;
    }

    @PostMapping(value={""})
    @NotNull
    public ResponseEntity<SearchResults> search(@RequestBody @NotNull SearchRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.searchService.paginatedSearch(request));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(searchService.paginatedSearch(request))");
        return responseEntity;
    }

    @GetMapping(value={"types"})
    @NotNull
    public List<SearchResultType> getSearchTypes() {
        return this.searchService.getSearchResultTypes();
    }

    @PostMapping(value={"index/reset"})
    @NotNull
    public Ack searchIndexReset(@RequestBody @NotNull SearchIndexResetRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.searchService.indexReset(request.getReindex());
    }
}

