/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import net.nemerosa.ontrack.boot.ui.AbstractProjectEntityController;
import net.nemerosa.ontrack.model.exceptions.BranchNotFoundException;
import net.nemerosa.ontrack.model.exceptions.BuildNotFoundException;
import net.nemerosa.ontrack.model.exceptions.ProjectNotFoundException;
import net.nemerosa.ontrack.model.exceptions.PromotionLevelNotFoundException;
import net.nemerosa.ontrack.model.exceptions.ValidationStampNotFoundException;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.PromotionLevel;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.model.structure.ValidationStamp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/structure"})
public class StructureController
extends AbstractProjectEntityController {
    @Autowired
    public StructureController(StructureService structureService) {
        super(structureService);
    }

    @RequestMapping(value={"entity/project/{project:.*}"}, method={RequestMethod.GET})
    public Project project(@PathVariable String project) {
        return (Project)this.structureService.findProjectByName(project).orElseThrow(() -> new ProjectNotFoundException(project));
    }

    @RequestMapping(value={"entity/branch/{project}/{branch:.*}"}, method={RequestMethod.GET})
    public Branch branch(@PathVariable String project, @PathVariable String branch) {
        return (Branch)this.structureService.findBranchByName(project, branch).orElseThrow(() -> new BranchNotFoundException(project, branch));
    }

    @RequestMapping(value={"entity/promotionLevel/{project}/{branch}/{promotionLevel:.*}"}, method={RequestMethod.GET})
    public PromotionLevel promotionLevel(@PathVariable String project, @PathVariable String branch, @PathVariable String promotionLevel) {
        return (PromotionLevel)this.structureService.findPromotionLevelByName(project, branch, promotionLevel).orElseThrow(() -> new PromotionLevelNotFoundException(project, branch, promotionLevel));
    }

    @RequestMapping(value={"entity/validationStamp/{project}/{branch}/{validationStamp:.*}"}, method={RequestMethod.GET})
    public ValidationStamp validationStamp(@PathVariable String project, @PathVariable String branch, @PathVariable String validationStamp) {
        return (ValidationStamp)this.structureService.findValidationStampByName(project, branch, validationStamp).orElseThrow(() -> new ValidationStampNotFoundException(project, branch, validationStamp));
    }

    @RequestMapping(value={"entity/build/{project}/{branch}/{build:.*}"}, method={RequestMethod.GET})
    public Build build(@PathVariable String project, @PathVariable String branch, @PathVariable String build) {
        return (Build)this.structureService.findBuildByName(project, branch, build).orElseThrow(() -> new BuildNotFoundException(project, branch, build));
    }
}

