/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.boot.ui.AdminStatus;
import net.nemerosa.ontrack.boot.ui.JobFilter;
import net.nemerosa.ontrack.boot.ui.JobFilterResources;
import net.nemerosa.ontrack.job.JobCategory;
import net.nemerosa.ontrack.job.JobKey;
import net.nemerosa.ontrack.job.JobScheduler;
import net.nemerosa.ontrack.job.JobStatus;
import net.nemerosa.ontrack.job.JobType;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.security.ApplicationManagement;
import net.nemerosa.ontrack.model.security.EncryptionService;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.support.ApplicationLogEntry;
import net.nemerosa.ontrack.model.support.ApplicationLogEntryFilter;
import net.nemerosa.ontrack.model.support.ApplicationLogService;
import net.nemerosa.ontrack.model.support.ConnectorGlobalStatusService;
import net.nemerosa.ontrack.model.support.Page;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.LinkContainer;
import net.nemerosa.ontrack.ui.resource.PaginatedList;
import net.nemerosa.ontrack.ui.resource.Pagination;
import net.nemerosa.ontrack.ui.resource.Resource;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.HealthComponent;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@RestController
@RequestMapping(value={"/rest/admin"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u00002\u00020\u0001B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017J\b\u0010\u0013\u001a\u00020\u0010H\u0017J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0017J\b\u0010\u0017\u001a\u00020\u0018H\u0017J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0017J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0017J\u0018\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00160(2\b\b\u0001\u0010)\u001a\u00020\u0016H\u0017J\u0012\u0010*\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017J\b\u0010+\u001a\u00020\u0010H\u0017J\u0012\u0010,\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017J\b\u0010-\u001a\u00020\u0010H\u0017J\u0012\u0010.\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017J\u0012\u0010/\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lnet/nemerosa/ontrack/boot/ui/AdminController;", "Lnet/nemerosa/ontrack/ui/controller/AbstractResourceController;", "jobScheduler", "Lnet/nemerosa/ontrack/job/JobScheduler;", "applicationLogService", "Lnet/nemerosa/ontrack/model/support/ApplicationLogService;", "healthEndpoint", "Lorg/springframework/boot/actuate/health/HealthEndpoint;", "connectorGlobalStatusService", "Lnet/nemerosa/ontrack/model/support/ConnectorGlobalStatusService;", "securityService", "Lnet/nemerosa/ontrack/model/security/SecurityService;", "encryptionService", "Lnet/nemerosa/ontrack/model/security/EncryptionService;", "(Lnet/nemerosa/ontrack/job/JobScheduler;Lnet/nemerosa/ontrack/model/support/ApplicationLogService;Lorg/springframework/boot/actuate/health/HealthEndpoint;Lnet/nemerosa/ontrack/model/support/ConnectorGlobalStatusService;Lnet/nemerosa/ontrack/model/security/SecurityService;Lnet/nemerosa/ontrack/model/security/EncryptionService;)V", "deleteJob", "Lnet/nemerosa/ontrack/model/Ack;", "id", "", "deleteLogEntries", "exportEncryptionKey", "Lorg/springframework/http/ResponseEntity;", "", "getJobFilter", "Lnet/nemerosa/ontrack/boot/ui/JobFilterResources;", "getJobs", "Lnet/nemerosa/ontrack/ui/resource/Resources;", "Lnet/nemerosa/ontrack/job/JobStatus;", "jobFilter", "Lnet/nemerosa/ontrack/boot/ui/JobFilter;", "page", "Lnet/nemerosa/ontrack/model/support/Page;", "getLogEntries", "Lnet/nemerosa/ontrack/model/support/ApplicationLogEntry;", "filter", "Lnet/nemerosa/ontrack/model/support/ApplicationLogEntryFilter;", "getStatus", "Lnet/nemerosa/ontrack/ui/resource/Resource;", "Lnet/nemerosa/ontrack/boot/ui/AdminStatus;", "importEncryptionKey", "Lorg/springframework/http/HttpEntity;", "payload", "launchJob", "pauseAllJobs", "pauseJob", "resumeAllJobs", "resumeJob", "stopJob", "ontrack-ui"})
public class AdminController
extends AbstractResourceController {
    @NotNull
    private final JobScheduler jobScheduler;
    @NotNull
    private final ApplicationLogService applicationLogService;
    @NotNull
    private final HealthEndpoint healthEndpoint;
    @NotNull
    private final ConnectorGlobalStatusService connectorGlobalStatusService;
    @NotNull
    private final SecurityService securityService;
    @NotNull
    private final EncryptionService encryptionService;

    @Autowired
    public AdminController(@NotNull JobScheduler jobScheduler, @NotNull ApplicationLogService applicationLogService, @NotNull HealthEndpoint healthEndpoint, @NotNull ConnectorGlobalStatusService connectorGlobalStatusService, @NotNull SecurityService securityService, @NotNull EncryptionService encryptionService) {
        Intrinsics.checkNotNullParameter((Object)jobScheduler, (String)"jobScheduler");
        Intrinsics.checkNotNullParameter((Object)applicationLogService, (String)"applicationLogService");
        Intrinsics.checkNotNullParameter((Object)healthEndpoint, (String)"healthEndpoint");
        Intrinsics.checkNotNullParameter((Object)connectorGlobalStatusService, (String)"connectorGlobalStatusService");
        Intrinsics.checkNotNullParameter((Object)securityService, (String)"securityService");
        Intrinsics.checkNotNullParameter((Object)encryptionService, (String)"encryptionService");
        this.jobScheduler = jobScheduler;
        this.applicationLogService = applicationLogService;
        this.healthEndpoint = healthEndpoint;
        this.connectorGlobalStatusService = connectorGlobalStatusService;
        this.securityService = securityService;
        this.encryptionService = encryptionService;
    }

    @GetMapping(value={"status"})
    @NotNull
    public Resource<AdminStatus> getStatus() {
        this.securityService.checkGlobalFunction(ApplicationManagement.class);
        HealthComponent healthComponent = this.healthEndpoint.health();
        Intrinsics.checkNotNullExpressionValue((Object)healthComponent, (String)"healthEndpoint.health()");
        Resource resource = Resource.of((Object)new AdminStatus(healthComponent, this.connectorGlobalStatusService.getGlobalStatus()), (URI)this.uri((Object)((AdminController)MvcUriComponentsBuilder.on(this.getClass())).getStatus()));
        Intrinsics.checkNotNullExpressionValue((Object)resource, (String)"of(\n                Admi\u2026s).getStatus())\n        )");
        return resource;
    }

    @GetMapping(value={"logs"})
    @NotNull
    public Resources<ApplicationLogEntry> getLogEntries(@NotNull ApplicationLogEntryFilter filter, @NotNull Page page) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        List entries = this.applicationLogService.getLogEntries(filter, page);
        Resources resources = Resources.of((Collection)entries, (URI)this.uri((Object)((AdminController)MvcUriComponentsBuilder.on(this.getClass())).getLogEntries(filter, page)));
        int offset = page.getOffset();
        int count = page.getCount();
        int actualCount = entries.size();
        int total = this.applicationLogService.getLogEntriesTotal();
        Pagination pagination2 = Pagination.Companion.of(offset, actualCount, total);
        if (offset > 0) {
            pagination2 = pagination2.withPrev(this.uri((Object)((AdminController)MvcUriComponentsBuilder.on(AdminController.class)).getLogEntries(filter, new Page(Math.max(0, offset - count), count))));
        }
        if (offset + count < total) {
            pagination2 = pagination2.withNext(this.uri((Object)((AdminController)MvcUriComponentsBuilder.on(AdminController.class)).getLogEntries(filter, new Page(offset + count, count))));
        }
        Resources resources2 = resources.withPagination(pagination2);
        Intrinsics.checkNotNullExpressionValue((Object)resources2, (String)"resources.withPagination(pagination)");
        return resources2;
    }

    @DeleteMapping(value={"logs"})
    @NotNull
    public Ack deleteLogEntries() {
        this.applicationLogService.deleteLogEntries();
        Ack ack = Ack.OK;
        Intrinsics.checkNotNullExpressionValue((Object)ack, (String)"OK");
        return ack;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"jobs/filter"})
    @NotNull
    public JobFilterResources getJobFilter() {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Collection collection2 = this.jobScheduler.getAllJobKeys();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"jobScheduler.allJobKeys");
        Iterable $this$map$iv = collection2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            JobKey jobKey = (JobKey)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getType());
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        Iterable list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            JobType it = (JobType)e$iv;
            boolean bl = false;
            String key$iv = it.getKey();
            if (!set$iv.add(key$iv)) continue;
            ((ArrayList)list$iv).add(e$iv);
        }
        List types = (List)list$iv;
        Iterable $this$map$iv2 = types;
        boolean $i$f$map2 = false;
        list$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JobType bl = (JobType)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getCategory());
        }
        Iterable $this$distinctBy$iv2 = (List)destination$iv$iv2;
        boolean $i$f$distinctBy2 = false;
        Iterable<String> set$iv2 = new HashSet();
        ArrayList list$iv2 = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv2) {
            JobCategory it = (JobCategory)e$iv;
            boolean bl = false;
            String key$iv = it.getKey();
            if (!((HashSet)set$iv2).add(key$iv)) continue;
            list$iv2.add(e$iv);
        }
        $this$map$iv2 = list$iv2;
        $i$f$map2 = false;
        set$iv2 = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JobCategory bl = (JobCategory)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add(new NameDescription(it.getKey(), it.getName()));
        }
        List categories = (List)destination$iv$iv2;
        Object $this$groupBy$iv = types;
        boolean $i$f$groupBy = false;
        destination$iv$iv2 = $this$groupBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            JobType it = (JobType)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getCategory().getKey();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv3;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map indexedTypes = destination$iv$iv3;
        $this$groupBy$iv = indexedTypes;
        List list = categories;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv3;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv3;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl5 = false;
            List typeList = (List)entry.getValue();
            Iterable $this$map$iv3 = typeList;
            boolean $i$f$map3 = false;
            Iterable iterable2 = $this$map$iv3;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                JobType jobType = (JobType)item$iv$iv;
                Collection collection3 = destination$iv$iv4;
                boolean bl6 = false;
                collection3.add(new NameDescription(it.getKey(), it.getName()));
            }
            List list2 = (List)destination$iv$iv4;
            map2.put(k, list2);
        }
        Map map = destination$iv$iv3;
        List list3 = list;
        return new JobFilterResources(list3, map);
    }

    @GetMapping(value={"jobs"})
    @NotNull
    public Resources<JobStatus> getJobs(@Valid @Nullable JobFilter jobFilter, @Nullable Page page) {
        this.securityService.checkGlobalFunction(ApplicationManagement.class);
        JobFilter jobFilter2 = jobFilter;
        if (jobFilter2 == null) {
            jobFilter2 = new JobFilter(null, null, null, null, null, null, 63, null);
        }
        Collection collection = this.jobScheduler.getJobStatuses();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"jobScheduler.jobStatuses");
        List jobs = jobFilter2.filter(collection);
        Page page2 = page;
        if (page2 == null) {
            page2 = new Page(0, 0, 3, null);
        }
        PaginatedList pagination2 = Pagination.Companion.paginate(jobs, page2, (Function2)new /* Unavailable Anonymous Inner Class!! */);
        LinkContainer linkContainer = ((Resources)Resources.of((Collection)pagination2.getItems(), (URI)this.uri((Object)((AdminController)MvcUriComponentsBuilder.on(this.getClass())).getJobs(jobFilter, page))).withPagination(pagination2.getPagination()).with("_pause", this.uri((Object)((AdminController)MvcUriComponentsBuilder.on(this.getClass())).pauseAllJobs()), !this.jobScheduler.isPaused())).with("_resume", this.uri((Object)((AdminController)MvcUriComponentsBuilder.on(this.getClass())).resumeAllJobs()), this.jobScheduler.isPaused());
        Intrinsics.checkNotNullExpressionValue((Object)linkContainer, (String)"of(\n                pagi\u2026sPaused\n                )");
        return (Resources)linkContainer;
    }

    @PostMapping(value={"jobs/{id:\\d+}"})
    @NotNull
    public Ack launchJob(@PathVariable long id) {
        this.securityService.checkGlobalFunction(ApplicationManagement.class);
        Ack ack = this.jobScheduler.getJobKey(id).map(arg_0 -> AdminController.launchJob$lambda-8(this, arg_0)).orElse(Ack.NOK);
        Intrinsics.checkNotNullExpressionValue((Object)ack, (String)"jobScheduler.getJobKey(i\u2026         .orElse(Ack.NOK)");
        return ack;
    }

    @PutMapping(value={"jobs/pause"})
    @NotNull
    public Ack pauseAllJobs() {
        this.securityService.checkGlobalFunction(ApplicationManagement.class);
        this.jobScheduler.pause();
        Ack ack = Ack.OK;
        Intrinsics.checkNotNullExpressionValue((Object)ack, (String)"OK");
        return ack;
    }

    @PutMapping(value={"jobs/resume"})
    @NotNull
    public Ack resumeAllJobs() {
        this.securityService.checkGlobalFunction(ApplicationManagement.class);
        this.jobScheduler.resume();
        Ack ack = Ack.OK;
        Intrinsics.checkNotNullExpressionValue((Object)ack, (String)"OK");
        return ack;
    }

    @PostMapping(value={"jobs/{id:\\d+}/pause"})
    @NotNull
    public Ack pauseJob(@PathVariable long id) {
        this.securityService.checkGlobalFunction(ApplicationManagement.class);
        Ack ack = this.jobScheduler.getJobKey(id).map(arg_0 -> AdminController.pauseJob$lambda-9(this, arg_0)).orElse(Ack.NOK);
        Intrinsics.checkNotNullExpressionValue((Object)ack, (String)"jobScheduler.getJobKey(i\u2026         .orElse(Ack.NOK)");
        return ack;
    }

    @PostMapping(value={"jobs/{id:\\d+}/resume"})
    @NotNull
    public Ack resumeJob(@PathVariable long id) {
        this.securityService.checkGlobalFunction(ApplicationManagement.class);
        Ack ack = this.jobScheduler.getJobKey(id).map(arg_0 -> AdminController.resumeJob$lambda-10(this, arg_0)).orElse(Ack.NOK);
        Intrinsics.checkNotNullExpressionValue((Object)ack, (String)"jobScheduler.getJobKey(i\u2026         .orElse(Ack.NOK)");
        return ack;
    }

    @DeleteMapping(value={"jobs/{id:\\d+}"})
    @NotNull
    public Ack deleteJob(@PathVariable long id) {
        this.securityService.checkGlobalFunction(ApplicationManagement.class);
        Ack ack = this.jobScheduler.getJobKey(id).filter(arg_0 -> AdminController.deleteJob$lambda-11(this, arg_0)).map(arg_0 -> AdminController.deleteJob$lambda-12(this, arg_0)).orElse(Ack.NOK);
        Intrinsics.checkNotNullExpressionValue((Object)ack, (String)"jobScheduler.getJobKey(i\u2026         .orElse(Ack.NOK)");
        return ack;
    }

    @DeleteMapping(value={"jobs/{id:\\d+}/stop"})
    @NotNull
    public Ack stopJob(@PathVariable long id) {
        this.securityService.checkGlobalFunction(ApplicationManagement.class);
        Ack ack = this.jobScheduler.getJobKey(id).map(arg_0 -> AdminController.stopJob$lambda-13(this, arg_0)).orElse(Ack.NOK);
        Intrinsics.checkNotNullExpressionValue((Object)ack, (String)"jobScheduler.getJobKey(i\u2026         .orElse(Ack.NOK)");
        return ack;
    }

    @GetMapping(value={"/encryption"})
    @NotNull
    public ResponseEntity<String> exportEncryptionKey() {
        ResponseEntity responseEntity;
        ResponseEntity responseEntity2;
        ResponseEntity responseEntity3;
        String string = this.encryptionService.exportKey();
        if (string != null) {
            String it = string;
            boolean bl = false;
            responseEntity3 = ResponseEntity.ok((Object)it);
        } else {
            responseEntity3 = responseEntity2 = null;
        }
        if (responseEntity2 == null) {
            ResponseEntity responseEntity4 = ResponseEntity.notFound().build();
            responseEntity = responseEntity4;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity4, (String)"notFound().build()");
        } else {
            responseEntity = responseEntity2;
        }
        return responseEntity;
    }

    @PutMapping(value={"/encryption"})
    @NotNull
    public HttpEntity<String> importEncryptionKey(@RequestBody @NotNull String payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        this.encryptionService.importKey(payload);
        ResponseEntity responseEntity = ResponseEntity.accepted().body((Object)payload);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"accepted().body(payload)");
        return (HttpEntity)responseEntity;
    }

    private static final Ack launchJob$lambda-8(AdminController this$0, JobKey key) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return Ack.validate((this$0.jobScheduler.fireImmediately(key) != null ? 1 : 0) != 0);
    }

    private static final Ack pauseJob$lambda-9(AdminController this$0, JobKey key) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return Ack.validate((boolean)this$0.jobScheduler.pause(key));
    }

    private static final Ack resumeJob$lambda-10(AdminController this$0, JobKey key) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return Ack.validate((boolean)this$0.jobScheduler.resume(key));
    }

    private static final boolean deleteJob$lambda-11(AdminController this$0, JobKey key) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return !((JobStatus)this$0.jobScheduler.getJobStatus(key).get()).isValid();
    }

    private static final Ack deleteJob$lambda-12(AdminController this$0, JobKey key) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return Ack.validate((boolean)this$0.jobScheduler.unschedule(key));
    }

    private static final Ack stopJob$lambda-13(AdminController this$0, JobKey key) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return Ack.validate((boolean)this$0.jobScheduler.stop(key));
    }

    public static final /* synthetic */ URI access$uri(AdminController $this, Object p0) {
        return $this.uri(p0);
    }
}

