/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import javax.validation.Valid;
import net.nemerosa.ontrack.common.Time;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.form.DateTime;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Selection;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.PromotionLevel;
import net.nemerosa.ontrack.model.structure.PromotionRun;
import net.nemerosa.ontrack.model.structure.PromotionRunRequest;
import net.nemerosa.ontrack.model.structure.PropertyCreationRequest;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.ui.controller.AbstractResourceController;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/rest/structure"})
public class PromotionRunController
extends AbstractResourceController {
    private final StructureService structureService;
    private final PropertyService propertyService;
    private final SecurityService securityService;

    @Autowired
    public PromotionRunController(StructureService structureService, PropertyService propertyService, SecurityService securityService) {
        this.structureService = structureService;
        this.propertyService = propertyService;
        this.securityService = securityService;
    }

    @RequestMapping(value={"builds/{buildId}/promotionRun"}, method={RequestMethod.GET})
    public Resources<PromotionRun> getPromotionRuns(@PathVariable ID buildId) {
        return Resources.of((Collection)this.structureService.getPromotionRunsForBuild(buildId), (URI)this.uri((Object)((PromotionRunController)MvcUriComponentsBuilder.on(this.getClass())).getPromotionRuns(buildId))).forView(Build.class);
    }

    @RequestMapping(value={"builds/{buildId}/promotionRun/last"}, method={RequestMethod.GET})
    public Resources<PromotionRun> getLastPromotionRuns(@PathVariable ID buildId) {
        return Resources.of((Collection)this.structureService.getLastPromotionRunsForBuild(buildId), (URI)this.uri((Object)((PromotionRunController)MvcUriComponentsBuilder.on(this.getClass())).getLastPromotionRuns(buildId))).forView(Build.class);
    }

    @RequestMapping(value={"builds/{buildId}/promotionRun/{promotionLevelId}"}, method={RequestMethod.GET})
    public Resources<PromotionRun> getPromotionRunsForBuildAndPromotionLevel(@PathVariable ID buildId, @PathVariable ID promotionLevelId) {
        return Resources.of((Collection)this.structureService.getPromotionRunsForBuildAndPromotionLevel(this.structureService.getBuild(buildId), this.structureService.getPromotionLevel(promotionLevelId)), (URI)this.uri((Object)((PromotionRunController)MvcUriComponentsBuilder.on(this.getClass())).getPromotionRunsForBuildAndPromotionLevel(buildId, promotionLevelId))).forView(Build.class);
    }

    @RequestMapping(value={"builds/{buildId}/promotionRun/create"}, method={RequestMethod.GET})
    public Form newPromotionRunForm(@PathVariable ID buildId) {
        Build build = this.structureService.getBuild(buildId);
        return Form.create().with((Field)((Selection)Selection.of((String)"promotionLevelId").label("Promotion level")).items(this.structureService.getPromotionLevelListForBranch(build.getBranch().getId()))).with((Field)((DateTime)((DateTime)DateTime.of((String)"dateTime").label("Date/time")).value((Object)Time.now())).minuteStep(15)).description();
    }

    @RequestMapping(value={"builds/{buildId}/promotionRun/create"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public PromotionRun newPromotionRun(@PathVariable ID buildId, @RequestBody @Valid PromotionRunRequest promotionRunRequest) {
        Build build = this.structureService.getBuild(buildId);
        PromotionLevel promotionLevel = this.getPromotionLevel(build.getBranch(), promotionRunRequest.getPromotionLevelId(), promotionRunRequest.getPromotionLevelName());
        PromotionRun promotionRun = PromotionRun.of((Build)build, (PromotionLevel)promotionLevel, (Signature)this.securityService.getCurrentSignature().withTime(promotionRunRequest.getDateTime()), (String)Objects.toString(promotionRunRequest.getDescription(), ""));
        promotionRun = this.structureService.newPromotionRun(promotionRun);
        for (PropertyCreationRequest propertyCreationRequest : promotionRunRequest.getProperties()) {
            this.propertyService.editProperty((ProjectEntity)promotionRun, propertyCreationRequest.getPropertyTypeName(), propertyCreationRequest.getPropertyData());
        }
        return promotionRun;
    }

    @RequestMapping(value={"promotionRuns/{promotionRunId}"}, method={RequestMethod.GET})
    public PromotionRun getPromotionRun(@PathVariable ID promotionRunId) {
        return this.structureService.getPromotionRun(promotionRunId);
    }

    @RequestMapping(value={"promotionRuns/{promotionRunId}"}, method={RequestMethod.DELETE})
    public Ack deletePromotionRun(@PathVariable ID promotionRunId) {
        return this.structureService.deletePromotionRun(promotionRunId);
    }

    protected PromotionLevel getPromotionLevel(Branch branch, Integer promotionLevelId, String promotionLevelName) {
        return this.structureService.getOrCreatePromotionLevel(branch, promotionLevelId, promotionLevelName);
    }
}

