/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.boot.ui;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.nemerosa.ontrack.boot.ui.AbstractProjectEntityController;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.Property;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.ui.resource.Resource;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"/rest/properties"})
public class PropertyController
extends AbstractProjectEntityController {
    private final PropertyService propertyService;

    @Autowired
    public PropertyController(PropertyService propertyService, StructureService structureService) {
        super(structureService);
        this.propertyService = propertyService;
    }

    @RequestMapping(value={"{entityType}/{id}"}, method={RequestMethod.GET})
    public Resources<Resource<Property<?>>> getProperties(@PathVariable ProjectEntityType entityType, @PathVariable ID id) {
        ProjectEntity entity = this.getEntity(entityType, id);
        List properties = this.propertyService.getProperties(entity);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Property property : properties) {
            Resource resource = Resource.of((Object)property, (URI)this.uri((Object)((PropertyController)MvcUriComponentsBuilder.on(this.getClass())).getPropertyValue(entity.getProjectEntityType(), entity.getId(), property.getType().getClass().getName())));
            resource = (Resource)resource.with("_update", this.uri((Object)((PropertyController)MvcUriComponentsBuilder.on(this.getClass())).getPropertyEditionForm(entity.getProjectEntityType(), entity.getId(), property.getType().getClass().getName())));
            resources.add(resource);
        }
        return Resources.of(resources, (URI)this.uri((Object)((PropertyController)MvcUriComponentsBuilder.on(this.getClass())).getProperties(entityType, id)));
    }

    @RequestMapping(value={"{entityType}/{id}/{propertyTypeName}/view"}, method={RequestMethod.GET})
    public Resource<Property<?>> getPropertyValue(@PathVariable ProjectEntityType entityType, @PathVariable ID id, @PathVariable String propertyTypeName) {
        return Resource.of((Object)this.propertyService.getProperty(this.getEntity(entityType, id), propertyTypeName), (URI)this.uri((Object)((PropertyController)MvcUriComponentsBuilder.on(this.getClass())).getPropertyValue(entityType, id, propertyTypeName)));
    }

    @RequestMapping(value={"{entityType}/{id}/{propertyTypeName}/edit"}, method={RequestMethod.GET})
    public Form getPropertyEditionForm(@PathVariable ProjectEntityType entityType, @PathVariable ID id, @PathVariable String propertyTypeName) {
        return this.propertyService.getPropertyEditionForm(this.getEntity(entityType, id), propertyTypeName);
    }

    @RequestMapping(value={"{entityType}/{id}/{propertyTypeName}/edit"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public Ack editProperty(@PathVariable ProjectEntityType entityType, @PathVariable ID id, @PathVariable String propertyTypeName, @RequestBody JsonNode data) {
        return this.propertyService.editProperty(this.getEntity(entityType, id), propertyTypeName, data);
    }

    @RequestMapping(value={"{entityType}/{id}/{propertyTypeName}/edit"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public Ack deleteProperty(@PathVariable ProjectEntityType entityType, @PathVariable ID id, @PathVariable String propertyTypeName) {
        return this.propertyService.deleteProperty(this.getEntity(entityType, id), propertyTypeName);
    }
}

