/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.util;

import com.fasterxml.aalto.in.ReaderConfig;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.codehaus.stax2.ri.typed.CharArrayBase64Decoder;
import org.codehaus.stax2.typed.Base64Variant;
import org.codehaus.stax2.typed.TypedArrayDecoder;
import org.codehaus.stax2.typed.TypedXMLStreamException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class TextBuilder {
    static final char[] sNoChars = new char[0];
    static final int DEF_INITIAL_BUFFER_SIZE = 500;
    static final int MAX_SEGMENT_LENGTH = 262144;
    static final int INT_SPACE = 32;
    private final ReaderConfig _config;
    private ArrayList<char[]> _segments;
    private int _segmentSize;
    private char[] _currentSegment;
    private int _currentSize;
    private String _resultString;
    private char[] _resultArray;
    private int _resultLen;
    private char[] _decodeBuffer;
    private int _decodePtr;
    private int _decodeEnd;
    private boolean _isIndentation = false;
    public static final int MAX_INDENT_SPACES = 32;
    public static final int MAX_INDENT_TABS = 8;
    private static final String sIndSpaces = "\n                                 ";
    private static final char[] sIndSpacesArray = "\n                                 ".toCharArray();
    private static final String[] sIndSpacesStrings = new String[sIndSpacesArray.length];
    private static final String sIndTabs = "\n\t\t\t\t\t\t\t\t\t";
    private static final char[] sIndTabsArray = "\n\t\t\t\t\t\t\t\t\t".toCharArray();
    private static final String[] sIndTabsStrings = new String[sIndTabsArray.length];

    private TextBuilder(ReaderConfig cfg) {
        this._config = cfg;
    }

    public static TextBuilder createRecyclableBuffer(ReaderConfig cfg) {
        return new TextBuilder(cfg);
    }

    public void recycle(boolean force) {
        if (this._config != null && this._currentSegment != null) {
            if (force) {
                this._resultString = null;
                this._resultArray = null;
            } else if (this._segmentSize + this._currentSize > 0) {
                return;
            }
            if (this._segments != null && this._segments.size() > 0) {
                this._segments.clear();
                this._segmentSize = 0;
            }
            char[] buf = this._currentSegment;
            this._currentSegment = null;
            this._config.freeMediumCBuffer(buf);
        }
    }

    public char[] resetWithEmpty() {
        this._resultString = null;
        this._resultArray = null;
        this._isIndentation = false;
        if (this._segments != null && this._segments.size() > 0) {
            this._segments.clear();
            this._segmentSize = 0;
        }
        this._currentSize = 0;
        if (this._currentSegment == null) {
            this._currentSegment = this.allocBuffer(0);
        }
        return this._currentSegment;
    }

    public void resetWithIndentation(int indCharCount, char indChar) {
        String text2;
        int strlen;
        if (this._segments != null && this._segments.size() > 0) {
            this._segments.clear();
            this._segmentSize = 0;
        }
        this._currentSize = -1;
        this._isIndentation = true;
        this._resultLen = strlen = indCharCount + 1;
        if (indChar == '\t') {
            this._resultArray = sIndTabsArray;
            text2 = sIndTabsStrings[indCharCount];
            if (text2 == null) {
                TextBuilder.sIndTabsStrings[indCharCount] = text2 = sIndTabs.substring(0, strlen);
            }
        } else {
            this._resultArray = sIndSpacesArray;
            text2 = sIndSpacesStrings[indCharCount];
            if (text2 == null) {
                TextBuilder.sIndSpacesStrings[indCharCount] = text2 = sIndSpaces.substring(0, strlen);
            }
        }
        this._resultString = text2;
    }

    public void resetWithChar(char c) {
        this._resultString = null;
        this._resultArray = null;
        this._isIndentation = false;
        if (this._segments != null && this._segments.size() > 0) {
            this._segments.clear();
            this._segmentSize = 0;
        }
        this._currentSize = 1;
        if (this._currentSegment == null) {
            this._currentSegment = this.allocBuffer(1);
        }
        this._currentSegment[0] = c;
    }

    public void resetWithSurrogate(int c) {
        this._resultString = null;
        this._resultArray = null;
        this._isIndentation = false;
        if (this._segments != null && this._segments.size() > 0) {
            this._segments.clear();
            this._segmentSize = 0;
        }
        this._currentSize = 2;
        if (this._currentSegment == null) {
            this._currentSegment = this.allocBuffer(2);
        }
        this._currentSegment[0] = (char)(0xD800 | c >> 10);
        this._currentSegment[1] = (char)(0xDC00 | c & 0x3FF);
    }

    public char[] getBufferWithoutReset() {
        return this._currentSegment;
    }

    public int size() {
        int size = this._currentSize;
        if (size < 0) {
            return this._resultLen;
        }
        return size + this._segmentSize;
    }

    public char[] getTextBuffer() {
        if (this._segments == null || this._segments.size() == 0) {
            if (this._resultArray != null) {
                return this._resultArray;
            }
            return this._currentSegment;
        }
        return this.contentsAsArray();
    }

    public String contentsAsString() {
        if (this._resultString == null) {
            if (this._resultArray != null) {
                this._resultString = new String(this._resultArray);
            } else {
                int segLen = this._segmentSize;
                int currLen = this._currentSize;
                if (segLen == 0) {
                    this._resultString = currLen == 0 ? "" : new String(this._currentSegment, 0, currLen);
                    return this._resultString;
                }
                StringBuilder sb = new StringBuilder(segLen + currLen);
                if (this._segments != null) {
                    int len = this._segments.size();
                    for (int i = 0; i < len; ++i) {
                        char[] curr = this._segments.get(i);
                        sb.append(curr, 0, curr.length);
                    }
                }
                sb.append(this._currentSegment, 0, currLen);
                this._resultString = sb.toString();
            }
        }
        return this._resultString;
    }

    public char[] contentsAsArray() {
        char[] result2 = this._resultArray;
        if (result2 == null) {
            this._resultArray = result2 = this.buildResultArray();
        }
        return result2;
    }

    public int contentsToArray(int srcStart, char[] dst, int dstStart, int len) {
        int totalAmount = 0;
        if (this._segments != null) {
            int segc = this._segments.size();
            for (int i = 0; i < segc; ++i) {
                char[] segment = this._segments.get(i);
                int segLen = segment.length;
                int amount = segLen - srcStart;
                if (amount < 1) {
                    srcStart -= segLen;
                    continue;
                }
                if (amount >= len) {
                    System.arraycopy(segment, srcStart, dst, dstStart, len);
                    return totalAmount + len;
                }
                System.arraycopy(segment, srcStart, dst, dstStart, amount);
                totalAmount += amount;
                dstStart += amount;
                len -= amount;
                srcStart = 0;
            }
        }
        if (len > 0) {
            int maxAmount = this._currentSize - srcStart;
            if (len > maxAmount) {
                len = maxAmount;
            }
            if (len > 0) {
                System.arraycopy(this._currentSegment, srcStart, dst, dstStart, len);
                totalAmount += len;
            }
        }
        return totalAmount;
    }

    public int rawContentsTo(Writer w) throws IOException {
        if (this._resultArray != null) {
            w.write(this._resultArray);
            return this._resultArray.length;
        }
        if (this._resultString != null) {
            w.write(this._resultString);
            return this._resultString.length();
        }
        int rlen = 0;
        if (this._segments != null) {
            int len = this._segments.size();
            for (int i = 0; i < len; ++i) {
                char[] ch = this._segments.get(i);
                w.write(ch);
                rlen += ch.length;
            }
        }
        if (this._currentSize > 0) {
            w.write(this._currentSegment, 0, this._currentSize);
            rlen += this._currentSize;
        }
        return rlen;
    }

    public boolean isAllWhitespace() {
        if (this._isIndentation) {
            return true;
        }
        if (this._segments != null) {
            int len = this._segments.size();
            for (int i = 0; i < len; ++i) {
                char[] buf = this._segments.get(i);
                int len2 = buf.length;
                for (int j = 0; j < len2; ++j) {
                    if (buf[j] <= ' ') continue;
                    return false;
                }
            }
        }
        char[] buf = this._currentSegment;
        int len = this._currentSize;
        for (int i = 0; i < len; ++i) {
            if (buf[i] <= ' ') continue;
            return false;
        }
        return true;
    }

    public boolean equalsString(String str) {
        int expLen = str.length();
        if (expLen != this.size()) {
            return false;
        }
        char[] seg = this._segments == null || this._segments.size() == 0 ? this._currentSegment : this.contentsAsArray();
        for (int i = 0; i < expLen; ++i) {
            if (seg[i] == str.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public void fireSaxCharacterEvents(ContentHandler h2) throws SAXException {
        if (this._resultArray != null) {
            h2.characters(this._resultArray, 0, this._resultLen);
        } else {
            if (this._segments != null) {
                int len = this._segments.size();
                for (int i = 0; i < len; ++i) {
                    char[] ch = this._segments.get(i);
                    h2.characters(ch, 0, ch.length);
                }
            }
            if (this._currentSize > 0) {
                h2.characters(this._currentSegment, 0, this._currentSize);
            }
        }
    }

    public void fireSaxSpaceEvents(ContentHandler h2) throws SAXException {
        if (this._resultArray != null) {
            h2.ignorableWhitespace(this._resultArray, 0, this._resultLen);
        } else {
            if (this._segments != null) {
                int len = this._segments.size();
                for (int i = 0; i < len; ++i) {
                    char[] ch = this._segments.get(i);
                    h2.ignorableWhitespace(ch, 0, ch.length);
                }
            }
            if (this._currentSize > 0) {
                h2.ignorableWhitespace(this._currentSegment, 0, this._currentSize);
            }
        }
    }

    public void fireSaxCommentEvent(LexicalHandler h2) throws SAXException {
        if (this._resultArray != null) {
            h2.comment(this._resultArray, 0, this._resultLen);
        } else if (this._segments != null && this._segments.size() > 0) {
            char[] ch = this.contentsAsArray();
            h2.comment(ch, 0, ch.length);
        } else {
            h2.comment(this._currentSegment, 0, this._currentSize);
        }
    }

    public void append(char c) {
        this._resultString = null;
        this._resultArray = null;
        char[] curr = this._currentSegment;
        if (this._currentSize >= curr.length) {
            this.expand(1);
        }
        curr[this._currentSize++] = c;
    }

    public void appendSurrogate(int surr) {
        this.append((char)(0xD800 | surr >> 10));
        this.append((char)(0xDC00 | surr & 0x3FF));
    }

    public void append(char[] c, int start, int len) {
        this._resultString = null;
        this._resultArray = null;
        char[] curr = this._currentSegment;
        int max = curr.length - this._currentSize;
        if (max >= len) {
            System.arraycopy(c, start, curr, this._currentSize, len);
            this._currentSize += len;
        } else {
            if (max > 0) {
                System.arraycopy(c, start, curr, this._currentSize, max);
                start += max;
                len -= max;
            }
            this.expand(len);
            System.arraycopy(c, start, this._currentSegment, 0, len);
            this._currentSize = len;
        }
    }

    public void append(String str) {
        this._resultString = null;
        this._resultArray = null;
        char[] curr = this._currentSegment;
        int max = curr.length - this._currentSize;
        int len = str.length();
        if (max >= len) {
            str.getChars(0, len, curr, this._currentSize);
            this._currentSize += len;
        } else {
            if (max > 0) {
                str.getChars(0, max, curr, this._currentSize);
                len -= max;
            }
            this.expand(len);
            str.getChars(max, max + len, this._currentSegment, 0);
            this._currentSize = len;
        }
    }

    public int getCurrentLength() {
        return this._currentSize;
    }

    public void setCurrentLength(int len) {
        this._currentSize = len;
    }

    public char[] finishCurrentSegment() {
        if (this._segments == null) {
            this._segments = new ArrayList();
        }
        this._segments.add(this._currentSegment);
        int oldLen = this._currentSegment.length;
        this._segmentSize += oldLen;
        char[] curr = new char[this.calcNewSize(oldLen)];
        this._currentSize = 0;
        this._currentSegment = curr;
        return curr;
    }

    private int calcNewSize(int latestSize) {
        int incr = latestSize < 8000 ? latestSize : latestSize >> 1;
        int size = latestSize + incr;
        return Math.min(size, 262144);
    }

    public int decodeElements(TypedArrayDecoder tad, boolean reset) throws TypedXMLStreamException {
        if (reset) {
            this.resetForDecode();
        }
        int ptr = this._decodePtr;
        char[] buf = this._decodeBuffer;
        int count2 = 0;
        int start = ptr;
        try {
            int end = this._decodeEnd;
            block2: while (ptr < end) {
                int tokenEnd;
                while (buf[ptr] <= ' ') {
                    if (++ptr < end) continue;
                    break block2;
                }
                start = ptr++;
                while (ptr < end && buf[ptr] > ' ') {
                    ++ptr;
                }
                ++count2;
                if (tad.decodeValue(buf, start, tokenEnd = ptr++)) break;
                this._decodePtr = ptr;
            }
            this._decodePtr = ptr;
        }
        catch (IllegalArgumentException iae) {
            String lexical = new String(buf, start, ptr - start - 1);
            throw new TypedXMLStreamException(lexical, iae.getMessage(), iae);
        }
        return count2;
    }

    public void resetForBinaryDecode(Base64Variant v, CharArrayBase64Decoder dec, boolean firstChunk) {
        if ((this._segments == null || this._segments.size() == 0) && this._isIndentation) {
            dec.init(v, firstChunk, this._resultArray, 0, this._resultArray.length, null);
            return;
        }
        dec.init(v, firstChunk, this._currentSegment, 0, this._currentSize, this._segments);
    }

    private final void resetForDecode() {
        this._decodePtr = 0;
        if (this._segments == null || this._segments.size() == 0) {
            if (this._isIndentation) {
                this._decodeBuffer = this._resultArray;
                this._decodeEnd = this._resultArray.length;
            } else {
                this._decodeBuffer = this._currentSegment;
                this._decodeEnd = this._currentSize;
            }
        } else {
            this._decodeBuffer = this.contentsAsArray();
            this._decodeEnd = this._decodeBuffer.length;
        }
    }

    public String toString() {
        this._resultString = null;
        this._resultArray = null;
        return this.contentsAsString();
    }

    private final char[] allocBuffer(int minNeeded) {
        int size = Math.max(500, minNeeded);
        char[] buf = null;
        if (this._config != null && (buf = this._config.allocMediumCBuffer(size)) != null) {
            return buf;
        }
        return new char[size];
    }

    private void expand(int roomNeeded) {
        if (this._segments == null) {
            this._segments = new ArrayList();
        }
        char[] curr = this._currentSegment;
        this._segments.add(curr);
        int oldLen = curr.length;
        this._segmentSize += oldLen;
        int newSize = Math.max(roomNeeded, this.calcNewSize(oldLen));
        curr = new char[newSize];
        this._currentSize = 0;
        this._currentSegment = curr;
    }

    private char[] buildResultArray() {
        if (this._resultString != null) {
            return this._resultString.toCharArray();
        }
        int size = this.size();
        if (size < 1) {
            return sNoChars;
        }
        int offset = 0;
        char[] result2 = new char[size];
        if (this._segments != null) {
            int len = this._segments.size();
            for (int i = 0; i < len; ++i) {
                char[] curr = this._segments.get(i);
                int currLen = curr.length;
                System.arraycopy(curr, 0, result2, offset, currLen);
                offset += currLen;
            }
        }
        System.arraycopy(this._currentSegment, 0, result2, offset, this._currentSize);
        return result2;
    }
}

