/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ReflectionUtil;
import java.util.Arrays;
import java.util.function.IntUnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeInsightUtilCore
extends FileModificationService {
    private static final Logger LOG = Logger.getInstance(CodeInsightUtilCore.class);

    public static <T extends PsiElement> T findElementInRange(@NotNull PsiFile file2, int startOffset, int endOffset, @NotNull Class<T> klass, @NotNull Language language) {
        if (file2 == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(0);
        }
        if (klass == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(1);
        }
        if (language == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(2);
        }
        return CodeInsightUtilCore.findElementInRange(file2, startOffset, endOffset, klass, language, null);
    }

    @Nullable
    private static <T extends PsiElement> T findElementInRange(@NotNull PsiFile file2, int startOffset, int endOffset, @NotNull Class<T> klass, @NotNull Language language, @Nullable PsiElement initialElement) {
        PsiElement element;
        if (file2 == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(3);
        }
        if (klass == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(4);
        }
        if (language == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(5);
        }
        PsiElement element1 = file2.getViewProvider().findElementAt(startOffset, language);
        PsiElement element2 = file2.getViewProvider().findElementAt(endOffset - 1, language);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file2.getViewProvider().findElementAt(startOffset, language);
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file2.getViewProvider().findElementAt(endOffset - 1, language);
        }
        if (element2 == null || element1 == null) {
            return null;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent(element1, element2);
        PsiElement psiElement = element = ReflectionUtil.isAssignable(klass, commonParent.getClass()) ? commonParent : PsiTreeUtil.getParentOfType(commonParent, klass);
        if (element == initialElement) {
            return (T)element;
        }
        if (element == null || element.getTextRange().getStartOffset() != startOffset || element.getTextRange().getEndOffset() != endOffset) {
            return null;
        }
        return (T)element;
    }

    @Nullable
    public static <T extends PsiElement> T forcePsiPostprocessAndRestoreElement(@NotNull T element) {
        if (element == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(6);
        }
        return CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(element, false);
    }

    @Nullable
    public static <T extends PsiElement> T forcePsiPostprocessAndRestoreElement(@NotNull T element, boolean useFileLanguage) {
        if (element == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(7);
        }
        PsiFile psiFile = element.getContainingFile();
        Document document = psiFile.getViewProvider().getDocument();
        Language language = useFileLanguage ? psiFile.getLanguage() : PsiUtilCore.getDialect(element);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(psiFile.getProject());
        RangeMarker rangeMarker = document.createRangeMarker(element.getTextRange());
        documentManager.doPostponedOperationsAndUnblockDocument(document);
        documentManager.commitDocument(document);
        Object elementInRange = CodeInsightUtilCore.findElementInRange(psiFile, rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), element.getClass(), language, element);
        rangeMarker.dispose();
        return (T)elementInRange;
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder out, int @Nullable [] sourceOffsets) {
        if (chars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(8);
        }
        if (out == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(9);
        }
        return CodeInsightUtilCore.parseStringCharacters(chars, out, sourceOffsets, true);
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder out, int @Nullable [] sourceOffsets, boolean textBlock) {
        if (chars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(10);
        }
        if (out == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(11);
        }
        LOG.assertTrue(sourceOffsets == null || sourceOffsets.length == chars.length() + 1);
        if (CodeInsightUtilCore.noEscape(chars, sourceOffsets)) {
            out.append(chars);
            return true;
        }
        return CodeInsightUtilCore.parseStringCharactersWithEscape(chars, textBlock, out, sourceOffsets);
    }

    @Nullable
    public static CharSequence parseStringCharacters(@NotNull String chars, int @Nullable [] sourceOffsets) {
        if (chars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(12);
        }
        LOG.assertTrue(sourceOffsets == null || sourceOffsets.length == chars.length() + 1);
        if (CodeInsightUtilCore.noEscape(chars, sourceOffsets)) {
            return chars;
        }
        StringBuilder out = new StringBuilder(chars.length());
        return CodeInsightUtilCore.parseStringCharactersWithEscape(chars, true, out, sourceOffsets) ? out : null;
    }

    private static boolean noEscape(@NotNull String chars, int @Nullable [] sourceOffsets) {
        if (chars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(13);
        }
        if (chars.indexOf(92) >= 0) {
            return false;
        }
        if (sourceOffsets != null) {
            Arrays.setAll(sourceOffsets, IntUnaryOperator.identity());
        }
        return true;
    }

    static boolean parseStringCharactersWithEscape(@NotNull String chars, boolean textBlock, @NotNull StringBuilder out, int @Nullable [] sourceOffsets) {
        if (chars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(14);
        }
        if (out == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(15);
        }
        int index = 0;
        int outOffset = out.length();
        while (index < chars.length()) {
            char c = chars.charAt(index++);
            if (sourceOffsets != null) {
                sourceOffsets[out.length() - outOffset] = index - 1;
                sourceOffsets[out.length() + 1 - outOffset] = index;
            }
            if (c != '\\') {
                out.append(c);
                continue;
            }
            if ((index = CodeInsightUtilCore.parseEscapedSymbol(false, chars, index, textBlock, out)) == -1) {
                return false;
            }
            if (sourceOffsets == null) continue;
            sourceOffsets[out.length() - outOffset] = index;
        }
        return true;
    }

    private static int parseEscapedSymbol(boolean isAfterEscapedBackslash, @NotNull String chars, int index, boolean textBlock, @NotNull StringBuilder out) {
        char c;
        if (chars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(16);
        }
        if (out == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(17);
        }
        if (index == chars.length()) {
            return -1;
        }
        if (CodeInsightUtilCore.parseEscapedChar(c = chars.charAt(index++), textBlock, out)) {
            return index;
        }
        switch (c) {
            case '\\': {
                boolean isUnicodeSequenceStart;
                boolean bl = isUnicodeSequenceStart = isAfterEscapedBackslash && index < chars.length() && chars.charAt(index) == 'u';
                if (isUnicodeSequenceStart) {
                    index = CodeInsightUtilCore.parseUnicodeEscape(true, chars, index, textBlock, out);
                    break;
                }
                out.append('\\');
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                index = CodeInsightUtilCore.parseOctalEscape(c, chars, index, out);
                break;
            }
            case 'u': {
                if (isAfterEscapedBackslash) {
                    return -1;
                }
                index = CodeInsightUtilCore.parseUnicodeEscape(false, chars, index - 1, textBlock, out);
                break;
            }
            default: {
                return -1;
            }
        }
        return index;
    }

    private static int parseUnicodeEscape(boolean isAfterEscapedBackslash, @NotNull String s2, int index, boolean textBlock, @NotNull StringBuilder out) {
        if (s2 == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(18);
        }
        if (out == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(19);
        }
        int len = s2.length();
        while (++index < len && s2.charAt(index) == 'u') {
        }
        if (index + 4 > len) {
            return -1;
        }
        try {
            char c = s2.charAt(index);
            if (c == '+' || c == '-') {
                return -1;
            }
            int code = Integer.parseInt(s2.substring(index, index + 4), 16);
            if (!(textBlock || code != 10 && code != 13)) {
                return -1;
            }
            char escapedChar = (char)code;
            if (escapedChar == '\\') {
                if (isAfterEscapedBackslash) {
                    out.append('\\');
                    return index + 4;
                }
                return CodeInsightUtilCore.parseEscapedSymbol(true, s2, index + 4, textBlock, out);
            }
            if (isAfterEscapedBackslash) {
                if (CodeInsightUtilCore.parseEscapedChar(escapedChar, textBlock, out)) {
                    return index + 4;
                }
                return -1;
            }
            out.append(escapedChar);
            return index + 4;
        }
        catch (NumberFormatException ignored) {
            return -1;
        }
    }

    private static boolean parseEscapedChar(char c, boolean textBlock, @NotNull StringBuilder out) {
        if (out == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(20);
        }
        switch (c) {
            case 'b': {
                out.append('\b');
                return true;
            }
            case 't': {
                out.append('\t');
                return true;
            }
            case 'n': {
                out.append('\n');
                return true;
            }
            case 'f': {
                out.append('\f');
                return true;
            }
            case 'r': {
                out.append('\r');
                return true;
            }
            case 's': {
                out.append(' ');
                return true;
            }
            case '\'': {
                out.append('\'');
                return true;
            }
            case '\"': {
                out.append('\"');
                return true;
            }
            case '\n': {
                return textBlock;
            }
        }
        return false;
    }

    private static int parseOctalEscape(char c, @NotNull String s2, int index, @NotNull StringBuilder out) {
        if (s2 == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(21);
        }
        if (out == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(22);
        }
        char startC = c;
        int v = c - 48;
        if (index < s2.length()) {
            if ('0' <= (c = s2.charAt(index++)) && c <= '7') {
                v <<= 3;
                v += c - 48;
                if (startC <= '3' && index < s2.length()) {
                    if ('0' <= (c = s2.charAt(index++)) && c <= '7') {
                        v <<= 3;
                        v += c - 48;
                    } else {
                        --index;
                    }
                }
            } else {
                --index;
            }
        }
        out.append((char)v);
        return index;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/CodeInsightUtilCore";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementInRange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "forcePsiPostprocessAndRestoreElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "parseStringCharacters";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "noEscape";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "parseStringCharactersWithEscape";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "parseEscapedSymbol";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "parseUnicodeEscape";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "parseEscapedChar";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "parseOctalEscape";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

