/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.accesstransformers;

import com.intellij.lang.jvm.JvmClassKind;
import com.intellij.navigation.NavigationItem;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.ClassUtil;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.neoforged.accesstransformer.parser.AccessTransformerFiles;
import net.neoforged.accesstransformer.parser.Target;
import net.neoforged.accesstransformer.parser.Transformation;
import net.neoforged.jst.api.Logger;
import net.neoforged.jst.api.PsiHelper;
import net.neoforged.jst.api.Replacements;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ApplyATsVisitor
extends PsiRecursiveElementVisitor {
    private static final Set<String> ACCESS_MODIFIERS = Set.of("public", "private", "protected");
    private static final Set<String> MODIFIERS = Set.of(PsiModifier.MODIFIERS);
    public static final EnumMap<Transformation.Modifier, String> MODIFIER_TO_STRING = new EnumMap<Transformation.Modifier, String>(Map.of(Transformation.Modifier.PRIVATE, "private", Transformation.Modifier.PUBLIC, "public", Transformation.Modifier.PROTECTED, "protected"));
    public static final Map<String, Transformation.Modifier> STRING_TO_MODIFIER = MODIFIER_TO_STRING.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    private final AccessTransformerFiles ats;
    private final Replacements replacements;
    private final Map<Target, Transformation> pendingATs;
    private final Logger logger;
    boolean errored = false;

    public ApplyATsVisitor(AccessTransformerFiles ats, Replacements replacements, Map<Target, Transformation> pendingATs, Logger logger) {
        this.ats = ats;
        this.replacements = replacements;
        this.logger = logger;
        this.pendingATs = pendingATs;
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        PsiMethod method;
        PsiClass cls;
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            if (psiClass.getQualifiedName() != null) {
                Transformation methodWildcard;
                String className = ClassUtil.getJVMClassName(psiClass);
                if (!this.ats.containsClassTarget(className)) {
                    for (PsiClass innerClass : psiClass.getInnerClasses()) {
                        this.visitElement(innerClass);
                    }
                    return;
                }
                Transformation classAt = this.pendingATs.remove(new Target.ClassTarget(className));
                this.apply(classAt, psiClass, psiClass);
                PsiField[] psiFieldArray = psiClass.getParent();
                if (psiFieldArray instanceof PsiClass) {
                    PsiClass parent = (PsiClass)psiFieldArray;
                    this.pendingATs.remove(new Target.InnerClassTarget(ClassUtil.getJVMClassName(parent), className));
                }
                this.checkImplicitConstructor(psiClass, className, classAt);
                Transformation fieldWildcard = this.pendingATs.remove(new Target.WildcardFieldTarget(className));
                if (fieldWildcard != null) {
                    for (PsiField field : psiClass.getFields()) {
                        Transformation newState = ApplyATsVisitor.merge(fieldWildcard, this.pendingATs.remove(new Target.FieldTarget(className, field.getName())));
                        this.logger.debug("Applying field wildcard AT %s to %s in %s", newState, field.getName(), className);
                        this.apply(newState, field, psiClass);
                    }
                }
                if ((methodWildcard = this.pendingATs.remove(new Target.WildcardMethodTarget(className))) != null) {
                    for (PsiMethod method2 : psiClass.getMethods()) {
                        Transformation newState = ApplyATsVisitor.merge(methodWildcard, this.pendingATs.remove(ApplyATsVisitor.method(className, method2)));
                        this.logger.debug("Applying method wildcard AT %s to %s in %s", newState, method2.getName(), className);
                        this.apply(newState, method2, psiClass);
                    }
                }
            }
        } else if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            PsiClass cls2 = field.getContainingClass();
            if (cls2 != null && cls2.getQualifiedName() != null) {
                String className = ClassUtil.getJVMClassName(cls2);
                this.apply(this.pendingATs.remove(new Target.FieldTarget(className, field.getName())), field, cls2);
            }
        } else if (element instanceof PsiMethod && (cls = (method = (PsiMethod)element).getContainingClass()) != null && cls.getQualifiedName() != null) {
            String className = ClassUtil.getJVMClassName(cls);
            this.apply(this.pendingATs.remove(ApplyATsVisitor.method(className, method)), method, cls);
        }
        element.acceptChildren(this);
    }

    private void apply(@Nullable Transformation at, final PsiModifierListOwner owner, final PsiClass containingClass) {
        PsiMethod mtd;
        if (at == null) {
            return;
        }
        if (!at.isValid()) {
            this.error("Found invalid access transformer: %s. Final state: conflicting", at);
            return;
        }
        Object targetInfo = new Object(){

            public String toString() {
                PsiMethod mtd;
                if (owner instanceof PsiClass) {
                    PsiClass cls = (PsiClass)owner;
                    return ClassUtil.getJVMClassName(cls);
                }
                String memberName = owner instanceof PsiMethod && (mtd = (PsiMethod)owner).isConstructor() ? "constructor" : ((NavigationItem)((Object)owner)).getName();
                return memberName + " of " + ClassUtil.getJVMClassName(containingClass);
            }
        };
        this.logger.debug("Applying AT %s to %s", at, targetInfo);
        PsiModifierList modifiers = owner.getModifierList();
        Transformation.Modifier targetAcc = at.modifier();
        if (containingClass.isInterface() && owner instanceof PsiMethod && !modifiers.hasModifierProperty("static")) {
            if (targetAcc != Transformation.Modifier.PUBLIC) {
                this.error("Access transformer %s targeting %s attempted to make a non-static interface method %s. They can only be made public.", new Object[]{at, targetInfo, targetAcc});
            } else {
                for (PsiElement kw2 : modifiers.getChildren()) {
                    if (!(kw2 instanceof PsiKeyword) || !kw2.getText().equals("private")) continue;
                    this.replacements.replace(kw2, "default");
                    break;
                }
            }
        } else if (containingClass.isEnum() && owner instanceof PsiMethod && (mtd = (PsiMethod)owner).isConstructor() && at.modifier().ordinal() < Transformation.Modifier.DEFAULT.ordinal()) {
            this.error("Access transformer %s targeting %s attempted to make an enum constructor %s", new Object[]{at, targetInfo, at.modifier()});
        } else if (targetAcc.ordinal() < ApplyATsVisitor.detectModifier(modifiers, null).ordinal()) {
            this.modify(targetAcc, modifiers, Arrays.stream(modifiers.getChildren()).filter(el -> el instanceof PsiKeyword).map(el -> (PsiKeyword)el).filter(kw -> ACCESS_MODIFIERS.contains(kw.getText())).findFirst());
        }
        Transformation.FinalState finalState = at.finalState();
        if (finalState == Transformation.FinalState.REMOVEFINAL && modifiers.hasModifierProperty("final")) {
            Arrays.stream(modifiers.getChildren()).filter(el -> el instanceof PsiKeyword).map(el -> (PsiKeyword)el).filter(kw -> kw.getText().equals("final")).findFirst().ifPresent(this.replacements::remove);
        } else if (finalState == Transformation.FinalState.MAKEFINAL && !modifiers.hasModifierProperty("final")) {
            this.error("Access transformer %s attempted to make %s final. Was non-final", at, targetInfo);
        }
    }

    private void modify(Transformation.Modifier targetAcc, PsiModifierList modifiers, Optional<PsiKeyword> existingModifier) {
        if (targetAcc == Transformation.Modifier.DEFAULT) {
            existingModifier.ifPresent(this.replacements::remove);
        } else if (existingModifier.isPresent()) {
            this.replacements.replace(existingModifier.get(), MODIFIER_TO_STRING.get((Object)targetAcc));
        } else if (modifiers.getChildren().length == 0) {
            this.replacements.insertAfter(modifiers, MODIFIER_TO_STRING.get((Object)targetAcc) + " ");
        } else {
            String modifierStr = MODIFIER_TO_STRING.get((Object)targetAcc);
            Arrays.stream(modifiers.getChildren()).filter(element -> element instanceof PsiKeyword && MODIFIERS.contains(element.getText())).findFirst().ifPresentOrElse(first2 -> this.replacements.insertBefore((PsiElement)first2, modifierStr + " "), () -> {
                PsiElement patt10974$temp = modifiers.getParent();
                if (patt10974$temp instanceof PsiClass) {
                    PsiClass cls = (PsiClass)patt10974$temp;
                    String typeKeyword = ApplyATsVisitor.detectKind(cls);
                    PsiElement next2 = modifiers;
                    while ((next2 = next2.getNextSibling()) != null) {
                        PsiKeyword kw;
                        if (!(next2 instanceof PsiKeyword) || !(kw = (PsiKeyword)next2).getText().equals(typeKeyword)) continue;
                        this.replacements.insertBefore(kw, modifierStr + " ");
                        break;
                    }
                } else {
                    PsiElement patt11635$temp = modifiers.getParent();
                    if (patt11635$temp instanceof PsiMethod) {
                        PsiMethod method = (PsiMethod)patt11635$temp;
                        if (method.getReturnTypeElement() == null) {
                            this.replacements.insertBefore(method.getNameIdentifier(), modifierStr + " ");
                        } else {
                            this.replacements.insertBefore(method.getReturnTypeElement(), modifierStr + " ");
                        }
                    } else {
                        PsiField field;
                        PsiElement patt12126$temp = modifiers.getParent();
                        if (patt12126$temp instanceof PsiField && (field = (PsiField)patt12126$temp).getTypeElement() != null) {
                            this.replacements.insertBefore(field.getTypeElement(), modifierStr + " ");
                        } else {
                            this.replacements.insertBefore(modifiers, modifierStr + " ");
                        }
                    }
                }
            });
        }
    }

    private void checkImplicitConstructor(PsiClass psiClass, String className, @Nullable Transformation classAt) {
        if (psiClass.isRecord()) {
            StringBuilder descriptor2 = new StringBuilder("(");
            for (PsiRecordComponent recordComponent : psiClass.getRecordComponents()) {
                descriptor2.append(ClassUtil.getBinaryPresentation(recordComponent.getType()));
            }
            descriptor2.append(")V");
            String desc = descriptor2.toString();
            Transformation implicitAT = this.pendingATs.remove(new Target.MethodTarget(className, "<init>", desc));
            if (implicitAT != null && implicitAT.modifier() != ApplyATsVisitor.detectModifier(psiClass.getModifierList(), classAt)) {
                this.error("Access transformer %s targeting the implicit constructor of %s is not valid, as a record's constructor must have the same access level as the record class. Please AT the record too: \"%s\"", implicitAT, className, implicitAT.modifier().toString().toLowerCase(Locale.ROOT) + " " + className);
                this.pendingATs.remove(new Target.MethodTarget(className, "<init>", desc));
            } else if (classAt != null && ApplyATsVisitor.detectModifier(psiClass.getModifierList(), null).ordinal() > classAt.modifier().ordinal() && implicitAT == null) {
                this.error("Access transformer %s targeting record class %s attempts to widen its access without widening the constructor's access. You must AT the constructor too: \"%s\"", classAt, className, classAt.modifier().toString().toLowerCase(Locale.ROOT) + " " + className + " <init>" + desc);
                this.pendingATs.remove(new Target.MethodTarget(className, "<init>", desc));
            }
        } else if (psiClass.getClassKind() == JvmClassKind.CLASS && psiClass.getConstructors().length == 0) {
            Target.MethodTarget constructorTarget = new Target.MethodTarget(className, "<init>", PsiHelper.getImplicitConstructorSignature(psiClass));
            Transformation constructorAt = this.pendingATs.remove(constructorTarget);
            if (classAt != null && ApplyATsVisitor.detectModifier(psiClass.getModifierList(), null).ordinal() > classAt.modifier().ordinal()) {
                if (constructorAt == null || constructorAt.modifier() != classAt.modifier()) {
                    Transformation.Modifier expectedModifier = ApplyATsVisitor.detectModifier(psiClass.getModifierList(), constructorAt);
                    this.injectConstructor(psiClass, className, expectedModifier);
                }
            } else if (constructorAt != null && constructorAt.modifier().ordinal() < ApplyATsVisitor.detectModifier(psiClass.getModifierList(), null).ordinal()) {
                this.injectConstructor(psiClass, className, constructorAt.modifier());
            }
        }
    }

    private void injectConstructor(PsiClass psiClass, String className, Transformation.Modifier modifier) {
        this.logger.debug("Injecting implicit constructor with access level %s into class %s", new Object[]{modifier, className});
        int indent = 4;
        PsiElement psiElement = psiClass.getPrevSibling();
        if (psiElement instanceof PsiWhiteSpace) {
            PsiWhiteSpace psiWhiteSpace = (PsiWhiteSpace)psiElement;
            indent += PsiHelper.getLastLineLength(psiWhiteSpace);
        }
        String modifierString = modifier == Transformation.Modifier.DEFAULT ? "" : MODIFIER_TO_STRING.get((Object)modifier) + " ";
        this.replacements.insertAfter(Objects.requireNonNull(psiClass.getLBrace()), "\n" + " ".repeat(indent) + modifierString + psiClass.getName() + "() {}");
    }

    private void error(String message, Object ... args2) {
        this.logger.error(message, args2);
        this.errored = true;
    }

    private static String detectKind(PsiClass cls) {
        if (cls.isRecord()) {
            return "record";
        }
        if (cls.isInterface()) {
            return "interface";
        }
        if (cls.isEnum()) {
            return "enum";
        }
        return "class";
    }

    private static Transformation merge(Transformation a, @Nullable Transformation b) {
        return b == null ? a : a.mergeStates(b);
    }

    private static Target.MethodTarget method(String owner, PsiMethod method) {
        return new Target.MethodTarget(owner, PsiHelper.getBinaryMethodName(method), PsiHelper.getBinaryMethodSignature(method));
    }

    private static Transformation.Modifier detectModifier(PsiModifierList owner, @Nullable Transformation trans) {
        if (trans != null) {
            return trans.modifier();
        }
        for (String mod : ACCESS_MODIFIERS) {
            if (!owner.hasModifierProperty(mod)) continue;
            return STRING_TO_MODIFIER.get(mod);
        }
        return Transformation.Modifier.DEFAULT;
    }
}

