/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.api;

import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.neoforged.jst.api.FileEntry;
import net.neoforged.jst.api.PathFileEntry;
import net.neoforged.jst.api.ZipFileEntry;

public final class FileEntries {
    private FileEntries() {
    }

    public static FileEntry ofPath(Path sourceRoot, Path path) {
        if (path.equals(sourceRoot)) {
            throw new IllegalStateException("path must not be the source root itself, since this results in an empty relative path");
        }
        if (!path.startsWith(sourceRoot)) {
            throw new IllegalStateException("path must be a child of sourceRoot");
        }
        return new PathFileEntry(sourceRoot, path);
    }

    public static FileEntry ofZipEntry(ZipFile zipFile, ZipEntry zipEntry) {
        return new ZipFileEntry(zipFile, zipEntry);
    }
}

