/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.cli;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.attribute.FileTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import net.neoforged.jst.api.FileSink;

class OrderedParallelWorkQueue
implements AutoCloseable {
    private final Deque<Future<List<WorkResult>>> pending;
    private final FileSink sink;
    private final int maxQueueDepth;

    public OrderedParallelWorkQueue(FileSink sink, int maxQueueDepth) {
        this.sink = sink;
        this.maxQueueDepth = maxQueueDepth;
        if (maxQueueDepth < 0) {
            throw new IllegalArgumentException("Max queue depth must not be negative");
        }
        this.pending = new ArrayDeque<Future<List<WorkResult>>>(maxQueueDepth);
    }

    public void submit(Consumer<FileSink> producer) throws IOException {
        if (this.pending.isEmpty()) {
            producer.accept(this.sink);
        } else {
            this.submitAsync(producer);
        }
    }

    public void submitAsync(Consumer<FileSink> producer) {
        try {
            if (this.maxQueueDepth <= 0) {
                this.submit(producer);
                return;
            }
            this.drainTo(this.maxQueueDepth - 1);
            this.pending.add(CompletableFuture.supplyAsync(() -> {
                List<WorkResult> list;
                ParallelSink parallelSink = new ParallelSink();
                try {
                    producer.accept(parallelSink);
                    list = parallelSink.workResults;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            parallelSink.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                parallelSink.close();
                return list;
            }));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void drainTo(int drainTo) throws InterruptedException, IOException {
        while (this.pending.size() > drainTo) {
            List<WorkResult> workResults;
            try {
                workResults = this.pending.removeFirst().get();
            }
            catch (ExecutionException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof IOException) {
                    IOException ioe = (IOException)throwable;
                    throw ioe;
                }
                throw new RuntimeException(e.getCause());
            }
            for (WorkResult workResult : workResults) {
                if (workResult.directory) {
                    this.sink.putDirectory(workResult.relativePath);
                    continue;
                }
                this.sink.putFile(workResult.relativePath, workResult.lastModified, workResult.content);
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.drainTo(0);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.sink.close();
        }
    }

    private record WorkResult(boolean directory, String relativePath, FileTime lastModified, byte[] content) {
    }

    private final class ParallelSink
    implements FileSink {
        private final List<WorkResult> workResults = new ArrayList<WorkResult>();

        private ParallelSink() {
        }

        @Override
        public boolean canHaveMultipleEntries() {
            return OrderedParallelWorkQueue.this.sink.canHaveMultipleEntries();
        }

        @Override
        public boolean isOrdered() {
            return false;
        }

        @Override
        public void putDirectory(String relativePath) {
            this.workResults.add(new WorkResult(true, relativePath, null, null));
        }

        @Override
        public void putFile(String relativePath, FileTime lastModified, byte[] content) {
            this.workResults.add(new WorkResult(false, relativePath, lastModified, content));
        }
    }
}

