/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.cli.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import net.neoforged.jst.api.FileSink;

record FolderFileSink(Path path) implements FileSink
{
    @Override
    public void putDirectory(String relativePath) throws IOException {
        Path targetPath = this.path.resolve(relativePath);
        Files.createDirectories(targetPath, new FileAttribute[0]);
    }

    @Override
    public void putFile(String relativePath, FileTime lastModified, byte[] content) throws IOException {
        Path targetPath = this.path.resolve(relativePath);
        Files.write(targetPath, content, new OpenOption[0]);
        Files.setLastModifiedTime(targetPath, lastModified);
    }

    @Override
    public boolean canHaveMultipleEntries() {
        return true;
    }

    @Override
    public boolean isOrdered() {
        return false;
    }
}

