/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.metadata;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.parchmentmc.feather.metadata.ClassMetadata;
import org.parchmentmc.feather.metadata.FieldMetadata;
import org.parchmentmc.feather.metadata.FieldMetadataBuilder;
import org.parchmentmc.feather.metadata.ImmutableClassMetadata;
import org.parchmentmc.feather.metadata.MethodMetadata;
import org.parchmentmc.feather.metadata.MethodMetadataBuilder;
import org.parchmentmc.feather.metadata.RecordMetadata;
import org.parchmentmc.feather.metadata.RecordMetadataBuilder;
import org.parchmentmc.feather.metadata.Reference;
import org.parchmentmc.feather.metadata.ReferenceBuilder;
import org.parchmentmc.feather.named.Named;
import org.parchmentmc.feather.named.NamedBuilder;
import org.parchmentmc.feather.util.AccessFlag;
import org.parchmentmc.feather.util.CollectorUtils;
import org.parchmentmc.feather.util.HasImmutable;

public final class ClassMetadataBuilder
implements ClassMetadata {
    private Named superName = Named.empty();
    private LinkedHashSet<Named> interfaces = Sets.newLinkedHashSet();
    private LinkedHashSet<MethodMetadata> methods = Sets.newLinkedHashSet();
    private LinkedHashSet<FieldMetadata> fields = Sets.newLinkedHashSet();
    private LinkedHashSet<RecordMetadata> records = Sets.newLinkedHashSet();
    private LinkedHashSet<ClassMetadata> innerClasses = Sets.newLinkedHashSet();
    private Named owner = Named.empty();
    private Named name = Named.empty();
    private int securitySpecifications = 0;
    private Named signature = Named.empty();
    private boolean isRecord = false;

    private ClassMetadataBuilder() {
    }

    public static ClassMetadataBuilder create() {
        return new ClassMetadataBuilder();
    }

    public static ClassMetadataBuilder create(ClassMetadata classMetadata) {
        if (classMetadata == null) {
            return ClassMetadataBuilder.create();
        }
        return ClassMetadataBuilder.create().withSuperName(classMetadata.getSuperName()).withInterfaces(classMetadata.getInterfaces()).withMethods(classMetadata.getMethods()).withFields(classMetadata.getFields()).withInnerClasses(classMetadata.getInnerClasses()).withOwner(classMetadata.getOwner()).withName(classMetadata.getName()).withSecuritySpecifications(classMetadata.getSecuritySpecification()).withRecords(classMetadata.getRecords()).withIsRecord(classMetadata.isRecord());
    }

    public ClassMetadataBuilder withSuperName(Named superName) {
        this.superName = superName;
        return this;
    }

    public ClassMetadataBuilder withInterfaces(Set<Named> interfaces) {
        this.interfaces = new LinkedHashSet<Named>(interfaces);
        return this;
    }

    public ClassMetadataBuilder withMethods(Set<MethodMetadata> methods) {
        this.methods = new LinkedHashSet<MethodMetadata>(methods);
        return this;
    }

    public ClassMetadataBuilder addMethod(MethodMetadata method) {
        this.methods.add(method);
        return this;
    }

    public ClassMetadataBuilder withFields(Set<FieldMetadata> fields) {
        this.fields = new LinkedHashSet<FieldMetadata>(fields);
        return this;
    }

    public ClassMetadataBuilder addField(FieldMetadata field) {
        this.fields.add(field);
        return this;
    }

    public ClassMetadataBuilder withRecords(Set<RecordMetadata> records) {
        this.records = new LinkedHashSet<RecordMetadata>(records);
        this.isRecord = !records.isEmpty();
        return this;
    }

    public ClassMetadataBuilder addRecord(RecordMetadata record) {
        this.records.add(record);
        this.isRecord = true;
        return this;
    }

    public ClassMetadataBuilder withInnerClasses(Set<ClassMetadata> innerClasses) {
        this.innerClasses = new LinkedHashSet<ClassMetadata>(innerClasses);
        return this;
    }

    public ClassMetadataBuilder addInnerClass(ClassMetadata classMetadata) {
        this.innerClasses.add(classMetadata);
        return this;
    }

    public ClassMetadataBuilder withOwner(Named owner) {
        this.owner = owner;
        return this;
    }

    public ClassMetadataBuilder withName(Named name) {
        this.name = name;
        return this;
    }

    public ClassMetadataBuilder withSecuritySpecifications(int securitySpecifications) {
        this.securitySpecifications = securitySpecifications;
        return this;
    }

    public ClassMetadataBuilder withSignature(Named signature) {
        this.signature = signature;
        return this;
    }

    public ClassMetadataBuilder withIsRecord(boolean isRecord) {
        this.isRecord = isRecord;
        return this;
    }

    public ClassMetadataBuilder merge(ClassMetadata source, String mergingScheme) {
        if (source == null) {
            return this;
        }
        this.name = NamedBuilder.create(this.name).merge(source.getName()).build();
        this.owner = NamedBuilder.create(this.owner).merge(source.getOwner()).build();
        this.superName = NamedBuilder.create(this.superName).merge(source.getSuperName()).build();
        EnumSet<AccessFlag> thisAccessFlags = AccessFlag.getAccessFlags(this.securitySpecifications);
        EnumSet<AccessFlag> sourceAccessFlags = AccessFlag.getAccessFlags(source.getSecuritySpecification());
        EnumSet<AccessFlag> mergedFlags = EnumSet.noneOf(AccessFlag.class);
        mergedFlags.addAll(thisAccessFlags);
        mergedFlags.addAll(sourceAccessFlags);
        this.securitySpecifications = AccessFlag.toSecuritySpecification(mergedFlags);
        Map schemadLocalMethods = this.methods.stream().collect(CollectorUtils.toLinkedMap(mm4 -> ReferenceBuilder.create().withName(NamedBuilder.create().with(mergingScheme, mm4.getName().getName(mergingScheme).orElse(""))).withOwner(NamedBuilder.create().with(mergingScheme, mm4.getOwner().getName(mergingScheme).orElse(""))).withDescriptor(NamedBuilder.create().with(mergingScheme, mm4.getDescriptor().getName(mergingScheme).orElse(""))).build(), Function.identity()));
        Map schemadSourceMethods = source.getMethods().stream().collect(CollectorUtils.toLinkedMap(mm4 -> ReferenceBuilder.create().withName(NamedBuilder.create().with(mergingScheme, mm4.getName().getName(mergingScheme).orElse(""))).withOwner(NamedBuilder.create().with(mergingScheme, mm4.getOwner().getName(mergingScheme).orElse(""))).withDescriptor(NamedBuilder.create().with(mergingScheme, mm4.getDescriptor().getName(mergingScheme).orElse(""))).build(), Function.identity()));
        this.methods = new LinkedHashSet();
        for (Reference keyReference : schemadLocalMethods.keySet()) {
            if (!schemadSourceMethods.containsKey(keyReference)) {
                this.methods.add((MethodMetadata)schemadLocalMethods.get(keyReference));
                continue;
            }
            this.methods.add(MethodMetadataBuilder.create((MethodMetadata)schemadLocalMethods.get(keyReference)).merge((MethodMetadata)schemadSourceMethods.get(keyReference), mergingScheme).build());
        }
        schemadSourceMethods.keySet().stream().filter(mr -> !schemadLocalMethods.containsKey(mr)).forEach(mr -> this.methods.add((MethodMetadata)schemadSourceMethods.get(mr)));
        Map schemadLocalFields = this.fields.stream().collect(CollectorUtils.toLinkedMap(fm -> NamedBuilder.create().with(mergingScheme, fm.getName().getName(mergingScheme).orElse("")).build(), Function.identity()));
        Map schemadSourceFields = source.getFields().stream().collect(CollectorUtils.toLinkedMap(fm -> NamedBuilder.create().with(mergingScheme, fm.getName().getName(mergingScheme).orElse("")).build(), Function.identity()));
        this.fields = new LinkedHashSet();
        for (Named keyReference : schemadLocalFields.keySet()) {
            if (!schemadSourceFields.containsKey(keyReference)) {
                this.fields.add((FieldMetadata)schemadLocalFields.get(keyReference));
                continue;
            }
            this.fields.add(FieldMetadataBuilder.create((FieldMetadata)schemadLocalFields.get(keyReference)).merge((FieldMetadata)schemadSourceFields.get(keyReference)).build());
        }
        schemadSourceFields.keySet().stream().filter(mr -> !schemadLocalFields.containsKey(mr)).forEach(mr -> this.fields.add((FieldMetadata)schemadSourceFields.get(mr)));
        Map schemadLocalRecords = this.records.stream().collect(CollectorUtils.toLinkedMap(fm -> NamedBuilder.create().with(mergingScheme, fm.getField().getName().getName(mergingScheme).orElse("")).build(), Function.identity()));
        Map schemadSourceRecords = source.getRecords().stream().collect(CollectorUtils.toLinkedMap(fm -> NamedBuilder.create().with(mergingScheme, fm.getField().getName().getName(mergingScheme).orElse("")).build(), Function.identity()));
        this.records = new LinkedHashSet();
        for (Named keyReference : schemadLocalRecords.keySet()) {
            if (!schemadSourceRecords.containsKey(keyReference)) {
                this.records.add((RecordMetadata)schemadLocalRecords.get(keyReference));
                continue;
            }
            this.records.add(RecordMetadataBuilder.create((RecordMetadata)schemadLocalRecords.get(keyReference)).merge((RecordMetadata)schemadSourceRecords.get(keyReference)).build());
        }
        schemadSourceRecords.keySet().stream().filter(mr -> !schemadLocalRecords.containsKey(mr)).forEach(mr -> this.records.add((RecordMetadata)schemadSourceRecords.get(mr)));
        Map schemadLocalInnerClasses = this.innerClasses.stream().collect(CollectorUtils.toLinkedMap(fm -> NamedBuilder.create().with(mergingScheme, fm.getName().getName(mergingScheme).orElse("")).build(), Function.identity()));
        Map schemadSourceInnerClasses = source.getInnerClasses().stream().collect(CollectorUtils.toLinkedMap(fm -> NamedBuilder.create().with(mergingScheme, fm.getName().getName(mergingScheme).orElse("")).build(), Function.identity()));
        this.innerClasses = new LinkedHashSet();
        for (Named keyReference : schemadLocalInnerClasses.keySet()) {
            if (!schemadSourceInnerClasses.containsKey(keyReference)) {
                this.innerClasses.add((ClassMetadata)schemadLocalInnerClasses.get(keyReference));
                continue;
            }
            this.innerClasses.add(ClassMetadataBuilder.create((ClassMetadata)schemadLocalInnerClasses.get(keyReference)).merge((ClassMetadata)schemadSourceInnerClasses.get(keyReference), mergingScheme).build());
        }
        schemadSourceInnerClasses.keySet().stream().filter(mr -> !schemadLocalInnerClasses.containsKey(mr)).forEach(mr -> this.innerClasses.add((ClassMetadata)schemadSourceInnerClasses.get(mr)));
        this.signature = NamedBuilder.create(this.signature).merge(source.getSignature()).build();
        return this;
    }

    @Override
    public @NonNull ClassMetadata toImmutable() {
        return this.build();
    }

    public @NonNull ClassMetadata build() {
        return new ImmutableClassMetadata((Named)this.superName.toImmutable(), this.interfaces.stream().map(HasImmutable::toImmutable).collect(CollectorUtils.toLinkedSet()), this.methods.stream().map(HasImmutable::toImmutable).collect(CollectorUtils.toLinkedSet()), this.fields.stream().map(HasImmutable::toImmutable).collect(CollectorUtils.toLinkedSet()), this.records.stream().map(HasImmutable::toImmutable).collect(CollectorUtils.toLinkedSet()), this.innerClasses.stream().map(HasImmutable::toImmutable).collect(CollectorUtils.toLinkedSet()), (Named)this.owner.toImmutable(), (Named)this.name.toImmutable(), this.securitySpecifications, this.signature, this.isRecord);
    }

    public int hashCode() {
        return Objects.hash(this.getSuperName(), this.getInterfaces(), this.getMethods(), this.getFields(), this.getRecords(), this.getInnerClasses(), this.getOwner(), this.getName(), this.getSecuritySpecification());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassMetadata)) {
            return false;
        }
        ClassMetadata that = (ClassMetadata)o;
        return this.getSecuritySpecification() == that.getSecuritySpecification() && Objects.equals(this.getSuperName(), that.getSuperName()) && this.getInterfaces().equals(that.getInterfaces()) && this.getMethods().equals(that.getMethods()) && this.getFields().equals(that.getFields()) && this.getRecords().equals(that.getRecords()) && this.getInnerClasses().equals(that.getInnerClasses()) && Objects.equals(this.getOwner(), that.getOwner()) && this.getName().equals(that.getName());
    }

    @Override
    public int getSecuritySpecification() {
        return this.securitySpecifications;
    }

    @Override
    public @NonNull Named getSuperName() {
        return this.superName;
    }

    @Override
    public @NonNull LinkedHashSet<Named> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public @NonNull LinkedHashSet<MethodMetadata> getMethods() {
        return this.methods;
    }

    @Override
    public @NonNull LinkedHashSet<FieldMetadata> getFields() {
        return this.fields;
    }

    @Override
    public @NonNull LinkedHashSet<RecordMetadata> getRecords() {
        return this.records;
    }

    @Override
    public @NonNull LinkedHashSet<ClassMetadata> getInnerClasses() {
        return this.innerClasses;
    }

    @Override
    public @NonNull Named getSignature() {
        return this.signature;
    }

    @Override
    public boolean isRecord() {
        return this.isRecord;
    }

    @Override
    public @NonNull Named getOwner() {
        return this.owner;
    }

    @Override
    public @NonNull Named getName() {
        return this.name;
    }
}

