/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.named;

import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.parchmentmc.feather.named.ImmutableNamed;
import org.parchmentmc.feather.util.HasImmutable;

public interface Named
extends HasImmutable<Named> {
    public static Named empty() {
        return ImmutableNamed.empty();
    }

    public Map<String, String> getNames();

    default public boolean isEmpty() {
        return this.getNames().isEmpty();
    }

    default public Optional<String> getObfuscatedName() {
        return this.getObfuscatedName(null);
    }

    default public Optional<String> getObfuscatedName(@Nullable String orElse) {
        return this.getName("obf", orElse);
    }

    default public boolean hasObfuscatedName() {
        return this.getObfuscatedName().isPresent();
    }

    default public Optional<String> getMojangName() {
        return this.getMojangName(null);
    }

    default public Optional<String> getMojangName(String orElse) {
        return this.getName("moj", orElse);
    }

    default public boolean hasMojangName() {
        return this.getMojangName().isPresent();
    }

    default public Optional<String> getName(String scheme) {
        return this.getName(scheme, null);
    }

    default public Optional<String> getName(String scheme, String orElse) {
        return Optional.ofNullable(this.getNames().getOrDefault(scheme, orElse));
    }

    default public boolean hasName(String scheme) {
        return this.getName(scheme).isPresent();
    }
}

