/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.diagnostic.LoadingState;
import com.intellij.model.SideEffectGuard;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.impl.FlushQueue;
import com.intellij.openapi.application.impl.ModalContextProjectLocator;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.EDT;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class LaterInvocator {
    private static final Logger LOG = Logger.getInstance(LaterInvocator.class);
    private static final List<Object> ourModalEntities = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final Map<Project, List<Dialog>> projectToModalEntities = new WeakHashMap<Project, List<Dialog>>();
    private static final Map<Project, Stack<ModalityState>> projectToModalEntitiesStack = new WeakHashMap<Project, Stack<ModalityState>>();
    private static final Stack<ModalityStateEx> ourModalityStack = new Stack<ModalityStateEx>((ModalityStateEx)ModalityState.nonModal());
    private static final EventDispatcher<ModalityStateListener> ourModalityStateMulticaster = EventDispatcher.create(ModalityStateListener.class);
    private static final FlushQueue ourEdtQueue = new FlushQueue();
    private static final ConcurrentMap<Window, ModalityStateEx> ourWindowModalities = CollectionFactory.createConcurrentWeakMap();

    private LaterInvocator() {
    }

    public static void addModalityStateListener(@NotNull ModalityStateListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            LaterInvocator.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            LaterInvocator.$$$reportNull$$$0(1);
        }
        if (!ourModalityStateMulticaster.getListeners().contains(listener)) {
            ourModalityStateMulticaster.addListener(listener, parentDisposable);
        }
    }

    @NotNull
    static ModalityStateEx modalityStateForWindow(@NotNull Window window) {
        if (window == null) {
            LaterInvocator.$$$reportNull$$$0(2);
        }
        ModalityStateEx modalityStateEx = ourWindowModalities.computeIfAbsent(window, __ -> {
            Stack<ModalityStateEx> stack = ourModalityStack;
            synchronized (stack) {
                for (ModalityStateEx state : ourModalityStack) {
                    if (!state.contains(window)) continue;
                    return state;
                }
            }
            Window owner = window.getOwner();
            ModalityStateEx ownerState = owner == null ? (ModalityStateEx)ModalityState.nonModal() : LaterInvocator.modalityStateForWindow(owner);
            return LaterInvocator.isModalDialog(window) ? ownerState.appendEntity(window) : ownerState;
        });
        if (modalityStateEx == null) {
            LaterInvocator.$$$reportNull$$$0(3);
        }
        return modalityStateEx;
    }

    private static boolean isModalDialog(@NotNull Object window) {
        if (window == null) {
            LaterInvocator.$$$reportNull$$$0(4);
        }
        return window instanceof Dialog && ((Dialog)window).isModal();
    }

    static void invokeLater(@NotNull ModalityState modalityState, @NotNull Condition<?> expired, @NotNull Runnable runnable) {
        if (modalityState == null) {
            LaterInvocator.$$$reportNull$$$0(5);
        }
        if (expired == null) {
            LaterInvocator.$$$reportNull$$$0(6);
        }
        if (runnable == null) {
            LaterInvocator.$$$reportNull$$$0(7);
        }
        SideEffectGuard.checkSideEffectAllowed(SideEffectGuard.EffectType.INVOKE_LATER);
        if (expired.value(null)) {
            return;
        }
        ourEdtQueue.push(modalityState, expired, runnable);
    }

    static void invokeAndWait(@NotNull ModalityState modalityState, @NotNull Runnable runnable) {
        if (modalityState == null) {
            LaterInvocator.$$$reportNull$$$0(8);
        }
        if (runnable == null) {
            LaterInvocator.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        final AtomicReference<Runnable> runnableRef = new AtomicReference<Runnable>(runnable);
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final Ref exception = Ref.create();
        Runnable runnable1 = new Runnable(){

            @Override
            public void run() {
                Runnable runnable = runnableRef.getAndSet(null);
                if (runnable == null) {
                    return;
                }
                try {
                    runnable.run();
                }
                catch (Throwable e) {
                    exception.set(e);
                }
                finally {
                    semaphore.up();
                }
            }

            @NonNls
            public String toString() {
                Runnable runnable = (Runnable)runnableRef.get();
                return "InvokeAndWait[" + (runnable == null ? "(cancelled)" : runnable.toString()) + "]";
            }
        };
        LaterInvocator.invokeLater(modalityState, Conditions.alwaysFalse(), runnable1);
        try {
            while (!semaphore.waitFor(10L)) {
                ProgressManager.checkCanceled();
            }
        }
        catch (Throwable e) {
            runnableRef.set(null);
            throw e;
        }
        if (!exception.isNull()) {
            Throwable cause = (Throwable)exception.get();
            if (SystemProperties.getBooleanProperty("invoke.later.wrap.error", true)) {
                throw new RuntimeException(cause);
            }
            ExceptionUtil.rethrow(cause);
        }
    }

    public static void enterModal(@NotNull Object modalEntity) {
        if (modalEntity == null) {
            LaterInvocator.$$$reportNull$$$0(10);
        }
        ModalityStateEx state = LaterInvocator.getCurrentModalityState().appendEntity(modalEntity);
        if (LaterInvocator.isModalDialog(modalEntity)) {
            ModalityStateEx current = state;
            state = LaterInvocator.modalityStateForWindow((Window)modalEntity);
            state.forceModalEntities(current);
        }
        LaterInvocator.enterModal(modalEntity, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enterModal(@NotNull Object modalEntity, @NotNull ModalityStateEx appendedState) {
        TransactionGuardImpl guard;
        if (modalEntity == null) {
            LaterInvocator.$$$reportNull$$$0(11);
        }
        if (appendedState == null) {
            LaterInvocator.$$$reportNull$$$0(12);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (LOG.isDebugEnabled()) {
            LOG.debug("enterModal:" + modalEntity);
        }
        ourModalityStateMulticaster.getMulticaster().beforeModalityStateChanged(true, modalEntity);
        ourModalEntities.add(modalEntity);
        Stack<ModalityStateEx> stack = ourModalityStack;
        synchronized (stack) {
            ourModalityStack.push(appendedState);
        }
        TransactionGuardImpl transactionGuardImpl = guard = LoadingState.COMPONENTS_LOADED.isOccurred() ? (TransactionGuardImpl)TransactionGuard.getInstance() : null;
        if (guard != null) {
            guard.enteredModality(appendedState);
        }
        LaterInvocator.reincludeSkippedItemsAndRequestFlush();
    }

    public static void enterModal(@NotNull Project project, @NotNull Dialog dialog) {
        if (project == null) {
            LaterInvocator.$$$reportNull$$$0(13);
        }
        if (dialog == null) {
            LaterInvocator.$$$reportNull$$$0(14);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (LOG.isDebugEnabled()) {
            LOG.debug("enterModal:" + dialog.getName() + " ; for project: " + project.getName());
        }
        ourModalityStateMulticaster.getMulticaster().beforeModalityStateChanged(true, dialog);
        List modalEntitiesList = projectToModalEntities.computeIfAbsent(project, __ -> ContainerUtil.createLockFreeCopyOnWriteList());
        modalEntitiesList.add(dialog);
        Stack modalEntitiesStack = projectToModalEntitiesStack.computeIfAbsent(project, __ -> new Stack<ModalityState>(ModalityState.nonModal()));
        modalEntitiesStack.push(new ModalityStateEx(ourModalEntities));
    }

    @Deprecated
    @ApiStatus.Internal
    @ApiStatus.ScheduledForRemoval
    public static void markTransparent(@NotNull ModalityState state) {
        if (state == null) {
            LaterInvocator.$$$reportNull$$$0(15);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ((ModalityStateEx)state).markTransparent();
        LaterInvocator.reincludeSkippedItemsAndRequestFlush();
    }

    public static void leaveModal(Project project, @NotNull Dialog dialog) {
        if (dialog == null) {
            LaterInvocator.$$$reportNull$$$0(16);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (LOG.isDebugEnabled()) {
            LOG.debug("leaveModal:" + dialog.getName() + " ; for project: " + project.getName());
        }
        ourModalityStateMulticaster.getMulticaster().beforeModalityStateChanged(false, dialog);
        int index = ourModalEntities.indexOf(dialog);
        if (index != -1) {
            LaterInvocator.removeModality(dialog, index);
        } else if (project != null) {
            List<Dialog> dialogs = projectToModalEntities.get(project);
            int perProjectIndex = dialogs.indexOf(dialog);
            LOG.assertTrue(perProjectIndex >= 0);
            dialogs.remove(perProjectIndex);
            Stack<ModalityState> states = projectToModalEntitiesStack.get(project);
            states.remove(perProjectIndex + 1);
            for (int i = 1; i < states.size(); ++i) {
                ((ModalityStateEx)states.get(i)).removeModality(dialog);
            }
        }
        LaterInvocator.reincludeSkippedItemsAndRequestFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeModality(@NotNull Object modalEntity, int index) {
        if (modalEntity == null) {
            LaterInvocator.$$$reportNull$$$0(17);
        }
        ourModalEntities.remove(index);
        Stack<ModalityStateEx> stack = ourModalityStack;
        synchronized (stack) {
            ourModalityStack.remove(index + 1);
            for (int i = 1; i < ourModalityStack.size(); ++i) {
                ((ModalityStateEx)ourModalityStack.get(i)).removeModality(modalEntity);
            }
        }
        ModalityStateEx.unmarkTransparent(modalEntity);
    }

    public static void leaveModal(@NotNull Object modalEntity) {
        if (modalEntity == null) {
            LaterInvocator.$$$reportNull$$$0(18);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (LOG.isDebugEnabled()) {
            LOG.debug("leaveModal:" + modalEntity);
        }
        ourModalityStateMulticaster.getMulticaster().beforeModalityStateChanged(false, modalEntity);
        int index = ourModalEntities.indexOf(modalEntity);
        LOG.assertTrue(index >= 0);
        LaterInvocator.removeModality(modalEntity, index);
        LaterInvocator.reincludeSkippedItemsAndRequestFlush();
    }

    @TestOnly
    public static void leaveAllModals() {
        ThreadingAssertions.assertEventDispatchThread();
        while (!ourModalEntities.isEmpty()) {
            LaterInvocator.leaveModal(ourModalEntities.get(ourModalEntities.size() - 1));
        }
        LOG.assertTrue(LaterInvocator.getCurrentModalityState() == ModalityState.nonModal(), LaterInvocator.getCurrentModalityState());
        LaterInvocator.reincludeSkippedItemsAndRequestFlush();
    }

    @ApiStatus.Internal
    public static void forceLeaveAllModals() {
        ThreadingAssertions.assertEventDispatchThread();
        ModalityStateEx currentState = LaterInvocator.getCurrentModalityState();
        if (currentState != ModalityState.nonModal()) {
            currentState.cancelAllEntities();
            LaterInvocator.invokeLater(ModalityState.any(), Conditions.alwaysFalse(), () -> LaterInvocator.forceLeaveAllModals());
        }
    }

    public static Object @NotNull [] getCurrentModalEntities() {
        ThreadingAssertions.assertEventDispatchThread();
        Object[] objectArray = ArrayUtil.toObjectArray(ourModalEntities);
        if (objectArray == null) {
            LaterInvocator.$$$reportNull$$$0(19);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static ModalityStateEx getCurrentModalityState() {
        ThreadingAssertions.assertEventDispatchThread();
        Stack<ModalityStateEx> stack = ourModalityStack;
        // MONITORENTER : stack
        ModalityStateEx modalityStateEx = ourModalityStack.peek();
        // MONITOREXIT : stack
        if (modalityStateEx != null) return modalityStateEx;
        LaterInvocator.$$$reportNull$$$0(20);
        return modalityStateEx;
    }

    public static boolean isInModalContextForProject(@Nullable Project project) {
        ThreadingAssertions.assertEventDispatchThread();
        if (ourModalEntities.isEmpty()) {
            return false;
        }
        if (project == null) {
            return true;
        }
        List<Dialog> modalEntitiesForProject = projectToModalEntities.get(project);
        return modalEntitiesForProject == null || modalEntitiesForProject.isEmpty();
    }

    public static boolean isInModalContext() {
        return LaterInvocator.isInModalContextForProject(null);
    }

    public static boolean isInModalContext(@NotNull JFrame frame, @Nullable Project project) {
        if (frame == null) {
            LaterInvocator.$$$reportNull$$$0(21);
        }
        Object[] entities = LaterInvocator.getCurrentModalEntities();
        int forOtherProjects = 0;
        for (Object entity : entities) {
            if (entity instanceof ModalContextProjectLocator && !((ModalContextProjectLocator)entity).isPartOf(frame, project)) {
                ++forOtherProjects;
                continue;
            }
            if (!(entity instanceof Component) || LaterInvocator.isAncestor(frame, (Component)entity)) continue;
            ++forOtherProjects;
        }
        return forOtherProjects != entities.length;
    }

    private static boolean isAncestor(@NotNull Component ancestor, @Nullable Component descendant) {
        if (ancestor == null) {
            LaterInvocator.$$$reportNull$$$0(22);
        }
        while (descendant != null) {
            if (descendant == ancestor) {
                return true;
            }
            descendant = descendant.getParent();
        }
        return false;
    }

    static boolean isFlushNow(@NotNull Runnable runnable) {
        if (runnable == null) {
            LaterInvocator.$$$reportNull$$$0(23);
        }
        return ourEdtQueue.isFlushNow(runnable);
    }

    public static void pollWriteThreadEventsOnce() {
        LOG.assertTrue(!SwingUtilities.isEventDispatchThread());
        LOG.assertTrue(ApplicationManager.getApplication().isWriteIntentLockAcquired());
    }

    @TestOnly
    @NotNull
    public static Object getLaterInvocatorEdtQueue() {
        Object object = ourEdtQueue.getQueue();
        if (object == null) {
            LaterInvocator.$$$reportNull$$$0(24);
        }
        return object;
    }

    private static void reincludeSkippedItemsAndRequestFlush() {
        ThreadingAssertions.assertEventDispatchThread();
        ourEdtQueue.reincludeSkippedItems();
    }

    public static void purgeExpiredItems() {
        ThreadingAssertions.assertEventDispatchThread();
        ourEdtQueue.purgeExpiredItems();
    }

    @Deprecated
    @TestOnly
    public static void dispatchPendingFlushes() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Must call from EDT");
        }
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        LaterInvocator.invokeLater(ModalityState.any(), Conditions.alwaysFalse(), semaphore::up);
        while (!semaphore.isUp()) {
            EDT.dispatchAllInvocationEvents();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 24: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/LaterInvocator";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expired";
                break;
            }
            case 7: 
            case 9: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 10: 
            case 11: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalEntity";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendedState";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/LaterInvocator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "modalityStateForWindow";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentModalEntities";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentModalityState";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLaterInvocatorEdtQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addModalityStateListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "modalityStateForWindow";
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 24: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isModalDialog";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWait";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "enterModal";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "markTransparent";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "leaveModal";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeModality";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isInModalContext";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isFlushNow";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 19: 
            case 20: 
            case 24: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

