/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionProcessingHelper;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JR\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u0002H\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u00060\u0004\"\b\b\u0000\u0010\u0005*\u00020\u0001\"\b\b\u0001\u0010\u0007*\u00020\u00012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u0002H\u0007\u0012\u0006\u0012\u0004\u0018\u0001H\u00050\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000bH\u0002Jf\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\r0\u0004\"\b\b\u0000\u0010\u0005*\u00020\u0001\"\b\b\u0001\u0010\u0007*\u00020\u0001\"\u0004\b\u0002\u0010\r2\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u0002H\u0007\u0012\u0006\u0012\u0004\u0018\u0001H\u00050\t2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\r0\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000bH\u0002Ja\u0010\u000f\u001a\u0002H\r\"\b\b\u0000\u0010\u0005*\u00020\u0001\"\b\b\u0001\u0010\u0007*\u00020\u0001\"\b\b\u0002\u0010\r*\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u00102\u0006\u0010\u0011\u001a\u0002H\u00052\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\r0\tH\u0007\u00a2\u0006\u0002\u0010\u0015JI\u0010\u000f\u001a\u0002H\r\"\b\b\u0000\u0010\u0007*\u00020\u0001\"\b\b\u0001\u0010\r*\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u00102\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\r0\u0016H\u0007\u00a2\u0006\u0002\u0010\u0017JC\u0010\u0018\u001a\u0004\u0018\u0001H\u0019\"\b\b\u0000\u0010\u0007*\u00020\u0001\"\u0004\b\u0001\u0010\u00192\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u0002H\u0007\u0012\u0006\b\u0001\u0012\u0002H\u00190\t2\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00070\u001c\u00a2\u0006\u0002\u0010\u001dJ\u009d\u0001\u0010\u001e\u001a\u0004\u0018\u0001H\r\"\b\b\u0000\u0010\u001f*\u00020\u0001\"\b\b\u0001\u0010\u0005*\u00020\u0001\"\b\b\u0002\u0010\u0007*\u00020\u0001\"\u0004\b\u0003\u0010\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000b2\u0006\u0010\u0012\u001a\u0002H\u001f2\u0006\u0010\u0011\u001a\u0002H\u00052\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u0002H\u0007\u0012\u0006\u0012\u0004\u0018\u0001H\u00050\t2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\r0\t2 \u0010 \u001a\u001c\u0012\u0004\u0012\u0002H\u001f\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u0002H\u0005\u0012\u0006\u0012\u0004\u0018\u0001H\r0\u00040!H\u0002\u00a2\u0006\u0002\u0010\"J3\u0010#\u001a\u0004\u0018\u0001H\u0007\"\u0004\b\u0000\u0010\u00072\u000e\u0010$\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u00070%2\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00070\u001c\u00a2\u0006\u0002\u0010&J3\u0010'\u001a\u00020(\"\b\b\u0000\u0010\u0007*\u00020\u00012\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00070\u001c2\u0011\u0010)\u001a\r\u0012\t\u0012\u0007H\u0007\u00a2\u0006\u0002\b+0*J]\u0010,\u001a\b\u0012\u0004\u0012\u0002H\u00070-\"\b\b\u0000\u0010\u0005*\u00020\u0001\"\b\b\u0001\u0010\u0007*\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u00102\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0011\u001a\u0002H\u00052\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u0002H\u0007\u0012\u0006\u0012\u0004\u0018\u0001H\u00050\t\u00a2\u0006\u0002\u0010.J[\u0010/\u001a\u0004\u0018\u0001H\u0007\"\b\b\u0000\u0010\u0005*\u00020\u0001\"\b\b\u0001\u0010\u0007*\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u00102\u0006\u0010\u0011\u001a\u0002H\u00052\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u0002H\u0007\u0012\u0006\u0012\u0004\u0018\u0001H\u00050\tH\u0007\u00a2\u0006\u0002\u0010\u0015Ju\u0010/\u001a\u0004\u0018\u0001H\r\"\b\b\u0000\u0010\u0005*\u00020\u0001\"\b\b\u0001\u0010\u0007*\u00020\u0001\"\u0004\b\u0002\u0010\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u00102\u0006\u0010\u0011\u001a\u0002H\u00052\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u0002H\u0007\u0012\u0006\u0012\u0004\u0018\u0001H\u00050\t2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\r0\tH\u0007\u00a2\u0006\u0002\u00100\u00a8\u00061"}, d2={"Lcom/intellij/openapi/extensions/impl/ExtensionProcessingHelper;", "", "()V", "buildCacheForGroupingKeyMapper", "", "K", "", "T", "keyMapper", "Ljava/util/function/Function;", "point", "Lcom/intellij/openapi/extensions/ExtensionPoint;", "buildCacheForKeyMapper", "V", "valueMapper", "computeIfAbsent", "Lcom/intellij/openapi/extensions/impl/ExtensionPointImpl;", "key", "cacheId", "Ljava/lang/Class;", "valueProducer", "(Lcom/intellij/openapi/extensions/impl/ExtensionPointImpl;Ljava/lang/Object;Ljava/lang/Class;Ljava/util/function/Function;)Ljava/lang/Object;", "Ljava/util/function/Supplier;", "(Lcom/intellij/openapi/extensions/impl/ExtensionPointImpl;Ljava/lang/Class;Ljava/util/function/Supplier;)Ljava/lang/Object;", "computeSafeIfAny", "R", "processor", "iterable", "", "(Ljava/util/function/Function;Ljava/lang/Iterable;)Ljava/lang/Object;", "doGetByKey", "CACHE_KEY", "keyMapperToCache", "Ljava/util/concurrent/ConcurrentMap;", "(Lcom/intellij/openapi/extensions/ExtensionPoint;Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/Function;Ljava/util/function/Function;Ljava/util/concurrent/ConcurrentMap;)Ljava/lang/Object;", "findFirstSafe", "predicate", "Ljava/util/function/Predicate;", "(Ljava/util/function/Predicate;Ljava/lang/Iterable;)Ljava/lang/Object;", "forEachExtensionSafe", "", "extensionConsumer", "Ljava/util/function/Consumer;", "Lorg/jetbrains/annotations/NotNull;", "getByGroupingKey", "", "(Lcom/intellij/openapi/extensions/impl/ExtensionPointImpl;Ljava/lang/Class;Ljava/lang/Object;Ljava/util/function/Function;)Ljava/util/List;", "getByKey", "(Lcom/intellij/openapi/extensions/impl/ExtensionPointImpl;Ljava/lang/Object;Ljava/lang/Class;Ljava/util/function/Function;Ljava/util/function/Function;)Ljava/lang/Object;", "intellij.platform.extensions"})
@ApiStatus.Internal
public final class ExtensionProcessingHelper {
    @NotNull
    public static final ExtensionProcessingHelper INSTANCE = new ExtensionProcessingHelper();

    private ExtensionProcessingHelper() {
    }

    public final <T> void forEachExtensionSafe(@NotNull Iterable<? extends T> iterable, @NotNull Consumer<T> extensionConsumer) {
        Intrinsics.checkNotNullParameter(iterable, "iterable");
        Intrinsics.checkNotNullParameter(extensionConsumer, "extensionConsumer");
        for (T t2 : iterable) {
            if (t2 == null) break;
            try {
                extensionConsumer.accept(t2);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Throwable e) {
                ExtensionPointImpl.LOG.error(e);
            }
        }
    }

    @Nullable
    public final <T> T findFirstSafe(@NotNull Predicate<? super T> predicate, @NotNull Iterable<? extends T> iterable) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        Intrinsics.checkNotNullParameter(iterable, "iterable");
        return (T)this.computeSafeIfAny(arg_0 -> ExtensionProcessingHelper.findFirstSafe$lambda$0(predicate, arg_0), iterable);
    }

    @Nullable
    public final <T, R> R computeSafeIfAny(@NotNull Function<T, ? extends R> processor, @NotNull Iterable<? extends T> iterable) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        Intrinsics.checkNotNullParameter(iterable, "iterable");
        for (T t2 : iterable) {
            if (t2 == null) {
                return null;
            }
            try {
                R r = processor.apply(t2);
                if (r == null) continue;
                R it = r;
                boolean bl = false;
                return it;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Throwable e) {
                ExtensionPointImpl.LOG.error(e);
            }
        }
        return null;
    }

    @NotNull
    public final <K, T> List<T> getByGroupingKey(@NotNull ExtensionPointImpl<T> point, @NotNull Class<?> cacheId, @NotNull K key, @NotNull Function<T, K> keyMapper) {
        List list;
        Map<K, List<T>> prev;
        Intrinsics.checkNotNullParameter(point, "point");
        Intrinsics.checkNotNullParameter(cacheId, "cacheId");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(keyMapper, "keyMapper");
        ConcurrentMap concurrentMap = point.getCacheMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "getCacheMap(...)");
        ConcurrentMap keyMapperToCache = concurrentMap;
        Map<K, List<T>> cache2 = (Map<K, List<T>>)keyMapperToCache.get(cacheId);
        if (cache2 == null && (prev = keyMapperToCache.putIfAbsent(cacheId, cache2 = this.buildCacheForGroupingKeyMapper(keyMapper, point))) != null) {
            cache2 = prev;
        }
        if ((list = (List)cache2.get(key)) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @ApiStatus.Internal
    @Nullable
    public final <K, T, V> V getByKey(@NotNull ExtensionPointImpl<T> point, @NotNull K key, @NotNull Class<?> cacheId, @NotNull Function<T, K> keyMapper, @NotNull Function<T, V> valueMapper) {
        Intrinsics.checkNotNullParameter(point, "point");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(cacheId, "cacheId");
        Intrinsics.checkNotNullParameter(keyMapper, "keyMapper");
        Intrinsics.checkNotNullParameter(valueMapper, "valueMapper");
        ExtensionPoint extensionPoint = point;
        ConcurrentMap concurrentMap = point.getCacheMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "getCacheMap(...)");
        return this.doGetByKey(extensionPoint, cacheId, key, keyMapper, valueMapper, concurrentMap);
    }

    @ApiStatus.Internal
    @Nullable
    public final <K, T> T getByKey(@NotNull ExtensionPointImpl<T> point, @NotNull K key, @NotNull Class<?> cacheId, @NotNull Function<T, K> keyMapper) {
        Intrinsics.checkNotNullParameter(point, "point");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(cacheId, "cacheId");
        Intrinsics.checkNotNullParameter(keyMapper, "keyMapper");
        ExtensionPoint extensionPoint = point;
        Function function = Function.identity();
        Intrinsics.checkNotNullExpressionValue(function, "identity(...)");
        ConcurrentMap concurrentMap = point.getCacheMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "getCacheMap(...)");
        return this.doGetByKey(extensionPoint, cacheId, key, keyMapper, function, concurrentMap);
    }

    @ApiStatus.Internal
    @NotNull
    public final <K, T, V> V computeIfAbsent(@NotNull ExtensionPointImpl<T> point, @NotNull K key, @NotNull Class<?> cacheId, @NotNull Function<K, V> valueProducer) {
        Intrinsics.checkNotNullParameter(point, "point");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(cacheId, "cacheId");
        Intrinsics.checkNotNullParameter(valueProducer, "valueProducer");
        ConcurrentMap concurrentMap = point.getCacheMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "getCacheMap(...)");
        ConcurrentMap cache2 = concurrentMap;
        Object object = cache2.computeIfAbsent(new AbstractMap.SimpleImmutableEntry(key, cacheId), arg_0 -> ExtensionProcessingHelper.computeIfAbsent$lambda$2(new Function1<AbstractMap.SimpleImmutableEntry<K, Class<?>>, V>(valueProducer){
            final /* synthetic */ Function<K, V> $valueProducer;
            {
                this.$valueProducer = $valueProducer;
                super(1);
            }

            public final V invoke(@NotNull AbstractMap.SimpleImmutableEntry<K, Class<?>> simpleImmutableEntry) {
                Intrinsics.checkNotNullParameter(simpleImmutableEntry, "<name for destructuring parameter 0>");
                K key1 = ((Map.Entry)simpleImmutableEntry).getKey();
                return this.$valueProducer.apply(key1);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(object, "computeIfAbsent(...)");
        return (V)object;
    }

    @ApiStatus.Internal
    @NotNull
    public final <T, V> V computeIfAbsent(@NotNull ExtensionPointImpl<T> point, @NotNull Class<?> cacheId, @NotNull Supplier<V> valueProducer) {
        Intrinsics.checkNotNullParameter(point, "point");
        Intrinsics.checkNotNullParameter(cacheId, "cacheId");
        Intrinsics.checkNotNullParameter(valueProducer, "valueProducer");
        ConcurrentMap concurrentMap = point.getCacheMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "getCacheMap(...)");
        ConcurrentMap cache2 = concurrentMap;
        Object object = cache2.computeIfAbsent(cacheId, arg_0 -> ExtensionProcessingHelper.computeIfAbsent$lambda$3(new Function1<Class<?>, V>(valueProducer){
            final /* synthetic */ Supplier<V> $valueProducer;
            {
                this.$valueProducer = $valueProducer;
                super(1);
            }

            public final V invoke(Class<?> it) {
                return this.$valueProducer.get();
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(object, "computeIfAbsent(...)");
        return (V)object;
    }

    private final <CACHE_KEY, K, T, V> V doGetByKey(ExtensionPoint<T> point, CACHE_KEY cacheId, K key, Function<T, K> keyMapper, Function<T, V> valueMapper, ConcurrentMap<CACHE_KEY, Map<K, V>> keyMapperToCache) {
        Map<K, V> prev;
        Map<K, V> cache2 = (Map<K, V>)keyMapperToCache.get(cacheId);
        if (cache2 == null && (prev = keyMapperToCache.putIfAbsent(cacheId, cache2 = this.buildCacheForKeyMapper(keyMapper, valueMapper, point))) != null) {
            cache2 = prev;
        }
        return cache2.get(key);
    }

    private final <K, T> Map<K, List<T>> buildCacheForGroupingKeyMapper(Function<T, K> keyMapper, ExtensionPoint<T> point) {
        HashMap<Object, List> cache2 = new HashMap<Object, List>();
        for (T extension : point.getExtensionList()) {
            K key;
            if (keyMapper.apply(extension) == null) continue;
            Intrinsics.checkNotNull(extension);
            cache2.computeIfAbsent(key, arg_0 -> ExtensionProcessingHelper.buildCacheForGroupingKeyMapper$lambda$4(buildCacheForGroupingKeyMapper.1.INSTANCE, arg_0)).add(extension);
        }
        return cache2;
    }

    private final <K, T, V> Map<K, V> buildCacheForKeyMapper(Function<T, K> keyMapper, Function<T, V> valueMapper, ExtensionPoint<T> point) {
        List<T> list = point.getExtensionList();
        Intrinsics.checkNotNullExpressionValue(list, "getExtensionList(...)");
        List<T> extensions = list;
        HashMap<K, V> cache2 = new HashMap<K, V>(extensions.size());
        for (T extension : extensions) {
            V value;
            K key;
            if (keyMapper.apply(extension) == null || valueMapper.apply(extension) == null) continue;
            cache2.put(key, value);
        }
        return cache2;
    }

    private static final Object findFirstSafe$lambda$0(Predicate $predicate, Object it) {
        Intrinsics.checkNotNullParameter($predicate, "$predicate");
        Intrinsics.checkNotNullParameter(it, "it");
        return $predicate.test(it) ? it : null;
    }

    private static final Object computeIfAbsent$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return $tmp0.invoke(p0);
    }

    private static final Object computeIfAbsent$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return $tmp0.invoke(p0);
    }

    private static final List buildCacheForGroupingKeyMapper$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (List)$tmp0.invoke(p0);
    }
}

