/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.progress.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.util.progress.impl.FractionState;
import com.intellij.platform.util.progress.impl.TextDetails;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0017\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0000\u00a2\u0006\u0002\u0010\t\u001a0\u0010\n\u001a\u000f\u0018\u00010\u000bj\u0004\u0018\u0001`\f\u00a2\u0006\u0002\b\r2\u0019\u0010\u000e\u001a\u0015\u0012\u0011\u0012\u000f\u0018\u00010\u000bj\u0004\u0018\u0001`\f\u00a2\u0006\u0002\b\r0\u000fH\u0000\u001a\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00110\u000fH\u0000\u001a\"\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00012\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0015H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005*\u0016\b\u0000\u0010\u0017\"\u00070\u000b\u00a2\u0006\u0002\b\r2\u00070\u000b\u00a2\u0006\u0002\b\r\u00a8\u0006\u0018"}, d2={"ACCEPTABLE_FRACTION_OVERFLOW", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "checkFraction", "", "fraction", "(Ljava/lang/Double;)Z", "reduceText", "", "Lcom/intellij/platform/util/progress/impl/ProgressText;", "Lcom/intellij/openapi/util/NlsContexts$ProgressText;", "states", "", "reduceTextDetails", "Lcom/intellij/platform/util/progress/impl/TextDetails;", "totalFraction", "completed", "updates", "", "Lcom/intellij/platform/util/progress/impl/FractionState;", "ProgressText", "intellij.platform.util.progress"})
@SourceDebugExtension(value={"SMAP\ncommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 common.kt\ncom/intellij/platform/util/progress/impl/CommonKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1726#2,3:55\n288#2,2:59\n288#2,2:61\n1#3:58\n*S KotlinDebug\n*F\n+ 1 common.kt\ncom/intellij/platform/util/progress/impl/CommonKt\n*L\n14#1:55,3\n38#1:59,2\n39#1:61,2\n*E\n"})
public final class CommonKt {
    @NotNull
    private static final Logger LOG;
    public static final double ACCEPTABLE_FRACTION_OVERFLOW = 4.656612875245797E-10;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    /*
     * WARNING - void declaration
     */
    public static final double totalFraction(double completed, @NotNull Iterable<? extends FractionState<?>> updates) {
        double d;
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter(updates, "updates");
            Iterable<FractionState<?>> $this$all$iv = updates;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator<FractionState<?>> iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    FractionState<?> element$iv;
                    FractionState<?> it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (it.getFraction() < 0.0) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            d = completed == 0.0 ? -1.0 : completed;
        } else {
            double d2;
            Iterable<FractionState<?>> iterable = updates;
            double d3 = completed;
            double d4 = 0.0;
            Iterator<FractionState<?>> iterator3 = iterable.iterator();
            while (iterator3.hasNext()) {
                void it;
                FractionState<?> fractionState;
                FractionState<?> bl2 = fractionState = iterator3.next();
                d2 = d4;
                boolean bl3 = false;
                double d5 = RangesKt.coerceAtLeast(it.getFraction(), 0.0);
                d4 = d2 + d5;
            }
            d2 = d4;
            d = d3 + d2;
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String reduceText(@NotNull List<String> states) {
        String string2;
        block1: {
            Intrinsics.checkNotNullParameter(states, "states");
            for (String it : (Iterable)states) {
                void var2_2;
                boolean bl = false;
                if (var2_2 == null) continue;
                string2 = var2_2;
                break block1;
            }
            string2 = null;
        }
        return string2;
    }

    @Nullable
    public static final TextDetails reduceTextDetails(@NotNull List<TextDetails> states) {
        TextDetails textDetails;
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter(states, "states");
            Iterable $this$firstOrNull$iv = states;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TextDetails it = (TextDetails)element$iv;
                boolean bl = false;
                if (!(it.getText() != null)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        if ((textDetails = (TextDetails)v0) == null) {
            Object v2;
            block5: {
                Iterable $this$firstOrNull$iv = states;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    TextDetails it = (TextDetails)element$iv;
                    boolean bl = false;
                    if (!(it.getDetails() != null)) continue;
                    v2 = element$iv;
                    break block5;
                }
                v2 = null;
            }
            if ((textDetails = (TextDetails)v2) == null) {
                textDetails = CollectionsKt.firstOrNull(states);
            }
        }
        return textDetails;
    }

    public static final boolean checkFraction(@Nullable Double fraction) {
        if (fraction == null || RangesKt.rangeTo(0.0, 1.0).contains((Double)((Comparable)fraction))) {
            return true;
        }
        LOG.error(new IllegalArgumentException("Fraction is expected to be `null` or a value in [0.0; 1.0], got " + fraction));
        return false;
    }

    static {
        Logger logger = Logger.getInstance("#com.intellij.openapi.progress.impl");
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        LOG = logger;
    }
}

