/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.JavaVarTypeUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.PatternCandidateInfo;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PatternInference {
    @NotNull
    public static CandidateInfo inferPatternGenerics(@NotNull CandidateInfo resolveResult, @NotNull PsiDeconstructionPattern pattern, @NotNull PsiClass recordClass, @Nullable PsiType type) {
        if (resolveResult == null) {
            PatternInference.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            PatternInference.$$$reportNull$$$0(1);
        }
        if (recordClass == null) {
            PatternInference.$$$reportNull$$$0(2);
        }
        if (type == null) {
            CandidateInfo candidateInfo = resolveResult;
            if (candidateInfo == null) {
                PatternInference.$$$reportNull$$$0(3);
            }
            return candidateInfo;
        }
        type = JavaVarTypeUtil.getUpwardProjection(type);
        Project project = recordClass.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
        PsiClassType recordRawType = factory.createType(recordClass);
        if (!recordRawType.isConvertibleFrom(type) || JavaGenericsUtil.isUncheckedCast(recordRawType, type)) {
            CandidateInfo candidateInfo = resolveResult;
            if (candidateInfo == null) {
                PatternInference.$$$reportNull$$$0(4);
            }
            return candidateInfo;
        }
        PsiTypeParameter[] parameters = recordClass.getTypeParameters();
        InferenceSession session = new InferenceSession(parameters, PsiSubstitutor.EMPTY, PsiManagerEx.getInstanceEx(project), pattern);
        if (!PatternInference.addConstraints(recordClass, type, factory, session)) {
            CandidateInfo candidateInfo = resolveResult;
            if (candidateInfo == null) {
                PatternInference.$$$reportNull$$$0(5);
            }
            return candidateInfo;
        }
        PsiSubstitutor substitutor = session.infer();
        return new PatternCandidateInfo(resolveResult, substitutor, ContainerUtil.getFirstItem(session.getIncompatibleErrorMessages()));
    }

    private static boolean addConstraints(@NotNull PsiClass recordClass, @NotNull PsiType type, PsiElementFactory factory, InferenceSession session) {
        if (recordClass == null) {
            PatternInference.$$$reportNull$$$0(6);
        }
        if (type == null) {
            PatternInference.$$$reportNull$$$0(7);
        }
        if (type instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            PsiClassType.ClassResolveResult result2 = classType.resolveGenerics();
            PsiClass gClass = result2.getElement();
            if (gClass == null) {
                return false;
            }
            ArrayList<PsiTypeParameter> wildcardTypeParams = new ArrayList<PsiTypeParameter>();
            ArrayList<PsiWildcardType> wildcardTypes = new ArrayList<PsiWildcardType>();
            PsiType[] arguments = classType.getParameters();
            PsiTypeParameter[] parameters = gClass.getTypeParameters();
            for (int i = 0; i < arguments.length; ++i) {
                PsiType argument = arguments[i];
                if (!(argument instanceof PsiWildcardType) || i >= parameters.length) continue;
                wildcardTypeParams.add(parameters[i]);
                wildcardTypes.add((PsiWildcardType)argument);
            }
            if (!wildcardTypeParams.isEmpty()) {
                InferenceVariable[] variables = session.initOrReuseVariables(session.getContext(), wildcardTypeParams.toArray(PsiTypeParameter.EMPTY_ARRAY));
                PsiSubstitutor newSubstitutor = result2.getSubstitutor();
                for (int i = 0; i < variables.length; ++i) {
                    PsiWildcardType wildcardType = (PsiWildcardType)wildcardTypes.get(i);
                    if (wildcardType.isExtends()) {
                        variables[i].addBound(wildcardType.getExtendsBound(), InferenceBound.UPPER, null);
                    } else if (wildcardType.isSuper()) {
                        variables[i].addBound(wildcardType.getExtendsBound(), InferenceBound.LOWER, null);
                    }
                    newSubstitutor = newSubstitutor.put((PsiTypeParameter)wildcardTypeParams.get(i), factory.createType(variables[i]));
                }
                type = factory.createType(gClass, newSubstitutor);
            }
            if (gClass instanceof PsiTypeParameter) {
                for (PsiClassType upperBound : gClass.getExtendsListTypes()) {
                    if (PatternInference.addConstraints(recordClass, upperBound, factory, session)) continue;
                    return false;
                }
            } else if (InheritanceUtil.isInheritorOrSelf(recordClass, gClass, true)) {
                PsiClassType rAType = factory.createType(recordClass, session.getInferenceSubstitution());
                PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(gClass, rAType);
                PsiClassType recordPrimeType = factory.createType(gClass, superClassSubstitutor);
                session.addConstraint(new TypeEqualityConstraint(type, recordPrimeType));
            }
        }
        if (type instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)type).getConjuncts()) {
                if (PatternInference.addConstraints(recordClass, conjunct, factory, session)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/graphInference/PatternInference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/graphInference/PatternInference";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "inferPatternGenerics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "inferPatternGenerics";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addConstraints";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

