/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.dev.mmapped;

import com.intellij.util.io.IOUtil;
import com.intellij.util.io.dev.StorageFactory;
import com.intellij.util.io.dev.mmapped.MMappedFileStorage;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class MMappedFileStorageFactory
implements StorageFactory<MMappedFileStorage> {
    public static final int DEFAULT_PAGE_SIZE = 0x100000;
    private final int pageSize;
    private final boolean expandFileIfNotPageAligned;

    public static MMappedFileStorageFactory withDefaults() {
        return new MMappedFileStorageFactory(0x100000, false);
    }

    private MMappedFileStorageFactory(int pageSize, boolean expandFileIfNotPageAligned) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pageSize(=" + pageSize + ") must be >0");
        }
        if (Integer.bitCount(pageSize) != 1) {
            throw new IllegalArgumentException("pageSize(=" + pageSize + ") must be a power of 2");
        }
        this.pageSize = pageSize;
        this.expandFileIfNotPageAligned = expandFileIfNotPageAligned;
    }

    public MMappedFileStorageFactory pageSize(int pageSize) {
        return new MMappedFileStorageFactory(pageSize, false);
    }

    public MMappedFileStorageFactory expandFileIfNotPageAligned(boolean expand) {
        return new MMappedFileStorageFactory(this.pageSize, expand);
    }

    @Override
    @NotNull
    public MMappedFileStorage open(@NotNull Path storagePath) throws IOException {
        long fileSize;
        if (storagePath == null) {
            MMappedFileStorageFactory.$$$reportNull$$$0(0);
        }
        long l = fileSize = Files.exists(storagePath, new LinkOption[0]) ? Files.size(storagePath) : 0L;
        if (fileSize % (long)this.pageSize != 0L) {
            if (!this.expandFileIfNotPageAligned) {
                throw new IOException("[" + storagePath + "]: fileSize(=" + fileSize + " b) is not page(=" + this.pageSize + " b)-aligned");
            }
            long fileSizeRoundedUpToPageSize = fileSize / (long)this.pageSize + 1L;
            try (FileChannel channel = FileChannel.open(storagePath, StandardOpenOption.WRITE);){
                IOUtil.allocateFileRegion(channel, fileSizeRoundedUpToPageSize);
            }
        }
        return new MMappedFileStorage(storagePath, this.pageSize);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storagePath", "com/intellij/util/io/dev/mmapped/MMappedFileStorageFactory", "open"));
    }
}

