/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.BasicAutomata;
import dk.brics.automaton.BasicOperations;
import dk.brics.automaton.MinimizationOperations;
import dk.brics.automaton.ShuffleOperations;
import dk.brics.automaton.SpecialOperations;
import dk.brics.automaton.State;
import dk.brics.automaton.StatePair;
import dk.brics.automaton.Transition;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Automaton
implements Serializable,
Cloneable {
    static final long serialVersionUID = 10001L;
    public static final int MINIMIZE_HUFFMAN = 0;
    public static final int MINIMIZE_BRZOZOWSKI = 1;
    public static final int MINIMIZE_HOPCROFT = 2;
    public static final int MINIMIZE_VALMARI = 3;
    static int minimization = 2;
    State initial = new State();
    boolean deterministic = true;
    transient Object info;
    int hash_code;
    String singleton = null;
    static boolean minimize_always = false;
    static boolean allow_mutation = false;
    static Boolean is_debug = null;

    boolean isDebug() {
        if (is_debug == null) {
            is_debug = System.getProperty("dk.brics.automaton.debug") != null;
        }
        return is_debug;
    }

    public static void setMinimization(int algorithm) {
        minimization = algorithm;
    }

    public static void setMinimizeAlways(boolean flag2) {
        minimize_always = flag2;
    }

    public static boolean setAllowMutate(boolean flag2) {
        boolean b = allow_mutation;
        allow_mutation = flag2;
        return b;
    }

    static boolean getAllowMutate() {
        return allow_mutation;
    }

    void checkMinimizeAlways() {
        if (minimize_always) {
            this.minimize();
        }
    }

    boolean isSingleton() {
        return this.singleton != null;
    }

    public String getSingleton() {
        return this.singleton;
    }

    public void setInitialState(State s2) {
        this.initial = s2;
        this.singleton = null;
    }

    public State getInitialState() {
        this.expandSingleton();
        return this.initial;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public void setDeterministic(boolean deterministic) {
        this.deterministic = deterministic;
    }

    public void setInfo(Object info) {
        this.info = info;
    }

    public Object getInfo() {
        return this.info;
    }

    public Set<State> getStates() {
        this.expandSingleton();
        HashSet visited = this.isDebug() ? new LinkedHashSet() : new HashSet();
        LinkedList<State> worklist = new LinkedList<State>();
        worklist.add(this.initial);
        visited.add(this.initial);
        while (worklist.size() > 0) {
            State s2 = (State)worklist.removeFirst();
            Collection<Transition> tr = this.isDebug() ? s2.getSortedTransitions(false) : s2.transitions;
            for (Transition t2 : tr) {
                if (visited.contains(t2.to)) continue;
                visited.add(t2.to);
                worklist.add(t2.to);
            }
        }
        return visited;
    }

    public Set<State> getAcceptStates() {
        this.expandSingleton();
        HashSet<State> accepts = new HashSet<State>();
        HashSet<State> visited = new HashSet<State>();
        LinkedList<State> worklist = new LinkedList<State>();
        worklist.add(this.initial);
        visited.add(this.initial);
        while (worklist.size() > 0) {
            State s2 = (State)worklist.removeFirst();
            if (s2.accept) {
                accepts.add(s2);
            }
            for (Transition t2 : s2.transitions) {
                if (visited.contains(t2.to)) continue;
                visited.add(t2.to);
                worklist.add(t2.to);
            }
        }
        return accepts;
    }

    static void setStateNumbers(Set<State> states) {
        if (states.size() == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("number of states exceeded Integer.MAX_VALUE");
        }
        int number = 0;
        for (State s2 : states) {
            s2.number = number++;
        }
    }

    void totalize() {
        State s2 = new State();
        s2.transitions.add(new Transition('\u0000', '\uffff', s2));
        for (State p : this.getStates()) {
            int maxi = 0;
            for (Transition t2 : p.getSortedTransitions(false)) {
                if (t2.min > maxi) {
                    p.transitions.add(new Transition((char)maxi, (char)(t2.min - '\u0001'), s2));
                }
                if (t2.max + '\u0001' <= maxi) continue;
                maxi = t2.max + '\u0001';
            }
            if (maxi > 65535) continue;
            p.transitions.add(new Transition((char)maxi, '\uffff', s2));
        }
    }

    public void restoreInvariant() {
        this.removeDeadTransitions();
    }

    public void reduce() {
        if (this.isSingleton()) {
            return;
        }
        Set<State> states = this.getStates();
        Automaton.setStateNumbers(states);
        for (State s2 : states) {
            List<Transition> st = s2.getSortedTransitions(true);
            s2.resetTransitions();
            State p = null;
            int min2 = -1;
            char c = '\uffffffff';
            for (Transition t2 : st) {
                if (p == t2.to) {
                    if (t2.min <= c + 1) {
                        if (t2.max <= c) continue;
                        c = t2.max;
                        continue;
                    }
                    if (p != null) {
                        s2.transitions.add(new Transition((char)min2, c, p));
                    }
                    min2 = t2.min;
                    c = t2.max;
                    continue;
                }
                if (p != null) {
                    s2.transitions.add(new Transition((char)min2, c, p));
                }
                p = t2.to;
                min2 = t2.min;
                c = t2.max;
            }
            if (p == null) continue;
            s2.transitions.add(new Transition((char)min2, c, p));
        }
        this.clearHashCode();
    }

    char[] getStartPoints() {
        HashSet<Character> pointset = new HashSet<Character>();
        pointset.add(Character.valueOf('\u0000'));
        for (State s2 : this.getStates()) {
            for (Transition t2 : s2.transitions) {
                pointset.add(Character.valueOf(t2.min));
                if (t2.max >= '\uffff') continue;
                pointset.add(Character.valueOf((char)(t2.max + '\u0001')));
            }
        }
        char[] points = new char[pointset.size()];
        int n = 0;
        for (Character m4 : pointset) {
            points[n++] = m4.charValue();
        }
        Arrays.sort(points);
        return points;
    }

    public Set<State> getLiveStates() {
        this.expandSingleton();
        return this.getLiveStates(this.getStates());
    }

    private Set<State> getLiveStates(Set<State> states) {
        HashMap map2 = new HashMap();
        for (State s2 : states) {
            map2.put(s2, new HashSet());
        }
        for (State s2 : states) {
            for (Transition t2 : s2.transitions) {
                ((Set)map2.get(t2.to)).add(s2);
            }
        }
        HashSet<State> live = new HashSet<State>(this.getAcceptStates());
        LinkedList<State> worklist = new LinkedList<State>(live);
        while (worklist.size() > 0) {
            State s3 = worklist.removeFirst();
            for (State p : (Set)map2.get(s3)) {
                if (live.contains(p)) continue;
                live.add(p);
                worklist.add(p);
            }
        }
        return live;
    }

    public void removeDeadTransitions() {
        this.clearHashCode();
        if (this.isSingleton()) {
            return;
        }
        Set<State> states = this.getStates();
        Set<State> live = this.getLiveStates(states);
        for (State s2 : states) {
            Set<Transition> st = s2.transitions;
            s2.resetTransitions();
            for (Transition t2 : st) {
                if (!live.contains(t2.to)) continue;
                s2.transitions.add(t2);
            }
        }
        this.reduce();
    }

    static Transition[][] getSortedTransitions(Set<State> states) {
        Automaton.setStateNumbers(states);
        Transition[][] transitions = new Transition[states.size()][];
        for (State s2 : states) {
            transitions[s2.number] = s2.getSortedTransitionArray(false);
        }
        return transitions;
    }

    public void expandSingleton() {
        if (this.isSingleton()) {
            State p;
            this.initial = p = new State();
            for (int i = 0; i < this.singleton.length(); ++i) {
                State q = new State();
                q.number = i;
                p.transitions.add(new Transition(this.singleton.charAt(i), q));
                p = q;
            }
            p.accept = true;
            this.deterministic = true;
            this.singleton = null;
        }
    }

    public int getNumberOfStates() {
        if (this.isSingleton()) {
            return this.singleton.length() + 1;
        }
        return this.getStates().size();
    }

    public int getNumberOfTransitions() {
        if (this.isSingleton()) {
            return this.singleton.length();
        }
        int c = 0;
        for (State s2 : this.getStates()) {
            c += s2.transitions.size();
        }
        return c;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Automaton)) {
            return false;
        }
        Automaton a = (Automaton)obj;
        if (this.isSingleton() && a.isSingleton()) {
            return this.singleton.equals(a.singleton);
        }
        return this.hashCode() == a.hashCode() && this.subsetOf(a) && a.subsetOf(this);
    }

    public int hashCode() {
        if (this.hash_code == 0) {
            this.minimize();
        }
        return this.hash_code;
    }

    void recomputeHashCode() {
        this.hash_code = this.getNumberOfStates() * 3 + this.getNumberOfTransitions() * 2;
        if (this.hash_code == 0) {
            this.hash_code = 1;
        }
    }

    void clearHashCode() {
        this.hash_code = 0;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.isSingleton()) {
            b.append("singleton: ");
            for (char c : this.singleton.toCharArray()) {
                Transition.appendCharString(c, b);
            }
            b.append("\n");
        } else {
            Set<State> states = this.getStates();
            Automaton.setStateNumbers(states);
            b.append("initial state: ").append(this.initial.number).append("\n");
            for (State s2 : states) {
                b.append(s2.toString());
            }
        }
        return b.toString();
    }

    public String toDot() {
        StringBuilder b = new StringBuilder("digraph Automaton {\n");
        b.append("  rankdir = LR;\n");
        Set<State> states = this.getStates();
        Automaton.setStateNumbers(states);
        for (State s2 : states) {
            b.append("  ").append(s2.number);
            if (s2.accept) {
                b.append(" [shape=doublecircle,label=\"\"];\n");
            } else {
                b.append(" [shape=circle,label=\"\"];\n");
            }
            if (s2 == this.initial) {
                b.append("  initial [shape=plaintext,label=\"\"];\n");
                b.append("  initial -> ").append(s2.number).append("\n");
            }
            for (Transition t2 : s2.transitions) {
                b.append("  ").append(s2.number);
                t2.appendDot(b);
            }
        }
        return b.append("}\n").toString();
    }

    Automaton cloneExpanded() {
        Automaton a = this.clone();
        a.expandSingleton();
        return a;
    }

    Automaton cloneExpandedIfRequired() {
        if (allow_mutation) {
            this.expandSingleton();
            return this;
        }
        return this.cloneExpanded();
    }

    public Automaton clone() {
        try {
            Automaton a = (Automaton)super.clone();
            if (!this.isSingleton()) {
                HashMap<State, State> m4 = new HashMap<State, State>();
                Set<State> states = this.getStates();
                for (State s2 : states) {
                    m4.put(s2, new State());
                }
                for (State s2 : states) {
                    State p = (State)m4.get(s2);
                    p.accept = s2.accept;
                    if (s2 == this.initial) {
                        a.initial = p;
                    }
                    for (Transition t2 : s2.transitions) {
                        p.transitions.add(new Transition(t2.min, t2.max, (State)m4.get(t2.to)));
                    }
                }
            }
            return a;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    Automaton cloneIfRequired() {
        if (allow_mutation) {
            return this;
        }
        return this.clone();
    }

    public static Automaton load(URL url) throws IOException, ClassCastException, ClassNotFoundException {
        return Automaton.load(url.openStream());
    }

    public static Automaton load(InputStream stream) throws IOException, ClassCastException, ClassNotFoundException {
        ObjectInputStream s2 = new ObjectInputStream(stream);
        return (Automaton)s2.readObject();
    }

    public void store(OutputStream stream) throws IOException {
        ObjectOutputStream s2 = new ObjectOutputStream(stream);
        s2.writeObject(this);
        s2.flush();
    }

    public static Automaton makeEmpty() {
        return BasicAutomata.makeEmpty();
    }

    public static Automaton makeEmptyString() {
        return BasicAutomata.makeEmptyString();
    }

    public static Automaton makeAnyString() {
        return BasicAutomata.makeAnyString();
    }

    public static Automaton makeAnyChar() {
        return BasicAutomata.makeAnyChar();
    }

    public static Automaton makeChar(char c) {
        return BasicAutomata.makeChar(c);
    }

    public static Automaton makeCharRange(char min2, char max) {
        return BasicAutomata.makeCharRange(min2, max);
    }

    public static Automaton makeCharSet(String set) {
        return BasicAutomata.makeCharSet(set);
    }

    public static Automaton makeInterval(int min2, int max, int digits) throws IllegalArgumentException {
        return BasicAutomata.makeInterval(min2, max, digits);
    }

    public static Automaton makeString(String s2) {
        return BasicAutomata.makeString(s2);
    }

    public static Automaton makeStringUnion(CharSequence ... strings2) {
        return BasicAutomata.makeStringUnion(strings2);
    }

    public static Automaton makeMaxInteger(String n) {
        return BasicAutomata.makeMaxInteger(n);
    }

    public static Automaton makeMinInteger(String n) {
        return BasicAutomata.makeMinInteger(n);
    }

    public static Automaton makeTotalDigits(int i) {
        return BasicAutomata.makeTotalDigits(i);
    }

    public static Automaton makeFractionDigits(int i) {
        return BasicAutomata.makeFractionDigits(i);
    }

    public static Automaton makeIntegerValue(String value) {
        return BasicAutomata.makeIntegerValue(value);
    }

    public static Automaton makeDecimalValue(String value) {
        return BasicAutomata.makeDecimalValue(value);
    }

    public static Automaton makeStringMatcher(String s2) {
        return BasicAutomata.makeStringMatcher(s2);
    }

    public Automaton concatenate(Automaton a) {
        return BasicOperations.concatenate(this, a);
    }

    public static Automaton concatenate(List<Automaton> l) {
        return BasicOperations.concatenate(l);
    }

    public Automaton optional() {
        return BasicOperations.optional(this);
    }

    public Automaton repeat() {
        return BasicOperations.repeat(this);
    }

    public Automaton repeat(int min2) {
        return BasicOperations.repeat(this, min2);
    }

    public Automaton repeat(int min2, int max) {
        return BasicOperations.repeat(this, min2, max);
    }

    public Automaton complement() {
        return BasicOperations.complement(this);
    }

    public Automaton minus(Automaton a) {
        return BasicOperations.minus(this, a);
    }

    public Automaton intersection(Automaton a) {
        return BasicOperations.intersection(this, a);
    }

    public boolean subsetOf(Automaton a) {
        return BasicOperations.subsetOf(this, a);
    }

    public Automaton union(Automaton a) {
        return BasicOperations.union(this, a);
    }

    public static Automaton union(Collection<Automaton> l) {
        return BasicOperations.union(l);
    }

    public void determinize() {
        BasicOperations.determinize(this);
    }

    public void addEpsilons(Collection<StatePair> pairs) {
        BasicOperations.addEpsilons(this, pairs);
    }

    public boolean isEmptyString() {
        return BasicOperations.isEmptyString(this);
    }

    public boolean isEmpty() {
        return BasicOperations.isEmpty(this);
    }

    public boolean isTotal() {
        return BasicOperations.isTotal(this);
    }

    public String getShortestExample(boolean accepted) {
        return BasicOperations.getShortestExample(this, accepted);
    }

    public boolean run(String s2) {
        return BasicOperations.run(this, s2);
    }

    public void minimize() {
        MinimizationOperations.minimize(this);
    }

    public static Automaton minimize(Automaton a) {
        a.minimize();
        return a;
    }

    public Automaton overlap(Automaton a) {
        return SpecialOperations.overlap(this, a);
    }

    public Automaton singleChars() {
        return SpecialOperations.singleChars(this);
    }

    public Automaton trim(String set, char c) {
        return SpecialOperations.trim(this, set, c);
    }

    public Automaton compress(String set, char c) {
        return SpecialOperations.compress(this, set, c);
    }

    public Automaton subst(Map<Character, Set<Character>> map2) {
        return SpecialOperations.subst(this, map2);
    }

    public Automaton subst(char c, String s2) {
        return SpecialOperations.subst(this, c, s2);
    }

    public Automaton homomorph(char[] source, char[] dest) {
        return SpecialOperations.homomorph(this, source, dest);
    }

    public Automaton projectChars(Set<Character> chars) {
        return SpecialOperations.projectChars(this, chars);
    }

    public boolean isFinite() {
        return SpecialOperations.isFinite(this);
    }

    public Set<String> getStrings(int length) {
        return SpecialOperations.getStrings(this, length);
    }

    public Set<String> getFiniteStrings() {
        return SpecialOperations.getFiniteStrings(this);
    }

    public Set<String> getFiniteStrings(int limit2) {
        return SpecialOperations.getFiniteStrings(this, limit2);
    }

    public String getCommonPrefix() {
        return SpecialOperations.getCommonPrefix(this);
    }

    public void prefixClose() {
        SpecialOperations.prefixClose(this);
    }

    public static Automaton hexCases(Automaton a) {
        return SpecialOperations.hexCases(a);
    }

    public static Automaton replaceWhitespace(Automaton a) {
        return SpecialOperations.replaceWhitespace(a);
    }

    public static String shuffleSubsetOf(Collection<Automaton> ca, Automaton a, Character suspend_shuffle, Character resume_shuffle) {
        return ShuffleOperations.shuffleSubsetOf(ca, a, suspend_shuffle, resume_shuffle);
    }

    public Automaton shuffle(Automaton a) {
        return ShuffleOperations.shuffle(this, a);
    }
}

