/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.jst.cli.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.neoforged.jst.api.FileSink;

class ArchiveFileSink
implements FileSink {
    private final ZipOutputStream zout;

    public ArchiveFileSink(Path path) throws IOException {
        this.zout = new ZipOutputStream(Files.newOutputStream(path, new OpenOption[0]));
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public void putDirectory(String relativePath) throws IOException {
        if (!((String)relativePath).endsWith("/")) {
            relativePath = (String)relativePath + "/";
        }
        ZipEntry ze = new ZipEntry((String)relativePath);
        this.zout.putNextEntry(ze);
        this.zout.closeEntry();
    }

    @Override
    public void putFile(String relativePath, FileTime lastModified, byte[] content) throws IOException {
        ZipEntry ze = new ZipEntry(relativePath);
        ze.setLastModifiedTime(lastModified);
        this.zout.putNextEntry(ze);
        this.zout.write(content);
        this.zout.closeEntry();
    }

    @Override
    public void close() throws IOException {
        this.zout.close();
    }

    @Override
    public boolean canHaveMultipleEntries() {
        return true;
    }
}

