/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.srgutils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.neoforged.srgutils.IMappingBuilder;
import net.neoforged.srgutils.IMappingFile;
import net.neoforged.srgutils.INamedMappingFile;

class InternalUtils {
    private static final List<String> ORDER = Arrays.asList("PK:", "CL:", "FD:", "MD:");

    InternalUtils() {
    }

    static IMappingFile load(InputStream in) throws IOException {
        INamedMappingFile named = InternalUtils.loadNamed(in);
        return named.getMap(named.getNames().get(0), named.getNames().get(1));
    }

    static INamedMappingFile loadNamed(InputStream in) throws IOException {
        String firstLine;
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        do {
            if ((firstLine = reader.readLine()) != null) continue;
            return IMappingBuilder.create(new String[0]).build();
        } while (InternalUtils.stripComment(firstLine).isEmpty());
        String test = firstLine.split(" ")[0];
        if ("PK:".equals(test) || "CL:".equals(test) || "FD:".equals(test) || "MD:".equals(test)) {
            return InternalUtils.loadSRG(firstLine, reader).build();
        }
        if (firstLine.contains(" -> ")) {
            return InternalUtils.loadProguard(firstLine, reader).build();
        }
        if (firstLine.startsWith("v1\t")) {
            return InternalUtils.loadTinyV1(firstLine, reader).build();
        }
        if (firstLine.startsWith("tiny\t")) {
            return InternalUtils.loadTinyV2(firstLine, reader).build();
        }
        if (firstLine.startsWith("tsrg2 ")) {
            return InternalUtils.loadTSrg2(firstLine, reader).build();
        }
        ArrayList<String> list = new ArrayList<String>(Collections.singletonList(firstLine));
        list.addAll(InternalUtils.filter(InternalUtils.collectLines(reader)));
        return InternalUtils.loadSlimSRG(list).build();
    }

    private static List<String> collectLines(LineNumberReader reader) {
        return reader.lines().filter(l -> !l.isEmpty()).collect(Collectors.toList());
    }

    private static List<String> filter(List<String> lines) {
        return lines.stream().map(InternalUtils::stripComment).filter(l -> !l.isEmpty()).collect(Collectors.toList());
    }

    private static IMappingBuilder loadSRG(String firstContentLine, LineNumberReader reader) throws IOException {
        IMappingBuilder ret = IMappingBuilder.create("left", "right");
        HashMap<String, IMappingBuilder.IClass> classes = new HashMap<String, IMappingBuilder.IClass>();
        String line = firstContentLine;
        while (line != null) {
            if (InternalUtils.isEmptyOrCommentLine(line)) {
                line = reader.readLine();
                continue;
            }
            String[] pts = line.split(" ");
            switch (pts[0]) {
                case "PK:": {
                    ret.addPackage(pts[1], pts[2]);
                    break;
                }
                case "CL:": {
                    classes.put(pts[1], ret.addClass(pts[1], pts[2]));
                    break;
                }
                case "FD:": {
                    String[] right;
                    String[] left;
                    if (pts.length == 5) {
                        left = InternalUtils.rsplit(pts[1], '/', 1);
                        right = InternalUtils.rsplit(pts[3], '/', 1);
                        classes.computeIfAbsent(left[0], k -> ret.addClass(left[0], right[0])).field(left[1], right[1]).descriptor(pts[2]);
                        break;
                    }
                    left = InternalUtils.rsplit(pts[1], '/', 1);
                    right = InternalUtils.rsplit(pts[2], '/', 1);
                    classes.computeIfAbsent(left[0], k -> ret.addClass(left[0], right[0])).field(left[1], right[1]);
                    break;
                }
                case "MD:": {
                    String[] left = InternalUtils.rsplit(pts[1], '/', 1);
                    String[] right = InternalUtils.rsplit(pts[3], '/', 1);
                    classes.computeIfAbsent(left[0], k -> ret.addClass(left[0], right[0])).method(pts[2], left[1], right[1]);
                    break;
                }
                default: {
                    throw new IOException("Invalid SRG file, Unknown type: " + line);
                }
            }
            line = reader.readLine();
        }
        return ret;
    }

    private static IMappingBuilder loadProguard(String firstContentLine, LineNumberReader reader) throws IOException {
        IMappingBuilder ret = IMappingBuilder.create("left", "right");
        IMappingBuilder.IClass cls = null;
        String line = firstContentLine;
        while (line != null) {
            String[] pts;
            if (InternalUtils.isEmptyOrCommentLine(line)) {
                line = reader.readLine();
                continue;
            }
            if (!(line = line.replace('.', '/')).startsWith("    ") && line.endsWith(":")) {
                pts = line.replace('.', '/').split(" -> ");
                cls = ret.addClass(pts[0], pts[1].substring(0, pts[1].length() - 1));
            } else if (line.contains("(") && line.contains(")")) {
                if (cls == null) {
                    throw InternalUtils.proguardException("missing class", line, reader.getLineNumber());
                }
                line = line.trim();
                int start = 0;
                int end = 0;
                if (line.indexOf(58) != -1) {
                    int i = line.indexOf(58);
                    int j = line.indexOf(58, i + 1);
                    start = Integer.parseInt(line.substring(0, i));
                    end = Integer.parseInt(line.substring(i + 1, j));
                    line = line.substring(j + 1);
                }
                String obf = line.split(" -> ")[1];
                String _ret = InternalUtils.toDesc(line.split(" ")[0]);
                String name = line.substring(line.indexOf(32) + 1, line.indexOf(40));
                String[] args2 = line.substring(line.indexOf(40) + 1, line.indexOf(41)).split(",");
                StringBuffer desc = new StringBuffer();
                desc.append('(');
                for (String arg2 : args2) {
                    if (arg2.isEmpty()) break;
                    desc.append(InternalUtils.toDesc(arg2));
                }
                desc.append(')').append(_ret);
                IMappingBuilder.IMethod mtd = cls.method(desc.toString(), name, obf);
                if (start != 0) {
                    mtd.meta("start_line", Integer.toString(start));
                }
                if (end != 0) {
                    mtd.meta("end_line", Integer.toString(end));
                }
            } else {
                if (cls == null) {
                    throw InternalUtils.proguardException("missing class", line, reader.getLineNumber());
                }
                pts = line.trim().split(" ");
                cls.field(pts[1], pts[3]).descriptor(InternalUtils.toDesc(pts[0]));
            }
            line = reader.readLine();
        }
        return ret;
    }

    private static IOException proguardException(String reason, String line, int lineNum) {
        return new IOException("Invalid ProGuard line (#" + lineNum + "), " + reason + ": " + line);
    }

    private static IMappingBuilder loadSlimSRG(List<String> lines) throws IOException {
        IMappingBuilder ret = IMappingBuilder.create("left", "right");
        HashMap<String, IMappingBuilder.IClass> classes = new HashMap<String, IMappingBuilder.IClass>();
        lines.stream().filter(l -> l.charAt(0) != '\t').map(l -> l.split(" ")).filter(pts -> ((String[])pts).length == 2).forEach(pts -> {
            if (pts[0].endsWith("/")) {
                ret.addPackage(pts[0].substring(0, pts[0].length() - 1), pts[1].substring(0, pts[1].length() - 1));
            } else {
                classes.put(pts[0], ret.addClass(pts[0], pts[1]));
            }
        });
        IMappingBuilder.IClass cls = null;
        for (String line : lines) {
            String[] pts2 = line.split(" ");
            if (pts2[0].charAt(0) == '\t') {
                if (cls == null) {
                    throw new IOException("Invalid TSRG line, missing class: " + line);
                }
                pts2[0] = pts2[0].substring(1);
                if (pts2.length == 2) {
                    cls.field(pts2[0], pts2[1]);
                    continue;
                }
                if (pts2.length == 3) {
                    cls.method(pts2[1], pts2[0], pts2[2]);
                    continue;
                }
                throw new IOException("Invalid TSRG line, to many parts: " + line);
            }
            if (pts2.length == 2) {
                if (pts2[0].endsWith("/")) continue;
                cls = (IMappingBuilder.IClass)classes.get(pts2[0]);
                continue;
            }
            if (pts2.length == 3) {
                classes.computeIfAbsent(pts2[0], k -> ret.addClass((String)k, (String)k)).field(pts2[1], pts2[2]);
                continue;
            }
            if (pts2.length == 4) {
                classes.computeIfAbsent(pts2[0], k -> ret.addClass((String)k, (String)k)).method(pts2[2], pts2[1], pts2[3]);
                continue;
            }
            throw new IOException("Invalid CSRG line, to many parts: " + line);
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IMappingBuilder loadTSrg2(String headerLine, LineNumberReader reader) throws IOException {
        String[] header = headerLine.split(" ");
        if (header.length < 3) {
            throw new IOException("Invalid TSrg v2 Header: " + headerLine);
        }
        IMappingBuilder ret = IMappingBuilder.create(Arrays.copyOfRange(header, 1, header.length));
        int nameCount = header.length - 1;
        IMappingBuilder.IClass cls = null;
        IMappingBuilder.IMethod mtd = null;
        String line = reader.readLine();
        while (line != null) {
            if (!InternalUtils.isEmptyOrCommentLine(line)) {
                if (line.length() < 2) {
                    throw InternalUtils.tSrg2Exception("too short", line, reader.getLineNumber());
                }
                String[] pts = line.split(" ");
                if (line.charAt(0) != '\t') {
                    if (pts.length != nameCount) {
                        throw InternalUtils.tSrg2Exception("namespace count mismatch", line, reader.getLineNumber());
                    }
                    if (pts[0].charAt(pts[0].length() - 1) == '/') {
                        for (int x = 0; x < pts.length; ++x) {
                            pts[x] = pts[x].substring(0, pts[x].length() - 1);
                        }
                        ret.addPackage(pts);
                        cls = null;
                    } else {
                        cls = ret.addClass(pts);
                    }
                    mtd = null;
                } else if (line.charAt(1) == '\t') {
                    if (mtd == null) {
                        throw InternalUtils.tSrg2Exception("missing method", line, reader.getLineNumber());
                    }
                    pts[0] = pts[0].substring(2);
                    if (pts.length == 1 && pts[0].equals("static")) {
                        mtd.meta("is_static", "true");
                    } else {
                        if (pts.length != nameCount + 1) throw InternalUtils.tSrg2Exception("too many parts", line, reader.getLineNumber());
                        mtd.parameter(Integer.parseInt(pts[0]), Arrays.copyOfRange(pts, 1, pts.length));
                    }
                } else {
                    if (cls == null) {
                        throw InternalUtils.tSrg2Exception("missing class", line, reader.getLineNumber());
                    }
                    pts[0] = pts[0].substring(1);
                    if (pts.length == nameCount) {
                        cls.field(pts);
                    } else {
                        if (pts.length != 1 + nameCount) throw InternalUtils.tSrg2Exception("too many parts", line, reader.getLineNumber());
                        InternalUtils.swapFirst(pts);
                        if (pts[0].charAt(0) == '(') {
                            mtd = cls.method(pts[0], Arrays.copyOfRange(pts, 1, pts.length));
                        } else {
                            mtd = null;
                            cls.field(Arrays.copyOfRange(pts, 1, pts.length)).descriptor(pts[0]);
                        }
                    }
                }
            }
            line = reader.readLine();
        }
        return ret;
    }

    private static boolean isEmptyOrCommentLine(String line) {
        return line.isEmpty() || InternalUtils.stripComment(line).isEmpty();
    }

    private static IOException tSrg2Exception(String reason, String line, int lineNum) {
        return new IOException("Invalid TSRG v2 line (#" + lineNum + "), " + reason + ": " + line);
    }

    private static IMappingBuilder loadTinyV1(String headerLine, LineNumberReader reader) throws IOException {
        String[] header = headerLine.split("\t");
        if (header.length < 3) {
            throw new IOException("Invalid Tiny v1 Header: " + headerLine);
        }
        IMappingBuilder ret = IMappingBuilder.create(Arrays.copyOfRange(header, 1, header.length));
        HashMap<String, IMappingBuilder.IClass> classes = new HashMap<String, IMappingBuilder.IClass>();
        int nameCount = header.length - 1;
        String read = reader.readLine();
        while (read != null) {
            if (!InternalUtils.isEmptyOrCommentLine(read)) {
                String[] line = read.split("\t");
                switch (line[0]) {
                    case "CLASS": {
                        if (line.length != nameCount + 1) {
                            throw new IOException("Invalid Tiny v1 line: #" + reader.getLineNumber() + ": " + read);
                        }
                        classes.put(line[1], ret.addClass(Arrays.copyOfRange(line, 1, line.length)));
                        break;
                    }
                    case "FIELD": {
                        if (line.length != nameCount + 3) {
                            throw new IOException("Invalid Tiny v1 line: #" + reader.getLineNumber() + ": " + read);
                        }
                        classes.computeIfAbsent(line[1], k -> ret.addClass(InternalUtils.duplicate(k, nameCount))).field(Arrays.copyOfRange(line, 3, line.length)).descriptor(line[2]);
                        break;
                    }
                    case "METHOD": {
                        if (line.length != nameCount + 3) {
                            throw new IOException("Invalid Tiny v1 line: #" + reader.getLineNumber() + ": " + read);
                        }
                        classes.computeIfAbsent(line[1], k -> ret.addClass(InternalUtils.duplicate(k, nameCount))).method(line[2], Arrays.copyOfRange(line, 3, line.length));
                        break;
                    }
                    default: {
                        throw new IOException("Invalid Tiny v1 line: #" + reader.getLineNumber() + ": " + read);
                    }
                }
            }
            read = reader.readLine();
        }
        return ret;
    }

    private static IMappingBuilder loadTinyV2(String headerLine, LineNumberReader reader) throws IOException {
        String line;
        String[] header = headerLine.split("\t");
        if (header.length < 5) {
            throw new IOException("Invalid Tiny v2 Header: " + headerLine);
        }
        try {
            int major = Integer.parseInt(header[1]);
            int minor = Integer.parseInt(header[2]);
            if (major != 2 || minor != 0) {
                throw new IOException("Unsupported Tiny v2 version: " + headerLine);
            }
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid Tiny v2 Header: " + headerLine);
        }
        IMappingBuilder ret = IMappingBuilder.create(Arrays.copyOfRange(header, 3, header.length));
        int nameCount = header.length - 3;
        boolean escaped = false;
        HashMap<String, String> properties = new HashMap<String, String>();
        boolean doneReadingProperties = false;
        ArrayDeque<TinyV2State> stack = new ArrayDeque<TinyV2State>();
        IMappingBuilder.IClass cls = null;
        IMappingBuilder.IField field = null;
        IMappingBuilder.IMethod method = null;
        IMappingBuilder.IParameter param = null;
        while ((line = reader.readLine()) != null) {
            if (!doneReadingProperties) {
                String[] splitLine = line.split("\t");
                if (splitLine[0].isEmpty()) {
                    properties.put(splitLine[1], splitLine.length < 3 ? null : (escaped ? InternalUtils.unescapeTinyString(splitLine[2]) : splitLine[2]));
                    if (!"escaped-names".equals(splitLine[1])) continue;
                    escaped = true;
                    continue;
                }
                doneReadingProperties = true;
            }
            int newdepth = 0;
            while (line.charAt(newdepth) == '\t') {
                ++newdepth;
            }
            if (newdepth != 0) {
                line = line.substring(newdepth);
            }
            if (newdepth != stack.size()) {
                block30: while (stack.size() != newdepth) {
                    switch ((TinyV2State)((Object)stack.pop())) {
                        case CLASS: {
                            cls = null;
                            continue block30;
                        }
                        case FIELD: {
                            field = null;
                            continue block30;
                        }
                        case METHOD: {
                            method = null;
                            continue block30;
                        }
                        case PARAMETER: {
                            param = null;
                            continue block30;
                        }
                    }
                }
            }
            String[] parts = line.split("\t");
            if (escaped) {
                for (int y = 1; y < parts.length; ++y) {
                    parts[y] = InternalUtils.unescapeTinyString(parts[y]);
                }
            }
            block14 : switch (parts[0]) {
                case "c": {
                    if (stack.size() == 0) {
                        if (parts.length != nameCount + 1) {
                            throw InternalUtils.tiny2Exception(reader.getLineNumber(), line);
                        }
                        cls = ret.addClass(Arrays.copyOfRange(parts, 1, parts.length));
                        stack.push(TinyV2State.CLASS);
                        break;
                    }
                    String comment = InternalUtils.unescapeTinyString(parts[1]);
                    switch ((TinyV2State)((Object)stack.peek())) {
                        case CLASS: {
                            if (cls == null) {
                                throw InternalUtils.tiny2Exception(reader.getLineNumber(), line);
                            }
                            cls.meta("comment", comment);
                            break block14;
                        }
                        case FIELD: {
                            if (field == null) {
                                throw InternalUtils.tiny2Exception(reader.getLineNumber(), line);
                            }
                            field.meta("comment", comment);
                            break block14;
                        }
                        case METHOD: {
                            if (method == null) {
                                throw InternalUtils.tiny2Exception(reader.getLineNumber(), line);
                            }
                            method.meta("comment", comment);
                            break block14;
                        }
                        case PARAMETER: {
                            if (param == null) {
                                throw InternalUtils.tiny2Exception(reader.getLineNumber(), line);
                            }
                            param.meta("comment", comment);
                            break block14;
                        }
                    }
                    throw InternalUtils.tiny2Exception(reader.getLineNumber(), line);
                }
                case "f": {
                    if (parts.length != nameCount + 2 || stack.peek() != TinyV2State.CLASS) {
                        throw InternalUtils.tiny2Exception(reader.getLineNumber(), line);
                    }
                    field = cls.field(Arrays.copyOfRange(parts, 2, parts.length)).descriptor(parts[1]);
                    stack.push(TinyV2State.FIELD);
                    break;
                }
                case "m": {
                    if (parts.length != nameCount + 2 || stack.peek() != TinyV2State.CLASS) {
                        throw InternalUtils.tiny2Exception(reader.getLineNumber(), line);
                    }
                    method = cls.method(parts[1], Arrays.copyOfRange(parts, 2, parts.length));
                    stack.push(TinyV2State.METHOD);
                    break;
                }
                case "p": {
                    if (parts.length != nameCount + 2 || stack.peek() != TinyV2State.METHOD) {
                        throw InternalUtils.tiny2Exception(reader.getLineNumber(), line);
                    }
                    param = method.parameter(Integer.parseInt(parts[1]), Arrays.copyOfRange(parts, 2, parts.length));
                    stack.push(TinyV2State.PARAMETER);
                    break;
                }
                case "v": {
                    break;
                }
                default: {
                    throw InternalUtils.tiny2Exception(reader.getLineNumber(), line);
                }
            }
        }
        return ret;
    }

    private static IOException tiny2Exception(int line, String data) {
        return new IOException("Invalid Tiny v2 line: #" + line + ": " + data);
    }

    private static String unescapeTinyString(String value) {
        return value.replace("\\\\", "\\").replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t").replace("\\0", "\u0000");
    }

    static String escapeTinyString(String value) {
        return value.replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t").replace("\u0000", "\\0");
    }

    static String toDesc(String type) {
        if (type.endsWith("[]")) {
            return "[" + InternalUtils.toDesc(type.substring(0, type.length() - 2));
        }
        if (type.equals("int")) {
            return "I";
        }
        if (type.equals("void")) {
            return "V";
        }
        if (type.equals("boolean")) {
            return "Z";
        }
        if (type.equals("byte")) {
            return "B";
        }
        if (type.equals("char")) {
            return "C";
        }
        if (type.equals("short")) {
            return "S";
        }
        if (type.equals("double")) {
            return "D";
        }
        if (type.equals("float")) {
            return "F";
        }
        if (type.equals("long")) {
            return "J";
        }
        if (type.contains("/")) {
            return "L" + type + ";";
        }
        throw new RuntimeException("Invalid toDesc input: " + type);
    }

    static String toSource(String desc) {
        char first2 = desc.charAt(0);
        switch (first2) {
            case 'I': {
                return "int";
            }
            case 'V': {
                return "void";
            }
            case 'Z': {
                return "boolean";
            }
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'S': {
                return "short";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'J': {
                return "long";
            }
            case '[': {
                return InternalUtils.toSource(desc.substring(1)) + "[]";
            }
            case 'L': {
                return desc.substring(1, desc.length() - 1).replace('/', '.');
            }
        }
        throw new IllegalArgumentException("Unknown descriptor: " + desc);
    }

    static String toSource(String name, String desc) {
        StringBuilder buf = new StringBuilder();
        int endParams = desc.lastIndexOf(41);
        String ret = desc.substring(endParams + 1);
        buf.append(InternalUtils.toSource(ret)).append(' ').append(name).append('(');
        int idx = 1;
        while (idx < endParams) {
            int array = 0;
            char c = desc.charAt(idx);
            if (c == '[') {
                while (desc.charAt(idx) == '[') {
                    ++array;
                    ++idx;
                }
                c = desc.charAt(idx);
            }
            if (c == 'L') {
                int end = desc.indexOf(59, idx);
                buf.append(InternalUtils.toSource(desc.substring(idx, end + 1)));
                idx = end;
            } else {
                buf.append(InternalUtils.toSource(c + ""));
            }
            while (array-- > 0) {
                buf.append("[]");
            }
            if (++idx >= endParams) continue;
            buf.append(',');
        }
        buf.append(')');
        return buf.toString();
    }

    private static String[] rsplit(String str, char chr, int count2) {
        int idx;
        ArrayList<String> pts = new ArrayList<String>();
        while ((idx = str.lastIndexOf(chr)) != -1 && count2 > 0) {
            pts.add(str.substring(idx + 1));
            str = str.substring(0, idx);
            --count2;
        }
        pts.add(str);
        Collections.reverse(pts);
        return pts.toArray(new String[pts.size()]);
    }

    public static int compareLines(String o1, String o2) {
        String[] pt2;
        String[] pt1 = o1.split(" ");
        if (!pt1[0].equals((pt2 = o2.split(" "))[0])) {
            return ORDER.indexOf(pt1[0]) - ORDER.lastIndexOf(pt2[0]);
        }
        if ("PK:".equals(pt1[0])) {
            return o1.compareTo(o2);
        }
        if ("CL:".equals(pt1[0])) {
            return InternalUtils.compareCls(pt1[1], pt2[1]);
        }
        if ("FD:".equals(pt1[0]) || "MD:".equals(pt1[0])) {
            String[][] y = new String[][]{{pt1[1].substring(0, pt1[1].lastIndexOf(47)), pt1[1].substring(pt1[1].lastIndexOf(47) + 1)}, {pt2[1].substring(0, pt2[1].lastIndexOf(47)), pt2[1].substring(pt2[1].lastIndexOf(47) + 1)}};
            int ret = InternalUtils.compareCls(y[0][0], y[1][0]);
            if (ret != 0) {
                return ret;
            }
            return y[0][1].compareTo(y[1][1]);
        }
        return o1.compareTo(o2);
    }

    public static int compareCls(String cls1, String cls2) {
        if (cls1.indexOf(47) > 0 && cls2.indexOf(47) > 0) {
            return cls1.compareTo(cls2);
        }
        String[][] t2 = new String[][]{cls1.split("\\$"), cls2.split("\\$")};
        int max = Math.min(t2[0].length, t2[1].length);
        for (int i = 0; i < max; ++i) {
            if (t2[0][i].equals(t2[1][i])) continue;
            if (t2[0][i].length() != t2[1][i].length()) {
                return t2[0][i].length() - t2[1][i].length();
            }
            return t2[0][i].compareTo(t2[1][i]);
        }
        return Integer.compare(t2[0].length, t2[1].length);
    }

    public static String stripComment(String str) {
        int end;
        int idx = str.indexOf(35);
        if (idx == 0) {
            return "";
        }
        if (idx != -1) {
            str = str.substring(0, idx - 1);
        }
        for (end = str.length(); end > 1 && str.charAt(end - 1) == ' '; --end) {
        }
        return end == 0 ? "" : str.substring(0, end);
    }

    private static void swapFirst(String[] values2) {
        String tmp = values2[0];
        values2[0] = values2[1];
        values2[1] = tmp;
    }

    private static String[] duplicate(String value, int count2) {
        Object[] ret = new String[count2];
        Arrays.fill(ret, value);
        return ret;
    }

    static void writeMeta(IMappingFile.Format format, List<String> lines, Element element, Map<String, String> meta) {
        int indent = 0;
        switch (element) {
            case PACKAGE: 
            case CLASS: {
                indent = 1;
                break;
            }
            case FIELD: 
            case METHOD: {
                indent = 2;
                break;
            }
            case PARAMETER: {
                indent = 3;
            }
        }
        switch (format) {
            case CSRG: 
            case PG: 
            case SRG: 
            case TINY1: 
            case TSRG: 
            case XSRG: {
                break;
            }
            case TINY: {
                String comment = meta.get("comment");
                if (comment == null) break;
                char[] prefix = new char[indent];
                Arrays.fill(prefix, '\t');
                lines.add(new String(prefix) + "c\t" + InternalUtils.escapeTinyString(comment));
                break;
            }
            case TSRG2: {
                if (!meta.containsKey("is_static")) break;
                char[] prefix = new char[indent];
                Arrays.fill(prefix, '\t');
                lines.add(new String(prefix) + "static");
            }
        }
    }

    static enum Element {
        PACKAGE,
        CLASS,
        FIELD,
        METHOD,
        PARAMETER;

    }

    static enum TinyV2State {
        ROOT,
        CLASS,
        FIELD,
        METHOD,
        PARAMETER;

    }
}

