/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.metadata;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.parchmentmc.feather.metadata.ImmutableRecordMetadata;
import org.parchmentmc.feather.metadata.RecordMetadata;
import org.parchmentmc.feather.metadata.Reference;
import org.parchmentmc.feather.metadata.ReferenceBuilder;
import org.parchmentmc.feather.named.Named;
import org.parchmentmc.feather.named.NamedBuilder;

public final class RecordMetadataBuilder
implements RecordMetadata {
    private Named owner = Named.empty();
    private Reference field = null;
    private Reference getter = null;

    private RecordMetadataBuilder() {
    }

    public static RecordMetadataBuilder create(RecordMetadata target) {
        if (target == null) {
            return RecordMetadataBuilder.create();
        }
        return RecordMetadataBuilder.create().withOwner(target.getOwner()).withField(target.getField()).withGetter(target.getGetter());
    }

    public static RecordMetadataBuilder create() {
        return new RecordMetadataBuilder();
    }

    public RecordMetadataBuilder withGetter(Reference getter) {
        this.getter = getter;
        return this;
    }

    public RecordMetadataBuilder withField(Reference field) {
        this.field = field;
        return this;
    }

    public RecordMetadataBuilder withOwner(Named owner) {
        this.owner = owner;
        return this;
    }

    @Override
    public @NonNull Named getOwner() {
        return this.owner;
    }

    @Override
    public Reference getField() {
        return this.field;
    }

    @Override
    public Reference getGetter() {
        return this.getter;
    }

    @Override
    public @NonNull RecordMetadata toImmutable() {
        return this.build();
    }

    public @NonNull RecordMetadataBuilder merge(RecordMetadata source) {
        if (source == null) {
            return this;
        }
        this.owner = NamedBuilder.create(this.owner).merge(source.getOwner()).build();
        this.field = ReferenceBuilder.create(this.field).merge(source.getField()).build();
        this.getter = ReferenceBuilder.create(this.getter).merge(source.getGetter()).build();
        return this;
    }

    public RecordMetadata build() {
        return new ImmutableRecordMetadata((Named)this.owner.toImmutable(), (Reference)this.field.toImmutable(), (Reference)this.getter.toImmutable());
    }
}

