/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.tokens;

import com.intellij.ide.highlighter.custom.tokens.KeywordParser;
import com.intellij.ide.highlighter.custom.tokens.TokenParser;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;

public class IdentifierParser
extends TokenParser {
    private final KeywordParser myKeywordParser;
    private final boolean myIsAdmittingQuote;

    public IdentifierParser(KeywordParser keywordParser) {
        this.myKeywordParser = keywordParser;
        this.myIsAdmittingQuote = ContainerUtil.exists(keywordParser.getAllKeywords(), it -> it.contains("'"));
    }

    @Override
    public boolean hasToken(int position) {
        if (!Character.isJavaIdentifierStart(this.myBuffer.charAt(position))) {
            return false;
        }
        int start = position++;
        while (position < this.myEndOffset && this.isIdentifierPart(position)) {
            ++position;
        }
        IElementType tokenType = CustomHighlighterTokenType.IDENTIFIER;
        this.myTokenInfo.updateData(start, position, tokenType);
        return true;
    }

    private boolean isIdentifierPart(int position) {
        if (this.myBuffer.charAt(position) == '-') {
            return !this.myKeywordParser.hasToken(position, this.myBuffer, null);
        }
        if (this.myBuffer.charAt(position) == '\'') {
            return this.myIsAdmittingQuote;
        }
        return Character.isJavaIdentifierPart(this.myBuffer.charAt(position));
    }
}

