/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.ClassLoaderConfiguratorKt;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.MainInfo;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.ide.plugins.cl.ResolveScopeManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.SmartList;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.ResourceFile;
import com.intellij.util.lang.UrlClassLoader;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\u0006\u0010\u001a\u001a\u00020\u0018J#\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u000eJ\u000e\u0010%\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u000eJ+\u0010&\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u000e2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\u0006\u0010)\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010*J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\u0018\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0015\u0010\u0016\u00a8\u00060"}, d2={"Lcom/intellij/ide/plugins/ClassLoaderConfigurator;", "", "pluginSet", "Lcom/intellij/ide/plugins/PluginSet;", "coreLoader", "Ljava/lang/ClassLoader;", "(Lcom/intellij/ide/plugins/PluginSet;Ljava/lang/ClassLoader;)V", "mainToClassPath", "Ljava/util/IdentityHashMap;", "Lcom/intellij/openapi/extensions/PluginId;", "Lcom/intellij/ide/plugins/MainInfo;", "pluginPackagePrefixUniqueGuard", "Ljava/util/HashMap;", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "getPluginSet", "()Lcom/intellij/ide/plugins/PluginSet;", "resourceFileFactory", "Ljava/util/function/Function;", "Ljava/nio/file/Path;", "Lcom/intellij/util/lang/ResourceFile;", "getResourceFileFactory$annotations", "()V", "checkPackagePrefixUniqueness", "", "module", "configure", "configureCorePluginModuleClassLoader", "deps", "", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;[Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;)V", "configureDependenciesInOldFormat", "mainDependentClassLoader", "configureDependency", "", "mainDescriptor", "moduleDescriptor", "configureModule", "createPluginClassLoader", "Lcom/intellij/ide/plugins/cl/PluginClassLoader;", "dependencies", "mainInfo", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;[Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;Lcom/intellij/ide/plugins/MainInfo;)Lcom/intellij/ide/plugins/cl/PluginClassLoader;", "getCoreUrlClassLoaderIfPossible", "Lcom/intellij/util/lang/UrlClassLoader;", "setPluginClassLoaderForModuleAndOldSubDescriptors", "rootDescriptor", "classLoader", "intellij.platform.core.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nClassLoaderConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassLoaderConfigurator.kt\ncom/intellij/ide/plugins/ClassLoaderConfigurator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,468:1\n1#2:469\n37#3,2:470\n12474#4,2:472\n*S KotlinDebug\n*F\n+ 1 ClassLoaderConfigurator.kt\ncom/intellij/ide/plugins/ClassLoaderConfigurator\n*L\n91#1:470,2\n142#1:472,2\n*E\n"})
public final class ClassLoaderConfigurator {
    @NotNull
    private final PluginSet pluginSet;
    @NotNull
    private final ClassLoader coreLoader;
    @NotNull
    private final HashMap<String, IdeaPluginDescriptorImpl> pluginPackagePrefixUniqueGuard;
    @Nullable
    private final Function<Path, ResourceFile> resourceFileFactory;
    @NotNull
    private final IdentityHashMap<PluginId, MainInfo> mainToClassPath;

    /*
     * WARNING - void declaration
     */
    public ClassLoaderConfigurator(@NotNull PluginSet pluginSet, @NotNull ClassLoader coreLoader) {
        Function function;
        ClassLoaderConfigurator classLoaderConfigurator;
        Intrinsics.checkNotNullParameter(pluginSet, "pluginSet");
        Intrinsics.checkNotNullParameter(coreLoader, "coreLoader");
        this.pluginSet = pluginSet;
        this.coreLoader = coreLoader;
        this.pluginPackagePrefixUniqueGuard = new HashMap();
        this.mainToClassPath = new IdentityHashMap();
        ClassLoaderConfigurator classLoaderConfigurator2 = this;
        try {
            classLoaderConfigurator = classLoaderConfigurator2;
            function = MethodHandles.lookup().findStatic(this.coreLoader.loadClass("com.intellij.util.lang.PathClassLoader"), "getResourceFileFactory", MethodType.methodType(Function.class)).invokeExact();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classLoaderConfigurator = classLoaderConfigurator2;
            function = null;
        }
        catch (Throwable ignore) {
            void e;
            classLoaderConfigurator = classLoaderConfigurator2;
            ClassLoaderConfiguratorKt.access$getLog().error((Throwable)e);
            function = null;
        }
        classLoaderConfigurator.resourceFileFactory = function;
    }

    public /* synthetic */ ClassLoaderConfigurator(PluginSet pluginSet, ClassLoader classLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ClassLoader classLoader2 = ClassLoaderConfigurator.class.getClassLoader();
            Intrinsics.checkNotNullExpressionValue(classLoader2, "getClassLoader(...)");
            classLoader = classLoader2;
        }
        this(pluginSet, classLoader);
    }

    @NotNull
    public final PluginSet getPluginSet() {
        return this.pluginSet;
    }

    private static /* synthetic */ void getResourceFileFactory$annotations() {
    }

    public final boolean configureDependency(@NotNull IdeaPluginDescriptorImpl mainDescriptor, @NotNull IdeaPluginDescriptorImpl moduleDescriptor) {
        Object v2;
        block7: {
            boolean bl;
            Intrinsics.checkNotNullParameter(mainDescriptor, "mainDescriptor");
            Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
            boolean bl2 = bl = !Intrinsics.areEqual(mainDescriptor, moduleDescriptor);
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-ClassLoaderConfigurator$configureDependency$32 = false;
                String $i$a$-assert-ClassLoaderConfigurator$configureDependency$32 = mainDescriptor + " != " + moduleDescriptor;
                throw new AssertionError((Object)$i$a$-assert-ClassLoaderConfigurator$configureDependency$32);
            }
            PluginId pluginId = mainDescriptor.getPluginId();
            boolean $i$a$-assert-ClassLoaderConfigurator$configureDependency$32 = Intrinsics.areEqual(pluginId, moduleDescriptor.getPluginId());
            if (_Assertions.ENABLED && !$i$a$-assert-ClassLoaderConfigurator$configureDependency$32) {
                boolean $i$a$-assert-ClassLoaderConfigurator$configureDependency$62 = false;
                String $i$a$-assert-ClassLoaderConfigurator$configureDependency$62 = "pluginId '" + pluginId + "' != moduleDescriptor.pluginId '" + moduleDescriptor.getPluginId() + '\'';
                throw new AssertionError((Object)$i$a$-assert-ClassLoaderConfigurator$configureDependency$62);
            }
            if (mainDescriptor.getPluginClassLoader() instanceof PluginClassLoader) {
                ClassLoader classLoader = mainDescriptor.getPluginClassLoader();
                Intrinsics.checkNotNull(classLoader, "null cannot be cast to non-null type com.intellij.ide.plugins.cl.PluginClassLoader");
                PluginClassLoader mainClassLoader = (PluginClassLoader)classLoader;
                this.mainToClassPath.put(pluginId, new MainInfo(mainClassLoader));
            }
            Iterable $i$a$-assert-ClassLoaderConfigurator$configureDependency$62 = mainDescriptor.pluginDependencies;
            for (Object t2 : $i$a$-assert-ClassLoaderConfigurator$configureDependency$62) {
                PluginDependency it = (PluginDependency)t2;
                boolean bl3 = false;
                if (!(it.subDescriptor == moduleDescriptor && it.isOptional())) continue;
                v2 = t2;
                break block7;
            }
            v2 = null;
        }
        if (v2 != null) {
            boolean bl;
            boolean mainClassLoader;
            boolean bl4 = mainClassLoader = moduleDescriptor.getPluginClassLoader() == null;
            if (_Assertions.ENABLED && !mainClassLoader) {
                boolean bl5 = false;
                String string2 = "sub descriptor " + moduleDescriptor + " of " + mainDescriptor + " seems to be already enabled";
                throw new AssertionError((Object)string2);
            }
            ClassLoader mainDependentClassLoader = mainDescriptor.getPluginClassLoader();
            boolean bl6 = bl = mainDependentClassLoader != null;
            if (_Assertions.ENABLED && !bl) {
                boolean bl7 = false;
                String string3 = "plugin " + mainDescriptor + " is not yet enabled";
                throw new AssertionError((Object)string3);
            }
            ClassLoader classLoader = mainDependentClassLoader;
            Intrinsics.checkNotNull(classLoader);
            moduleDescriptor.setPluginClassLoader(classLoader);
            this.configureDependenciesInOldFormat(moduleDescriptor, mainDependentClassLoader);
            return true;
        }
        return this.configureModule(moduleDescriptor);
    }

    public final void configure() {
        for (IdeaPluginDescriptorImpl module : this.pluginSet.getEnabledModules()) {
            this.configureModule(module);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean configureModule(@NotNull IdeaPluginDescriptorImpl module) {
        Intrinsics.checkNotNullParameter(module, "module");
        this.checkPackagePrefixUniqueness(module);
        boolean isMain = module.moduleName == null;
        Collection<IdeaPluginDescriptorImpl> collection = this.pluginSet.moduleGraph.getDependencies(module);
        boolean $i$f$toTypedArray = false;
        Collection<IdeaPluginDescriptorImpl> thisCollection$iv = collection;
        IdeaPluginDescriptorImpl[] dependencies = thisCollection$iv.toArray(new IdeaPluginDescriptorImpl[0]);
        ClassLoaderConfiguratorKt.sortDependenciesInPlace(dependencies);
        if (isMain) {
            void var4_6;
            if (module.useCoreClassLoader || Intrinsics.areEqual(module.getPluginId(), PluginManagerCore.CORE_ID)) {
                this.setPluginClassLoaderForModuleAndOldSubDescriptors(module, this.coreLoader);
                return true;
            }
            List<? extends Path> list = module.jarFiles;
            if (list == null) {
                if (!module.isUseIdeaClassLoader) {
                    ClassLoaderConfiguratorKt.access$getLog().error("jarFiles is not set for " + module);
                }
                List list2 = CollectionsKt.emptyList();
            }
            SmartList<String> libDirectories = new SmartList<String>();
            Path libDir = module.path.resolve("lib");
            if (Files.exists(libDir, new LinkOption[0])) {
                libDirectories.add(((Object)libDir.toAbsolutePath()).toString());
            }
            boolean mimicJarUrlConnection = !module.isBundled() && !Intrinsics.areEqual(module.getVendor(), "JetBrains");
            ClassPath pluginClassPath = new ClassPath((Collection)var4_6, ClassLoaderConfiguratorKt.access$getDEFAULT_CLASSLOADER_CONFIGURATION$p(), this.resourceFileFactory, mimicJarUrlConnection);
            MainInfo mainInfo = new MainInfo(pluginClassPath, (List<? extends Path>)var4_6, (List<String>)libDirectories);
            MainInfo existing = this.mainToClassPath.put(module.getPluginId(), mainInfo);
            if (existing != null) {
                ClassLoaderConfiguratorKt.access$getLog().error(new PluginException("Main module with " + module.getPluginId() + " is already added (existingClassPath=" + existing.files, module.getPluginId()));
            }
            ClassLoader mainDependentClassLoader = module.isUseIdeaClassLoader ? ClassLoaderConfiguratorKt.access$configureUsingIdeaClassloader(mainInfo.files, module) : (ClassLoader)this.createPluginClassLoader(module, dependencies, mainInfo);
            module.setPluginClassLoader(mainDependentClassLoader);
            this.configureDependenciesInOldFormat(module, mainDependentClassLoader);
            return true;
        } else {
            if (module.packagePrefix == null) {
                throw new PluginException("Package is not specified (module=" + module + ')', module.getPluginId());
            }
            boolean bl = module.pluginDependencies.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-ClassLoaderConfigurator$configureModule$22 = false;
                String $i$a$-assert-ClassLoaderConfigurator$configureModule$22 = "Module " + module + " shouldn't have plugin dependencies: " + module.pluginDependencies;
                throw new AssertionError((Object)$i$a$-assert-ClassLoaderConfigurator$configureModule$22);
            }
            IdeaPluginDescriptorImpl[] ideaPluginDescriptorImplArray = dependencies;
            boolean $i$f$any = false;
            int n = ideaPluginDescriptorImplArray.length;
            for (int i = 0; i < n; ++i) {
                IdeaPluginDescriptorImpl element$iv;
                IdeaPluginDescriptorImpl it = element$iv = ideaPluginDescriptorImplArray[i];
                boolean bl2 = false;
                if (it.getPluginClassLoader() == null) {
                    return false;
                }
                boolean bl3 = false;
                if (!bl3) continue;
                return false;
            }
            boolean bl4 = false;
            if (bl4) {
                return false;
            }
            if (module.useCoreClassLoader) {
                module.setPluginClassLoader(this.coreLoader);
                return true;
            }
            MainInfo mainInfo = this.mainToClassPath.get(module.getPluginId());
            if (mainInfo == null) {
                if (!Intrinsics.areEqual(module.getPluginId(), PluginManagerCore.CORE_ID)) throw new PluginException("Cannot find containing plugin " + module.getPluginId() + " for module " + module.moduleName + ' ', module.getPluginId());
                this.configureCorePluginModuleClassLoader(module, dependencies);
                return true;
            } else {
                module.setPluginClassLoader(new PluginClassLoader(mainInfo.classPath, dependencies, module, this.coreLoader, ClassLoaderConfiguratorKt.access$createModuleResolveScopeManager(), module.packagePrefix, mainInfo.libDirectories));
            }
        }
        return true;
    }

    private final void configureDependenciesInOldFormat(IdeaPluginDescriptorImpl module, ClassLoader mainDependentClassLoader) {
        for (PluginDependency dependency : module.pluginDependencies) {
            IdeaPluginDescriptorImpl subDescriptor;
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl;
            if (dependency.subDescriptor == null) continue;
            if (this.pluginSet.findEnabledPlugin(dependency.getPluginId()) != null) {
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl2;
                IdeaPluginDescriptorImpl it = ideaPluginDescriptorImpl2;
                boolean bl = false;
                ideaPluginDescriptorImpl = it != module ? ideaPluginDescriptorImpl2 : null;
            } else {
                ideaPluginDescriptorImpl = null;
            }
            if (ideaPluginDescriptorImpl == null) continue;
            subDescriptor.setPluginClassLoader(mainDependentClassLoader);
            this.configureDependenciesInOldFormat(subDescriptor, mainDependentClassLoader);
        }
    }

    private final void configureCorePluginModuleClassLoader(IdeaPluginDescriptorImpl module, IdeaPluginDescriptorImpl[] deps) {
        UrlClassLoader coreUrlClassLoader = this.getCoreUrlClassLoaderIfPossible(module);
        if (coreUrlClassLoader == null) {
            this.setPluginClassLoaderForModuleAndOldSubDescriptors(module, this.coreLoader);
            return;
        }
        ClassPath classPath = coreUrlClassLoader.getClassPath();
        Intrinsics.checkNotNullExpressionValue(classPath, "getClassPath(...)");
        module.setPluginClassLoader(new PluginClassLoader(classPath, deps, module, this.coreLoader, ClassLoaderConfiguratorKt.access$createModuleResolveScopeManager(), module.packagePrefix, new ArrayList()));
    }

    private final UrlClassLoader getCoreUrlClassLoaderIfPossible(IdeaPluginDescriptorImpl module) {
        UrlClassLoader coreUrlClassLoader;
        ClassLoader classLoader = this.coreLoader;
        UrlClassLoader urlClassLoader = coreUrlClassLoader = classLoader instanceof UrlClassLoader ? (UrlClassLoader)classLoader : null;
        if (coreUrlClassLoader == null) {
            if (!Boolean.getBoolean("idea.use.core.classloader.for.plugin.path")) {
                ClassLoaderConfiguratorKt.access$getLog().error("You must run JVM with -Djava.system.class.loader=com.intellij.util.lang.PathClassLoader");
            }
            this.setPluginClassLoaderForModuleAndOldSubDescriptors(module, this.coreLoader);
            return null;
        }
        if (coreUrlClassLoader.resolveScopeManager == null) {
            IdeaPluginDescriptorImpl corePlugin = CollectionsKt.first(this.pluginSet.enabledPlugins);
            boolean bl = Intrinsics.areEqual(corePlugin.getPluginId(), PluginManagerCore.CORE_ID);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            ResolveScopeManager resolveScopeManager = ClassLoaderConfiguratorKt.createPluginDependencyAndContentBasedScope(corePlugin, this.pluginSet);
            if (resolveScopeManager != null) {
                coreUrlClassLoader.resolveScopeManager = (arg_0, arg_1) -> ClassLoaderConfigurator.getCoreUrlClassLoaderIfPossible$lambda$8(resolveScopeManager, arg_0, arg_1);
            }
        }
        return coreUrlClassLoader;
    }

    private final void setPluginClassLoaderForModuleAndOldSubDescriptors(IdeaPluginDescriptorImpl rootDescriptor, ClassLoader classLoader) {
        rootDescriptor.setPluginClassLoader(classLoader);
        for (PluginDependency dependency : rootDescriptor.pluginDependencies) {
            IdeaPluginDescriptorImpl subDescriptor = dependency.subDescriptor;
            if (subDescriptor == null || !this.pluginSet.isPluginEnabled(dependency.getPluginId())) continue;
            this.setPluginClassLoaderForModuleAndOldSubDescriptors(subDescriptor, classLoader);
        }
    }

    private final void checkPackagePrefixUniqueness(IdeaPluginDescriptorImpl module) {
        IdeaPluginDescriptorImpl old;
        String packagePrefix = module.packagePrefix;
        if (packagePrefix != null && (old = this.pluginPackagePrefixUniqueGuard.putIfAbsent(packagePrefix, module)) != null) {
            throw new PluginException("Package prefix " + packagePrefix + " is already used (second=" + module + ", first=" + old + ')', module.getPluginId());
        }
    }

    /*
     * Unable to fully structure code
     */
    private final PluginClassLoader createPluginClassLoader(IdeaPluginDescriptorImpl module, IdeaPluginDescriptorImpl[] dependencies, MainInfo mainInfo) {
        block6: {
            block4: {
                block5: {
                    resolveScopeManager = null;
                    if (module.moduleName != null) break block4;
                    var5_5 = module.getPluginId().getIdString();
                    switch (var5_5.hashCode()) {
                        case 499732893: {
                            if (var5_5.equals("com.intellij.properties")) break;
                            ** break;
                        }
                        case 929174697: {
                            if (!var5_5.equals("com.intellij.diagram")) ** break;
                            v0 = ClassLoaderConfiguratorKt.access$createScopeWithExtraPackage("com.intellij.diagram.");
                            break block5;
                        }
                    }
                    v0 = new ResolveScopeManager(){

                        @Nullable
                        public String isDefinitelyAlienClass(@NotNull String name, @NotNull String packagePrefix, boolean force) {
                            Intrinsics.checkNotNullParameter(name, "name");
                            Intrinsics.checkNotNullParameter(packagePrefix, "packagePrefix");
                            if (force) {
                                return null;
                            }
                            if (!(StringsKt.startsWith$default(name, packagePrefix, false, 2, null) || StringsKt.startsWith$default(name, "com.intellij.ultimate.PluginVerifier", false, 2, null) || Intrinsics.areEqual(name, "com.intellij.codeInspection.unused.ImplicitPropertyUsageProvider"))) {
                                return "";
                            }
                            return null;
                        }
                    };
                    break block5;
lbl14:
                    // 3 sources

                    v0 = ClassLoaderConfiguratorKt.createPluginDependencyAndContentBasedScope(module, this.pluginSet);
                }
                resolveScopeManager = v0;
                break block6;
            }
            resolveScopeManager = module.content.modules.isEmpty() != false ? ClassLoaderConfiguratorKt.access$createModuleResolveScopeManager() : ClassLoaderConfiguratorKt.access$createModuleContentBasedScope(module);
        }
        return new PluginClassLoader(mainInfo.classPath, dependencies, module, this.coreLoader, resolveScopeManager, module.packagePrefix, mainInfo.libDirectories);
    }

    private static final String getCoreUrlClassLoaderIfPossible$lambda$8(ResolveScopeManager $resolveScopeManager, String name, Boolean force) {
        Intrinsics.checkNotNull(name);
        Intrinsics.checkNotNull(force);
        return $resolveScopeManager.isDefinitelyAlienClass(name, "", force);
    }
}

