/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.java.parser.BasicJavaParser;
import com.intellij.lang.java.parser.BasicJavaParserUtil;
import com.intellij.openapi.util.Key;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.AbstractBasicJavaDocElementTypeFactory;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicJavaDocParser {
    private static final TokenSet TAG_VALUES_SET = TokenSet.create(JavaDocTokenType.DOC_TAG_VALUE_TOKEN, JavaDocTokenType.DOC_TAG_VALUE_COMMA, JavaDocTokenType.DOC_TAG_VALUE_DOT, JavaDocTokenType.DOC_TAG_VALUE_LPAREN, JavaDocTokenType.DOC_TAG_VALUE_RPAREN, JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN, JavaDocTokenType.DOC_TAG_VALUE_LT, JavaDocTokenType.DOC_TAG_VALUE_GT, JavaDocTokenType.DOC_TAG_VALUE_COLON, JavaDocTokenType.DOC_TAG_VALUE_QUOTE);
    private static final TokenSet INLINE_TAG_BORDERS_SET = TokenSet.create(JavaDocTokenType.DOC_INLINE_TAG_START, JavaDocTokenType.DOC_INLINE_TAG_END);
    private static final TokenSet SKIP_TOKENS = TokenSet.create(JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS);
    private static final String SEE_TAG = "@see";
    private static final String LINK_TAG = "@link";
    private static final String LINK_PLAIN_TAG = "@linkplain";
    private static final String PARAM_TAG = "@param";
    private static final String VALUE_TAG = "@value";
    private static final String SNIPPET_TAG = "@snippet";
    private static final Set<String> REFERENCE_TAGS = ContainerUtil.immutableSet("@throws", "@exception", "@provides", "@uses");
    private static final Key<Integer> BRACE_SCOPE_KEY = Key.create("Javadoc.Parser.Brace.Scope");

    private BasicJavaDocParser() {
    }

    public static void parseJavadocReference(@NotNull PsiBuilder builder, @NotNull BasicJavaParser parser) {
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(0);
        }
        if (parser == null) {
            BasicJavaDocParser.$$$reportNull$$$0(1);
        }
        parser.getReferenceParser().parseJavaCodeReference(builder, true, true, false, false);
        BasicJavaDocParser.swallowTokens(builder);
    }

    public static void parseJavadocType(@NotNull PsiBuilder builder, @NotNull BasicJavaParser parser) {
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(2);
        }
        if (parser == null) {
            BasicJavaDocParser.$$$reportNull$$$0(3);
        }
        parser.getReferenceParser().parseType(builder, 7);
        BasicJavaDocParser.swallowTokens(builder);
    }

    private static void swallowTokens(PsiBuilder builder) {
        while (!builder.eof()) {
            builder.advanceLexer();
        }
    }

    public static void parseDocCommentText(@NotNull PsiBuilder builder, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(4);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(5);
        }
        builder.enforceCommentTokens(SKIP_TOKENS);
        while (!builder.eof()) {
            IElementType tokenType = BasicJavaDocParser.getTokenType(builder);
            if (tokenType == JavaDocTokenType.DOC_TAG_NAME) {
                BasicJavaDocParser.parseTag(builder, javaDocElementTypeContainer);
                continue;
            }
            BasicJavaDocParser.parseDataItem(builder, null, false, javaDocElementTypeContainer);
        }
    }

    private static void parseTag(PsiBuilder builder, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        IElementType tokenType;
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(6);
        }
        String tagName = builder.getTokenText();
        PsiBuilder.Marker tag = builder.mark();
        builder.advanceLexer();
        while ((tokenType = BasicJavaDocParser.getTokenType(builder)) != null && tokenType != JavaDocTokenType.DOC_TAG_NAME && tokenType != JavaDocTokenType.DOC_COMMENT_END) {
            BasicJavaDocParser.parseDataItem(builder, tagName, false, javaDocElementTypeContainer);
        }
        tag.done(javaDocElementTypeContainer.DOC_TAG);
    }

    private static void parseDataItem(PsiBuilder builder, @Nullable String tagName, boolean isInline, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        IElementType tokenType;
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(7);
        }
        if ((tokenType = BasicJavaDocParser.getTokenType(builder)) == JavaDocTokenType.DOC_INLINE_TAG_START) {
            int braceScope = BasicJavaDocParser.getBraceScope(builder);
            if (braceScope > 0) {
                BasicJavaDocParser.setBraceScope(builder, braceScope + 1);
                builder.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
                builder.advanceLexer();
                return;
            }
            PsiBuilder.Marker tag = builder.mark();
            builder.advanceLexer();
            tokenType = BasicJavaDocParser.getTokenType(builder);
            if (tokenType != JavaDocTokenType.DOC_TAG_NAME && tokenType != JavaDocTokenType.DOC_COMMENT_BAD_CHARACTER) {
                tag.rollbackTo();
                builder.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
                builder.advanceLexer();
                return;
            }
            BasicJavaDocParser.setBraceScope(builder, braceScope + 1);
            String inlineTagName = "";
            while (true) {
                if ((tokenType = BasicJavaDocParser.getTokenType(builder)) == JavaDocTokenType.DOC_TAG_NAME) {
                    inlineTagName = builder.getTokenText();
                } else if (tokenType == null || tokenType == JavaDocTokenType.DOC_COMMENT_END) break;
                BasicJavaDocParser.parseDataItem(builder, inlineTagName, true, javaDocElementTypeContainer);
                if (tokenType != JavaDocTokenType.DOC_INLINE_TAG_END) continue;
                braceScope = BasicJavaDocParser.getBraceScope(builder);
                if (braceScope > 0) {
                    BasicJavaDocParser.setBraceScope(builder, --braceScope);
                }
                if (braceScope == 0) break;
            }
            if (SNIPPET_TAG.equals(inlineTagName)) {
                tag.done(javaDocElementTypeContainer.DOC_SNIPPET_TAG);
            } else {
                tag.done(javaDocElementTypeContainer.DOC_INLINE_TAG);
            }
        } else if (TAG_VALUES_SET.contains(tokenType)) {
            if (SEE_TAG.equals(tagName) && !isInline || LINK_TAG.equals(tagName) && isInline || BasicJavaParserUtil.getLanguageLevel(builder).isAtLeast(LanguageLevel.JDK_1_4) && LINK_PLAIN_TAG.equals(tagName) && isInline) {
                BasicJavaDocParser.parseSeeTagValue(builder, false, javaDocElementTypeContainer);
            } else if (!isInline && tagName != null && REFERENCE_TAGS.contains(tagName)) {
                PsiBuilder.Marker tagValue = builder.mark();
                builder.remapCurrentToken(javaDocElementTypeContainer.DOC_REFERENCE_HOLDER);
                builder.advanceLexer();
                tagValue.done(javaDocElementTypeContainer.DOC_TAG_VALUE_ELEMENT);
            } else if (!isInline && PARAM_TAG.equals(tagName)) {
                BasicJavaDocParser.parseParameterRef(builder, javaDocElementTypeContainer);
            } else if (BasicJavaParserUtil.getLanguageLevel(builder).isAtLeast(LanguageLevel.JDK_1_5) && VALUE_TAG.equals(tagName) && isInline) {
                BasicJavaDocParser.parseSeeTagValue(builder, true, javaDocElementTypeContainer);
            } else if (SNIPPET_TAG.equals(tagName) && isInline) {
                BasicJavaDocParser.parseSnippetTagValue(builder, javaDocElementTypeContainer);
            } else {
                BasicJavaDocParser.parseSimpleTagValue(builder, javaDocElementTypeContainer);
            }
        } else {
            BasicJavaDocParser.remapAndAdvance(builder);
        }
    }

    private static void parseSnippetTagValue(@NotNull PsiBuilder builder, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        IElementType token2;
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(8);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(9);
        }
        PsiBuilder.Marker snippetValue = builder.mark();
        snippetValue.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        while ((token2 = BasicJavaDocParser.getTokenType(builder)) == JavaDocTokenType.DOC_TAG_VALUE_QUOTE) {
            builder.advanceLexer();
        }
        IElementType tokenType = BasicJavaDocParser.getTokenType(builder);
        if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_COLON) {
            BasicJavaParserUtil.emptyElement(builder, javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE_LIST);
            BasicJavaDocParser.parseSnippetTagBody(builder, javaDocElementTypeContainer);
        } else if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
            BasicJavaDocParser.parseSnippetAttributeList(builder, javaDocElementTypeContainer);
            if (builder.getTokenType() == JavaDocTokenType.DOC_TAG_VALUE_COLON) {
                BasicJavaDocParser.parseSnippetTagBody(builder, javaDocElementTypeContainer);
            }
        } else {
            BasicJavaParserUtil.emptyElement(builder, javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE_LIST);
            IElementType current = BasicJavaDocParser.getTokenType(builder);
            while (current != null && current != JavaDocTokenType.DOC_INLINE_TAG_END) {
                builder.advanceLexer();
                current = BasicJavaDocParser.getTokenType(builder);
            }
        }
        snippetValue.done(javaDocElementTypeContainer.DOC_SNIPPET_TAG_VALUE);
    }

    private static void parseSnippetTagBody(@NotNull PsiBuilder builder, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        IElementType tokenType;
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(10);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(11);
        }
        PsiBuilder.Marker body = builder.mark();
        body.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        assert (BasicJavaDocParser.getTokenType(builder) == JavaDocTokenType.DOC_TAG_VALUE_COLON);
        builder.advanceLexer();
        while ((tokenType = BasicJavaDocParser.getTokenType(builder)) != null && tokenType != JavaDocTokenType.DOC_INLINE_TAG_END) {
            builder.advanceLexer();
        }
        body.done(javaDocElementTypeContainer.DOC_SNIPPET_BODY);
    }

    private static void parseSnippetAttributeList(@NotNull PsiBuilder builder, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(12);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(13);
        }
        PsiBuilder.Marker attributeList = builder.mark();
        block0: while (true) {
            IElementType type = BasicJavaDocParser.getTokenType(builder);
            while (type != JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
                if (type != JavaDocTokenType.DOC_TAG_VALUE_QUOTE) break block0;
                builder.advanceLexer();
                type = BasicJavaDocParser.getTokenType(builder);
            }
            BasicJavaDocParser.parseSnippetAttribute(builder, javaDocElementTypeContainer);
        }
        attributeList.done(javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE_LIST);
    }

    private static void parseSnippetAttribute(@NotNull PsiBuilder builder, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(14);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(15);
        }
        PsiBuilder.Marker attribute = builder.mark();
        assert (builder.getTokenType() == JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
        builder.remapCurrentToken(JavaDocTokenType.DOC_TAG_ATTRIBUTE_NAME);
        builder.advanceLexer();
        BasicJavaDocParser.getTokenType(builder);
        if ("=".equals(builder.getTokenText())) {
            builder.advanceLexer();
            IElementType afterEqToken = BasicJavaDocParser.getTokenType(builder);
            if (afterEqToken == JavaDocTokenType.DOC_TAG_VALUE_QUOTE) {
                PsiBuilder.Marker quotedValue = builder.mark();
                builder.advanceLexer();
                if (BasicJavaDocParser.getTokenType(builder) == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
                    builder.advanceLexer();
                }
                if (BasicJavaDocParser.getTokenType(builder) == JavaDocTokenType.DOC_TAG_VALUE_QUOTE) {
                    builder.advanceLexer();
                }
                quotedValue.collapse(javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE_VALUE);
            } else if (afterEqToken == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
                builder.remapCurrentToken(javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE_VALUE);
                builder.advanceLexer();
            }
        }
        attribute.done(javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE);
    }

    private static void parseSeeTagValue(@NotNull PsiBuilder builder, boolean allowBareFieldReference, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        IElementType tokenType;
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(16);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(17);
        }
        if ((tokenType = BasicJavaDocParser.getTokenType(builder)) == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            BasicJavaDocParser.parseMethodRef(builder, builder.mark(), javaDocElementTypeContainer);
        } else if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
            PsiBuilder.Marker refStart = builder.mark();
            builder.remapCurrentToken(javaDocElementTypeContainer.DOC_REFERENCE_HOLDER);
            builder.advanceLexer();
            if (BasicJavaDocParser.getTokenType(builder) == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
                BasicJavaDocParser.parseMethodRef(builder, refStart, javaDocElementTypeContainer);
            } else if (allowBareFieldReference) {
                refStart.rollbackTo();
                builder.remapCurrentToken(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
                BasicJavaDocParser.parseMethodRef(builder, builder.mark(), javaDocElementTypeContainer);
            } else {
                refStart.drop();
            }
        } else {
            PsiBuilder.Marker tagValue = builder.mark();
            builder.advanceLexer();
            tagValue.done(javaDocElementTypeContainer.DOC_TAG_VALUE_ELEMENT);
        }
    }

    private static void parseMethodRef(@NotNull PsiBuilder builder, @NotNull PsiBuilder.Marker refStart, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(18);
        }
        if (refStart == null) {
            BasicJavaDocParser.$$$reportNull$$$0(19);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(20);
        }
        if (BasicJavaDocParser.getTokenType(builder) == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            builder.advanceLexer();
        }
        if (BasicJavaDocParser.getTokenType(builder) != JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
            refStart.done(javaDocElementTypeContainer.DOC_METHOD_OR_FIELD_REF);
            return;
        }
        builder.advanceLexer();
        if (BasicJavaDocParser.getTokenType(builder) == JavaDocTokenType.DOC_TAG_VALUE_LPAREN) {
            IElementType tokenType;
            builder.advanceLexer();
            PsiBuilder.Marker subValue = builder.mark();
            while (TAG_VALUES_SET.contains(tokenType = BasicJavaDocParser.getTokenType(builder))) {
                if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
                    builder.remapCurrentToken(javaDocElementTypeContainer.DOC_TYPE_HOLDER);
                    builder.advanceLexer();
                    while (TAG_VALUES_SET.contains(tokenType = BasicJavaDocParser.getTokenType(builder)) && tokenType != JavaDocTokenType.DOC_TAG_VALUE_COMMA && tokenType != JavaDocTokenType.DOC_TAG_VALUE_RPAREN) {
                        builder.advanceLexer();
                    }
                    continue;
                }
                if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_RPAREN) {
                    subValue.done(javaDocElementTypeContainer.DOC_TAG_VALUE_ELEMENT);
                    builder.advanceLexer();
                    refStart.done(javaDocElementTypeContainer.DOC_METHOD_OR_FIELD_REF);
                    return;
                }
                builder.advanceLexer();
            }
            subValue.done(javaDocElementTypeContainer.DOC_TAG_VALUE_ELEMENT);
        }
        refStart.done(javaDocElementTypeContainer.DOC_METHOD_OR_FIELD_REF);
    }

    private static void parseParameterRef(@NotNull PsiBuilder builder, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(21);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(22);
        }
        PsiBuilder.Marker tagValue = builder.mark();
        while (TAG_VALUES_SET.contains(BasicJavaDocParser.getTokenType(builder))) {
            builder.advanceLexer();
        }
        tagValue.done(javaDocElementTypeContainer.DOC_PARAMETER_REF);
    }

    private static void parseSimpleTagValue(@NotNull PsiBuilder builder, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder == null) {
            BasicJavaDocParser.$$$reportNull$$$0(23);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(24);
        }
        PsiBuilder.Marker tagData = builder.mark();
        while (true) {
            IElementType tokenType;
            if ((tokenType = BasicJavaDocParser.getTokenType(builder)) == JavaDocTokenType.DOC_COMMENT_BAD_CHARACTER) {
                builder.remapCurrentToken(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
            } else if (!TAG_VALUES_SET.contains(tokenType)) break;
            builder.advanceLexer();
        }
        tagData.done(javaDocElementTypeContainer.DOC_TAG_VALUE_ELEMENT);
    }

    @Nullable
    private static IElementType getTokenType(PsiBuilder builder) {
        IElementType tokenType;
        while ((tokenType = builder.getTokenType()) == JavaDocTokenType.DOC_SPACE) {
            builder.remapCurrentToken(TokenType.WHITE_SPACE);
            builder.advanceLexer();
        }
        return tokenType;
    }

    private static int getBraceScope(PsiBuilder builder) {
        Integer braceScope = builder.getUserData(BRACE_SCOPE_KEY);
        return braceScope != null ? braceScope : 0;
    }

    private static void setBraceScope(PsiBuilder builder, int braceScope) {
        builder.putUserData(BRACE_SCOPE_KEY, braceScope);
    }

    private static void remapAndAdvance(PsiBuilder builder) {
        if (INLINE_TAG_BORDERS_SET.contains(builder.getTokenType()) && BasicJavaDocParser.getBraceScope(builder) != 1) {
            builder.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
        }
        builder.advanceLexer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaDocElementTypeContainer";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refStart";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/java/parser/BasicJavaDocParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseJavadocReference";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parseJavadocType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "parseDocCommentText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "parseTag";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "parseDataItem";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSnippetTagValue";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSnippetTagBody";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSnippetAttributeList";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSnippetAttribute";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSeeTagValue";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "parseMethodRef";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "parseParameterRef";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSimpleTagValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

